/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.spjfile;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import jmri.jmrix.loconet.sdf.SdfBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpjFile {
    String[] mapCache = null;
    File file;
    FirstHeader h0;
    Header[] headers;
    private static final Logger log = LoggerFactory.getLogger(SpjFile.class);

    public SpjFile(File file) {
        this.file = file;
    }

    public int numHeaders() {
        if (this.headers != null && this.h0 != null) {
            return this.h0.numHeaders();
        }
        return -1;
    }

    public String getComment() {
        return this.h0.getComment();
    }

    public Header getHeader(int index) {
        return this.headers[index];
    }

    public Header findSdfHeader() {
        int n = this.numHeaders();
        int i = 1;
        while (i < n) {
            if (this.headers[i].isSDF()) {
                return this.headers[i];
            }
            ++i;
        }
        return null;
    }

    public String getMapEntry(int i) {
        log.debug("getMapEntry({})", (Object)i);
        this.loadMapCache();
        String wanted = i + " ";
        int j = 0;
        while (j < this.mapCache.length) {
            if (this.mapCache[j].startsWith(wanted)) {
                return this.mapCache[j].substring(wanted.length());
            }
            ++j;
        }
        return null;
    }

    void loadMapCache() {
        if (this.mapCache != null) {
            return;
        }
        log.debug("loading map cache");
        int map = 1;
        while (map < this.numHeaders()) {
            if (this.headers[map].isMap()) break;
            ++map;
        }
        if (map > this.numHeaders()) {
            log.error("Did not find map data");
            return;
        }
        byte[] buffer = this.headers[map].getByteArray();
        log.debug("map buffer length {}", (Object)buffer.length);
        int count = 0;
        int i = 0;
        while (i < buffer.length) {
            if (buffer[i] == 13) {
                ++count;
            }
            ++i;
        }
        this.mapCache = new String[count];
        log.debug("found {} map entries", (Object)count);
        int start = 0;
        int end = 0;
        int index = 0;
        log.debug("start loop over map with buffer length = {}", (Object)buffer.length);
        while (++end < buffer.length) {
            if (buffer[end] != 13 && buffer[end] != 10) continue;
            String next = new String(buffer, start, end - start);
            start = ++end;
            log.debug("new start value is {}", (Object)start);
            log.debug("new end value is   {}", (Object)end);
            if (buffer[end - 1] == 13 || end < buffer.length && buffer[end] == 10 || buffer[end - 1] == 10 || end < buffer.length && buffer[end] == 13) {
                ++start;
                ++end;
            }
            log.debug(" store entry {}", (Object)index);
            this.mapCache[index++] = next;
        }
    }

    public void save(String name) throws IOException {
        if (name == null) {
            throw new IOException("Null name during write");
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedOutputStream s = new BufferedOutputStream(new FileOutputStream(new File(name)));){
            int length = 128 * this.h0.numHeaders();
            int i = 1;
            while (i < this.h0.numHeaders()) {
                length += this.headers[i].getRecordLength();
                ++i;
            }
            byte[] buffer = new byte[length];
            int i2 = 0;
            while (i2 < length) {
                buffer[i2] = 0;
                ++i2;
            }
            int index = 0;
            if ((index = this.h0.store(buffer, index)) != 128) {
                log.error("Unexpected 1st header length: {}", (Object)index);
            }
            int datastart = index * this.h0.numHeaders();
            int i3 = 1;
            while (i3 < this.h0.numHeaders()) {
                this.headers[i3].updateStart(datastart);
                datastart += this.headers[i3].getRecordLength();
                index = this.headers[i3].store(buffer, index);
                ++i3;
            }
            i3 = 1;
            while (i3 < this.h0.numHeaders()) {
                byte[] content;
                int start = this.headers[i3].getRecordStart();
                int count = this.headers[i3].getRecordLength();
                if (count != (content = this.headers[i3].getByteArray()).length) {
                    log.error("header count {} != content length {}", (Object)count, (Object)content.length);
                }
                int j = 0;
                while (j < count) {
                    buffer[start + j] = content[j];
                    ++j;
                }
                ++i3;
            }
            ((OutputStream)s).write(buffer);
            ((OutputStream)s).close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void read() throws IOException {
        int n;
        if (this.file == null) {
            throw new IOException("Null file during read");
        }
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (BufferedInputStream s = new BufferedInputStream(new FileInputStream(this.file));){
            this.h0 = new FirstHeader();
            this.h0.load(s);
            if (log.isDebugEnabled()) {
                log.debug(this.h0.toString());
            }
            n = this.h0.numHeaders();
            this.headers = new Header[n];
            this.headers[0] = this.h0;
            int i = 1;
            while (i < n) {
                this.headers[i] = new Header();
                this.headers[i].load(s);
                log.debug("Header {} {}", (Object)i, (Object)this.headers[i].toString());
                ++i;
            }
            i = 1;
            while (i < n) {
                if (log.isDebugEnabled()) {
                    log.debug("Header {}  length {} type {}", new Object[]{i, this.headers[i].getDataLength(), this.headers[i].getType()});
                }
                if (this.headers[i].getDataLength() > this.headers[i].getRecordLength()) {
                    log.error("header {} has data length {} greater than record length {}", new Object[]{i, this.headers[i].getDataLength(), this.headers[i].getRecordLength()});
                }
                int j = 1;
                while (j < i) {
                    if (this.headers[i].getHandle() == this.headers[j].getHandle() && this.headers[i].getType() == 1 && this.headers[j].getType() == 1) {
                        log.error("Duplicate handle number in records {}({}) and {}({})", new Object[]{i, this.headers[i].getHandle(), j, this.headers[j].getHandle()});
                    }
                    ++j;
                }
                if (this.headers[i].getType() > 6) {
                    log.error("Type field unexpected value: {}", (Object)this.headers[i].getType());
                }
                if (this.headers[i].getType() == 0) {
                    log.error("Type field unexpected value: {}", (Object)this.headers[i].getType());
                }
                if (this.headers[i].getType() < -1) {
                    log.error("Type field unexpected value: {}", (Object)this.headers[i].getType());
                }
                ++i;
            }
            int length = 0;
            int i2 = 1;
            while (i2 < n) {
                if (length < this.headers[i2].getRecordStart() + this.headers[i2].getRecordLength()) {
                    length = this.headers[i2].getRecordStart() + this.headers[i2].getRecordLength();
                }
                ++i2;
            }
            log.debug("Last byte at {}", (Object)length);
            ((InputStream)s).close();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        int i = 1;
        while (i < n) {
            throwable2 = null;
            Object var4_7 = null;
            try (BufferedInputStream s = new BufferedInputStream(new FileInputStream(this.file));){
                byte[] array;
                int read;
                long count = ((InputStream)s).skip(this.headers[i].getRecordStart());
                if (count != (long)this.headers[i].getRecordStart()) {
                    log.warn("Only skipped {} characters, should have skipped {}", (Object)count, (Object)this.headers[i].getRecordStart());
                }
                if ((read = ((InputStream)s).read(array = new byte[this.headers[i].getRecordLength()])) != this.headers[i].getRecordLength()) {
                    log.error("header {} read {}, expected {}", new Object[]{i, read, this.headers[i].getRecordLength()});
                }
                this.headers[i].setByteArray(array);
                ((InputStream)s).close();
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            ++i;
        }
    }

    public void writeSubFiles() throws IOException {
        int n = this.numHeaders();
        int i = 1;
        while (i < n) {
            if (this.headers[i].isWAV()) {
                this.writeSubFile(i, i + ".wav");
            } else if (this.headers[i].isSDF()) {
                this.writeSubFile(i, i + ".sdf");
            } else if (this.headers[i].getType() == 3) {
                this.writeSubFile(i, i + ".cv");
            } else if (this.headers[i].getType() == 4) {
                this.writeSubFile(i, i + ".txt");
            } else if (this.headers[i].isMap()) {
                this.writeSubFile(i, i + ".map");
            } else if (this.headers[i].getType() == 6) {
                this.writeSubFile(i, i + ".uwav");
            }
            ++i;
        }
    }

    void writeSubFile(int i, String name) throws IOException {
        File outfile = new File(name);
        try (FileOutputStream ostream = new FileOutputStream(outfile);){
            ((OutputStream)ostream).write(this.headers[i].getByteArray());
        }
    }

    public void dispose() {
    }

    class FirstHeader
    extends Header {
        FirstHeader() {
        }

        int numHeaders() {
            return this.dataStart / 128;
        }

        float version() {
            return (float)this.recordStart / 100.0f;
        }

        String getComment() {
            return this.filename;
        }

        @Override
        public String toString() {
            return "initial record, version=" + this.version() + " num headers = " + this.numHeaders() + ", comment= " + this.filename;
        }
    }

    public class Header {
        static final int HEADERSIZE = 128;
        int type;
        int handle;
        int recordStart;
        int dataStart;
        int dataLength;
        int recordLength;
        int time;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        int spare1;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        int spare2;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        int spare3;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        int spare4;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        int spare5;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        int spare6;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        int spare7;
        String filename;
        byte[] bytes;
        SdfBuffer sdfBuffer = null;

        public int getType() {
            return this.type;
        }

        public int getHandle() {
            return this.handle;
        }

        public int getDataStart() {
            return this.dataStart;
        }

        public void setDataStart(int i) {
            this.dataStart = i;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        private void setDataLength(int i) {
            this.dataLength = i;
        }

        public int getRecordStart() {
            return this.recordStart;
        }

        public void setRecordStart(int i) {
            this.recordStart = i;
        }

        public int getRecordLength() {
            if (this.sdfBuffer != null) {
                this.sdfBuffer.loadByteArray();
                byte[] a = this.sdfBuffer.getByteArray();
                this.setByteArray(a);
                this.dataLength = this.bytes.length;
                this.recordLength = this.bytes.length;
            }
            return this.recordLength;
        }

        public void setRecordLength(int i) {
            this.recordLength = i;
        }

        public String getName() {
            return this.filename;
        }

        public void setName(String name) {
            if (name.length() > 72) {
                log.error("new filename too long: {}", (Object)this.filename.length());
            }
            this.filename = name;
        }

        private void setByteArray(byte[] a) {
            this.bytes = new byte[a.length];
            int i = 0;
            while (i < a.length) {
                this.bytes[i] = a[i];
                ++i;
            }
        }

        public byte[] getByteArray() {
            return Arrays.copyOf(this.bytes, this.bytes.length);
        }

        public SdfBuffer getSdfBuffer() {
            this.sdfBuffer = new SdfBuffer(this.getByteArray());
            return this.sdfBuffer;
        }

        void updateStart(int newRecordStart) {
            int dataStartOffset = this.getDataStart() - this.getRecordStart();
            this.setRecordStart(newRecordStart);
            this.setDataStart(newRecordStart + dataStartOffset);
        }

        public void setContent(byte[] array, int start, int length) {
            log.debug("setContent length = 0x{}", (Object)Integer.toHexString(length));
            this.setByteArray(array);
            this.setDataStart(this.getRecordStart() + start);
            this.setDataLength(length);
            this.setRecordLength(array.length);
        }

        int store(byte[] buffer, int index) {
            index = this.copyInt4(buffer, index, this.type);
            index = this.copyInt4(buffer, index, this.handle);
            index = this.copyInt4(buffer, index, this.recordStart);
            index = this.copyInt4(buffer, index, this.dataStart);
            index = this.copyInt4(buffer, index, this.dataLength);
            index = this.copyInt4(buffer, index, this.recordLength);
            index = this.copyInt4(buffer, index, this.time);
            index = this.copyInt4(buffer, index, 0);
            index = this.copyInt4(buffer, index, 0);
            index = this.copyInt4(buffer, index, 0);
            index = this.copyInt4(buffer, index, 0);
            index = this.copyInt4(buffer, index, 0);
            index = this.copyInt4(buffer, index, 0);
            index = this.copyInt4(buffer, index, 0);
            byte[] name = this.filename.getBytes();
            if (name.length > 72) {
                log.error("Name too long: {}", (Object)name.length);
            }
            int i = 0;
            while (i < name.length) {
                buffer[index + i] = name[i];
                ++i;
            }
            return index + 72;
        }

        void store(OutputStream s) throws IOException {
            this.writeInt4(s, this.type);
            this.writeInt4(s, this.handle);
            this.writeInt4(s, this.recordStart);
            this.writeInt4(s, this.dataStart);
            this.writeInt4(s, this.dataLength);
            this.writeInt4(s, this.recordLength);
            this.writeInt4(s, this.time);
            this.writeInt4(s, 0);
            this.writeInt4(s, 0);
            this.writeInt4(s, 0);
            this.writeInt4(s, 0);
            this.writeInt4(s, 0);
            this.writeInt4(s, 0);
            this.writeInt4(s, 0);
            byte[] name = this.filename.getBytes();
            if (name.length > 72) {
                log.error("Name too long: {}", (Object)name.length);
            }
            byte[] buffer = new byte[72];
            int i = 0;
            while (i < 72) {
                buffer[i] = 0;
                ++i;
            }
            i = 0;
            while (i < name.length) {
                buffer[i] = name[i];
                ++i;
            }
            s.write(buffer);
        }

        void load(InputStream s) throws IOException {
            this.type = this.readInt4(s);
            this.handle = this.readInt4(s);
            this.recordStart = this.readInt4(s);
            this.dataStart = this.readInt4(s);
            this.dataLength = this.readInt4(s);
            this.recordLength = this.readInt4(s);
            this.time = this.readInt4(s);
            this.spare1 = this.readInt4(s);
            this.spare2 = this.readInt4(s);
            this.spare3 = this.readInt4(s);
            this.spare4 = this.readInt4(s);
            this.spare5 = this.readInt4(s);
            this.spare6 = this.readInt4(s);
            this.spare7 = this.readInt4(s);
            byte[] name = new byte[72];
            int readLength = s.read(name);
            int len = 0;
            len = 0;
            while (len < readLength) {
                if (name[len] == 0) break;
                ++len;
            }
            byte[] shortname = new byte[len];
            int i = 0;
            while (i < len) {
                shortname[i] = name[i];
                ++i;
            }
            this.filename = new String(shortname);
        }

        public String toString() {
            return "type= " + this.typeAsString() + ", handle= " + this.handle + ", rs= " + this.recordStart + ", ds= " + this.dataStart + ", ds-rs = " + (this.dataStart - this.recordStart) + ", dl = " + this.dataLength + ", rl= " + this.recordLength + ", rl-dl = " + (this.recordLength - this.dataLength) + ", filename= " + this.filename;
        }

        public boolean isWAV() {
            return this.getType() == 1;
        }

        public boolean isSDF() {
            return this.getType() == 2;
        }

        public boolean isMap() {
            return this.getType() == 5;
        }

        public boolean isTxt() {
            return this.getType() == 4;
        }

        private int readInt4(InputStream s) throws IOException {
            int i1 = s.read() & 0xFF;
            int i2 = s.read() & 0xFF;
            int i3 = s.read() & 0xFF;
            int i4 = s.read() & 0xFF;
            return i1 + (i2 << 8) + (i3 << 16) + (i4 << 24);
        }

        private void writeInt4(OutputStream s, int i) throws IOException {
            byte i1 = (byte)(i & 0xFF);
            byte i2 = (byte)(i >> 8 & 0xFF);
            byte i3 = (byte)(i >> 16 & 0xFF);
            byte i4 = (byte)(i >> 24 & 0xFF);
            s.write(i1);
            s.write(i2);
            s.write(i3);
            s.write(i4);
        }

        private int copyInt4(byte[] buffer, int index, int i) {
            buffer[index++] = (byte)(i & 0xFF);
            buffer[index++] = (byte)(i >> 8 & 0xFF);
            buffer[index++] = (byte)(i >> 16 & 0xFF);
            buffer[index++] = (byte)(i >> 24 & 0xFF);
            return index;
        }

        public String typeAsString() {
            if (this.type == -1) {
                return " initial ";
            }
            if (this.type >= 0 && this.type < 7) {
                String[] names = new String[]{"(unused) ", "WAV      ", "SDF      ", " CV data ", " comment ", ".map file", "WAV (mty)"};
                return names[this.type];
            }
            log.warn("Unexpected type = {}", (Object)this.type);
            return "Unknown " + this.type;
        }
    }
}

