/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.soundloader;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jmri.jmrix.loconet.soundloader.Bundle;
import jmri.jmrix.loconet.soundloader.LoaderEngine;
import jmri.jmrix.loconet.spjfile.SpjFile;
import jmri.jmrix.loconet.swing.LnPanel;
import jmri.util.FileUtil;

public class LoaderPane
extends LnPanel {
    JLabel inputFileName = new JLabel("");
    JButton readButton;
    JButton loadButton;
    JTextField comment = new JTextField(32);
    JProgressBar bar;
    JLabel status = new JLabel("");
    String statusText = "";
    SpjFile file;
    LoaderEngine engine;
    JFileChooser chooser;

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.soundloader.LoaderFrame";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("MenuItemSoundload"));
    }

    public LoaderPane() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton b = new JButton(Bundle.getMessage("ButtonSelect"));
        b.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoaderPane.this.selectInputFile();
            }
        });
        p.add(b);
        p.add(new JLabel(Bundle.getMessage("LabelInpFile")));
        p.add(this.inputFileName);
        this.add(p);
        this.add(new JSeparator());
        p = new JPanel();
        p.setLayout(new FlowLayout());
        this.readButton = new JButton(Bundle.getMessage("ButtonRead"));
        this.readButton.setEnabled(false);
        this.readButton.setToolTipText(Bundle.getMessage("TipReadDisabled"));
        p.add(this.readButton);
        this.readButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoaderPane.this.doRead();
            }
        });
        this.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel(Bundle.getMessage("LabelFileComment")));
        this.comment.setEditable(false);
        p.add(this.comment);
        this.add(p);
        this.add(new JSeparator());
        p = new JPanel();
        p.setLayout(new FlowLayout());
        this.loadButton = new JButton(Bundle.getMessage("ButtonDownload"));
        this.loadButton.setEnabled(false);
        this.loadButton.setToolTipText(Bundle.getMessage("TipLoadDisabled"));
        p.add(this.loadButton);
        this.loadButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoaderPane.this.doLoad();
            }
        });
        this.add(p);
        this.add(new JSeparator());
        this.bar = new JProgressBar();
        this.add(this.bar);
        this.add(new JSeparator());
        p = new JPanel();
        p.setLayout(new FlowLayout());
        this.status.setText(Bundle.getMessage("StatusSelectFile"));
        this.status.setAlignmentX(0.0f);
        this.status.setFont(this.status.getFont().deriveFont(0.9f * (float)this.inputFileName.getFont().getSize()));
        this.status.setForeground(Color.gray);
        p.add(this.status);
        this.add(p);
    }

    void selectInputFile() {
        String name = this.inputFileName.getText();
        if (name.equals("")) {
            name = FileUtil.getUserFilesPath();
        }
        if (this.chooser == null) {
            this.chooser = new JFileChooser(name);
        }
        this.inputFileName.setText("");
        int retVal = this.chooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        this.inputFileName.setText(this.chooser.getSelectedFile().getName());
        this.readButton.setEnabled(true);
        this.readButton.setToolTipText(Bundle.getMessage("TipReadEnabled"));
        this.loadButton.setEnabled(false);
        this.loadButton.setToolTipText(Bundle.getMessage("TipLoadDisabled"));
        this.status.setText(Bundle.getMessage("StatusReadFile"));
    }

    void doRead() {
        if (this.inputFileName.getText().equals("")) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorNoInputFile"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.loadButton.setEnabled(false);
        this.loadButton.setToolTipText(Bundle.getMessage("TipLoadDisabled"));
        try {
            this.file = new SpjFile(this.chooser.getSelectedFile());
            this.file.read();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorFileNotFound"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorIOError"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.comment.setText(this.file.getComment());
        this.loadButton.setEnabled(true);
        this.loadButton.setToolTipText(Bundle.getMessage("TipLoadEnabled"));
        this.status.setText(Bundle.getMessage("StatusDoDownload"));
    }

    void doLoad() {
        this.status.setText(Bundle.getMessage("StatusDownloading"));
        this.readButton.setEnabled(false);
        this.readButton.setToolTipText(Bundle.getMessage("TipDisabledDownload"));
        this.loadButton.setEnabled(false);
        this.loadButton.setToolTipText(Bundle.getMessage("TipDisabledDownload"));
        if (this.engine == null) {
            this.engine = new LoaderEngine(this.memo){

                @Override
                public void notify(String s) {
                    SwingUtilities.invokeLater(new Notifier(s));
                }
            };
        }
        new Thread(){

            @Override
            public void run() {
                LoaderPane.this.engine.runDownload(LoaderPane.this.file);
            }
        }.start();
    }

    @Override
    public void dispose() {
        if (this.file != null) {
            this.file.dispose();
        }
        this.file = null;
        if (this.engine != null) {
            this.engine.dispose();
        }
        this.engine = null;
    }

    private class Notifier
    implements Runnable {
        String msg;

        public Notifier(String msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            LoaderPane.this.status.setText(this.msg);
        }
    }
}

