/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.soundloader;

import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.soundloader.Bundle;
import jmri.jmrix.loconet.spjfile.SpjFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderEngine {
    static final int CMD_START = 4;
    static final int CMD_ADD = 8;
    static final int TYPE_SDF = 1;
    static final int TYPE_WAV = 0;
    static final int SENDPAGESIZE = 256;
    static final int SENDDATASIZE = 128;
    SpjFile spjFile;
    private boolean transferStart;
    private int transferType;
    private int transferHandle;
    private String transferName;
    private byte[] transferContents;
    private int transferIndex;
    LocoNetSystemConnectionMemo memo;
    LnTrafficController controller = null;
    private static final Logger log = LoggerFactory.getLogger(LoaderEngine.class);

    public LoaderEngine(LocoNetSystemConnectionMemo memo) {
        this.memo = memo;
    }

    public void runDownload(SpjFile file) {
        this.spjFile = file;
        this.initController();
        try {
            this.notify(Bundle.getMessage("EngineEraseFlash"));
            this.controller.sendLocoNetMessage(this.getEraseMessage());
            this.protectedWait(1000);
            this.notify(Bundle.getMessage("EngineEraseWait"));
            this.protectedWait(20000);
            this.notify(Bundle.getMessage("EngineSendInit"));
            this.controller.sendLocoNetMessage(this.getInitMessage());
            this.protectedWait(250);
            this.sendSDF();
            this.sendAllWAV();
            this.controller.sendLocoNetMessage(this.getExitMessage());
            this.notify(Bundle.getMessage("EngineDone"));
        }
        catch (DelayException delayException) {
            this.notify(Bundle.getMessage("EngineAbortDelay"));
        }
    }

    void sendSDF() throws DelayException {
        this.notify(Bundle.getMessage("EngineSendSdf"));
        SpjFile.Header header = this.spjFile.findSdfHeader();
        int handle = header.getHandle();
        String name = header.getName();
        byte[] contents = header.getByteArray();
        LocoNetMessage m = this.initTransfer(1, handle, name, contents);
        this.controller.sendLocoNetMessage(m);
        this.throttleOutbound(m);
        while ((m = this.nextTransfer()) != null) {
            this.controller.sendLocoNetMessage(m);
            this.throttleOutbound(m);
        }
    }

    void sendAllWAV() throws DelayException {
        this.notify(Bundle.getMessage("EngineSendWav"));
        int i = 1;
        while (i < this.spjFile.numHeaders()) {
            if (this.spjFile.getHeader(i).isWAV()) {
                this.sendOneWav(i);
            }
            ++i;
        }
    }

    public void sendOneWav(int index) throws DelayException {
        this.notify(Bundle.getMessage("EngineSendWavBlock", index));
        SpjFile.Header header = this.spjFile.getHeader(index);
        int handle = header.getHandle();
        String name = header.getName();
        byte[] buffer = header.getByteArray();
        int offset = header.getDataStart() - header.getRecordStart();
        int len = header.getDataLength();
        byte[] contents = new byte[len];
        int i = 0;
        while (i < len) {
            contents[i] = buffer[i + offset];
            ++i;
        }
        LocoNetMessage m = this.initTransfer(0, handle, name, contents);
        this.controller.sendLocoNetMessage(m);
        this.throttleOutbound(m);
        while ((m = this.nextTransfer()) != null) {
            this.controller.sendLocoNetMessage(m);
            this.throttleOutbound(m);
        }
    }

    public void notify(String message) {
        log.debug(message);
    }

    void throttleOutbound(LocoNetMessage m) throws DelayException {
        this.protectedWait(50);
        int i = 1;
        while (i < 100) {
            if (!this.controller.isXmtBusy()) {
                return;
            }
            this.protectedWait(10);
            ++i;
        }
        throw new DelayException("Ran out of time after sending " + m.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protectedWait(int millis) {
        LoaderEngine loaderEngine = this;
        synchronized (loaderEngine) {
            try {
                this.wait(millis);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    LocoNetMessage initTransfer(int type, int handle, String name, byte[] contents) {
        this.transferType = type;
        this.transferStart = true;
        this.transferHandle = handle;
        this.transferName = name;
        this.transferContents = contents;
        return this.getStartDataMessage(this.transferType, handle, contents.length);
    }

    public LocoNetMessage nextTransfer() {
        if (this.transferStart) {
            this.transferStart = false;
            this.transferIndex = 0;
            byte[] header = new byte[40];
            header[0] = (byte)this.transferHandle;
            header[1] = (byte)(this.transferContents.length & 0xFF);
            header[2] = (byte)(this.transferContents.length / 256 & 0xFF);
            header[3] = (byte)(this.transferContents.length / 256 / 256 & 0xFF);
            header[4] = 0;
            header[5] = 0;
            header[6] = 0;
            header[7] = 0;
            int i = 8;
            while (i < 40) {
                header[i] = 0;
                ++i;
            }
            if (this.transferName.length() > 32) {
                log.error("name {} is too long, truncated", (Object)this.transferName);
            }
            i = 0;
            while (i < Math.min(32, this.transferName.length())) {
                header[i + 8] = (byte)this.transferName.charAt(i);
                ++i;
            }
            return this.getSendDataMessage(this.transferType, this.transferHandle, header);
        }
        int remaining = this.transferContents.length - this.transferIndex;
        if (remaining < 0) {
            log.error("Did not expect to find length {} and index {}", (Object)this.transferContents.length, (Object)this.transferIndex);
        }
        if (remaining <= 0) {
            return null;
        }
        int sendSize = remaining;
        if (remaining > 128) {
            sendSize = 128;
        }
        byte[] buffer = new byte[sendSize];
        int i = 0;
        while (i < sendSize) {
            buffer[i] = this.transferContents[this.transferIndex + i];
            ++i;
        }
        this.transferIndex += sendSize;
        return this.getSendDataMessage(this.transferType, this.transferHandle, buffer);
    }

    LocoNetMessage getStartDataMessage(int type, int handle, int length) {
        int pagecount = length / 256;
        int remainder = length - pagecount * 256;
        if (remainder != 0) {
            ++pagecount;
        }
        if (log.isDebugEnabled()) {
            log.debug("getStartDataMessage: {},{},{};{},{}", new Object[]{type, handle, length, pagecount, remainder});
        }
        int[] nArray = new int[6];
        nArray[0] = 211;
        nArray[1] = type | 4;
        nArray[2] = handle;
        nArray[3] = pagecount & 0x7F;
        nArray[4] = pagecount / 128;
        LocoNetMessage m = new LocoNetMessage(nArray);
        m.setParity();
        return m;
    }

    LocoNetMessage getSendDataMessage(int type, int handle, byte[] contents) {
        int length = contents.length;
        LocoNetMessage m = new LocoNetMessage(length + 7);
        m.setElement(0, 211);
        m.setElement(1, type | 8);
        m.setElement(2, handle);
        m.setElement(3, length & 0x7F);
        m.setElement(4, length / 128);
        m.setElement(5, 0);
        int i = 0;
        while (i < length) {
            m.setElement(6 + i, contents[i]);
            ++i;
        }
        m.setParity();
        return m;
    }

    LocoNetMessage getEraseMessage() {
        int[] nArray = new int[6];
        nArray[0] = 211;
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[3] = 127;
        nArray[5] = 80;
        LocoNetMessage m = new LocoNetMessage(nArray);
        m.setParity();
        return m;
    }

    LocoNetMessage getInitMessage() {
        int[] nArray = new int[6];
        nArray[0] = 211;
        nArray[1] = 1;
        nArray[5] = 45;
        LocoNetMessage m = new LocoNetMessage(nArray);
        m.setParity();
        return m;
    }

    LocoNetMessage getExitMessage() {
        int[] nArray = new int[6];
        nArray[0] = 211;
        nArray[5] = 44;
        LocoNetMessage m = new LocoNetMessage(nArray);
        m.setParity();
        return m;
    }

    void initController() {
        if (this.controller == null) {
            this.controller = this.memo.getLnTrafficController();
        }
    }

    public void dispose() {
    }

    static class DelayException
    extends Exception {
        DelayException(String s) {
            super(s);
        }
    }
}

