/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.soundloader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Font;
import java.awt.Window;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jmri.jmrit.sound.SoundUtil;
import jmri.jmrit.sound.WavBuffer;
import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdfeditor.EditorFrame;
import jmri.jmrix.loconet.soundloader.Bundle;
import jmri.jmrix.loconet.spjfile.SpjFile;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.davidflanagan.HardcopyWriter;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorTableDataModel
extends AbstractTableModel {
    public static final int HEADERCOL = 0;
    public static final int TYPECOL = 1;
    public static final int MAPCOL = 2;
    public static final int HANDLECOL = 3;
    public static final int FILENAMECOL = 4;
    public static final int LENGTHCOL = 5;
    public static final int PLAYBUTTONCOL = 6;
    public static final int REPLACEBUTTONCOL = 7;
    public static final int NUMCOLUMN = 8;
    SpjFile file;
    static JFileChooser chooser;
    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(EditorTableDataModel.class);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="cache resource at 1st start, threading OK")
    public EditorTableDataModel(SpjFile file) {
        this.file = file;
    }

    @Override
    public int getRowCount() {
        return this.file.numHeaders() - 1;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("HeaderHEADERCOL");
            }
            case 1: {
                return Bundle.getMessage("HeaderTYPECOL");
            }
            case 3: {
                return Bundle.getMessage("HeaderHANDLECOL");
            }
            case 2: {
                return Bundle.getMessage("HeaderMAPCOL");
            }
            case 4: {
                return Bundle.getMessage("HeaderFILENAMECOL");
            }
            case 5: {
                return Bundle.getMessage("HeaderLENGTHCOL");
            }
            case 6: {
                return "";
            }
            case 7: {
                return "";
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 3: {
                return Integer.class;
            }
            case 5: {
                return Float.class;
            }
            case 1: 
            case 2: 
            case 4: {
                return String.class;
            }
            case 6: 
            case 7: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return row;
            }
            case 3: {
                return this.file.getHeader(row + 1).getHandle();
            }
            case 2: {
                return this.file.getMapEntry(this.file.getHeader(row + 1).getHandle());
            }
            case 4: {
                return this.file.getHeader(row + 1).getName();
            }
            case 1: {
                return this.file.getHeader(row + 1).typeAsString();
            }
            case 5: {
                if (!this.file.getHeader(row + 1).isWAV()) {
                    return null;
                }
                float rate = new WavBuffer(this.file.getHeader(row + 1).getByteArray()).getSampleRate();
                if (rate == 0.0f) {
                    log.error("Rate should not be zero");
                    return null;
                }
                float time = (float)this.file.getHeader(row + 1).getDataLength() / rate;
                return Float.valueOf(time);
            }
            case 6: {
                if (this.file.getHeader(row + 1).isWAV()) {
                    return Bundle.getMessage("ButtonPlay");
                }
                if (this.file.getHeader(row + 1).isTxt()) {
                    return Bundle.getMessage("ButtonView");
                }
                if (this.file.getHeader(row + 1).isMap()) {
                    return Bundle.getMessage("ButtonView");
                }
                if (this.file.getHeader(row + 1).isSDF()) {
                    return Bundle.getMessage("ButtonView");
                }
                return null;
            }
            case 7: {
                if (this.file.getHeader(row + 1).isWAV()) {
                    return Bundle.getMessage("ButtonReplace");
                }
                if (this.file.getHeader(row + 1).isSDF()) {
                    return Bundle.getMessage("ButtonEdit");
                }
                return null;
            }
        }
        log.error("internal state inconsistent with table requst for {} {}", (Object)row, (Object)col);
        return null;
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
    public int getPreferredWidth(int col) {
        switch (col) {
            case 1: {
                return new JTextField((int)8).getPreferredSize().width;
            }
            case 2: {
                return new JTextField((int)12).getPreferredSize().width;
            }
            case 0: 
            case 3: {
                return new JTextField((int)3).getPreferredSize().width;
            }
            case 4: {
                return new JTextField((int)12).getPreferredSize().width;
            }
            case 5: {
                return new JTextField((int)5).getPreferredSize().width;
            }
            case 6: {
                JTextField b = new JTextField((String)this.getValueAt(1, 6));
                return b.getPreferredSize().width + 30;
            }
            case 7: {
                JTextField b = new JTextField((String)this.getValueAt(1, 7));
                return b.getPreferredSize().width + 30;
            }
        }
        log.warn("Unexpected column in getPreferredWidth: {}", (Object)col);
        return new JTextField((int)8).getPreferredSize().width;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 6) {
            if (this.file.getHeader(row + 1).isWAV()) {
                this.playButtonPressed(value, row, col);
                return;
            }
            if (this.file.getHeader(row + 1).isTxt()) {
                this.viewTxtButtonPressed(value, row, col);
                return;
            }
            if (this.file.getHeader(row + 1).isMap()) {
                this.viewTxtButtonPressed(value, row, col);
                return;
            }
            if (this.file.getHeader(row + 1).isSDF()) {
                this.viewSdfButtonPressed(value, row, col);
                return;
            }
        } else if (col == 7) {
            if (this.file.getHeader(row + 1).isWAV()) {
                this.replWavButtonPressed(value, row, col);
            } else if (this.file.getHeader(row + 1).isSDF()) {
                this.editSdfButtonPressed(value, row, col);
                return;
            }
        }
    }

    void replWavButtonPressed(Object value, int row, int col) {
        WavBuffer buff;
        if (chooser == null) {
            chooser = new JFileChooser(FileUtil.getUserFilesPath());
        }
        chooser.rescanCurrentDirectory();
        int retVal = chooser.showOpenDialog(null);
        if (retVal != 0) {
            return;
        }
        try {
            buff = new WavBuffer(chooser.getSelectedFile());
        }
        catch (Exception e) {
            log.error("Exception loading file: {}", (Throwable)e);
            return;
        }
        this.file.getHeader(row + 1).setContent(buff.getByteArray(), buff.getDataStart(), buff.getDataSize());
        this.file.getHeader(row + 1).setName(chooser.getSelectedFile().getName());
        this.fireTableRowsUpdated(row, row);
    }

    void playButtonPressed(Object value, int row, int col) {
        SoundUtil.playSoundBuffer(this.file.getHeader(row + 1).getByteArray());
    }

    void viewTxtButtonPressed(Object value, int row, int col) {
        String content = new String(this.file.getHeader(row + 1).getByteArray());
        JFrame frame = new JFrame();
        JTextArea text = new JTextArea(content);
        text.setEditable(false);
        text.setFont(new Font("Monospaced", 0, text.getFont().getSize()));
        frame.getContentPane().add(new JScrollPane(text));
        frame.pack();
        frame.setVisible(true);
    }

    void viewSdfButtonPressed(Object value, int row, int col) {
        SdfBuffer buff = new SdfBuffer(this.file.getHeader(row + 1).getByteArray());
        String content = buff.toString();
        JmriJFrame frame = new JmriJFrame(Bundle.getMessage("TitleSdfView"));
        JTextArea text = new JTextArea(content);
        text.setEditable(false);
        text.setFont(new Font("Monospaced", 0, text.getFont().getSize()));
        frame.getContentPane().add(new JScrollPane(text));
        ((Window)frame).pack();
        frame.setVisible(true);
    }

    void editSdfButtonPressed(Object value, int row, int col) {
        EditorFrame sdfEditor = new EditorFrame(this.file.getHeader(row + 1).getSdfBuffer());
        sdfEditor.setVisible(true);
    }

    public void configureTable(JTable table) {
        table.getTableHeader().setReorderingAllowed(true);
        table.setAutoResizeMode(0);
        int i = 0;
        while (i < table.getColumnCount()) {
            int width = this.getPreferredWidth(i);
            table.getColumnModel().getColumn(i).setPreferredWidth(width);
            ++i;
        }
        this.setColumnToHoldButton(table, 6, this.largestWidthButton(6));
        this.setColumnToHoldButton(table, 7, this.largestWidthButton(7));
    }

    public JButton largestWidthButton(int col) {
        JButton retval = new JButton("TTTT");
        if (col == 6) {
            retval = this.checkLabelWidth(retval, "ButtonPlay");
            retval = this.checkLabelWidth(retval, "ButtonView");
        } else if (col == 7) {
            retval = this.checkLabelWidth(retval, "ButtonEdit");
            retval = this.checkLabelWidth(retval, "ButtonReplace");
        }
        return retval;
    }

    private JButton checkLabelWidth(JButton now, String name) {
        JButton b = new JButton(Bundle.getMessage(name));
        b.revalidate();
        if (b.getPreferredSize().width > now.getPreferredSize().width) {
            return b;
        }
        return now;
    }

    void setColumnToHoldButton(JTable table, int column, JButton sample) {
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        table.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        table.setDefaultEditor(JButton.class, buttonEditor);
        table.setRowHeight(sample.getPreferredSize().height);
        table.getColumnModel().getColumn(column).setPreferredWidth(sample.getPreferredSize().width + 30);
    }

    public synchronized void dispose() {
    }

    public void printTable(HardcopyWriter w) {
        int columnSize = (w.getCharactersPerLine() - this.getColumnCount() - 1) / this.getColumnCount();
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), (columnSize + 1) * this.getColumnCount());
        String[] columnStrings = new String[this.getColumnCount()];
        int i = 0;
        while (i < this.getColumnCount()) {
            columnStrings[i] = this.getColumnName(i);
            ++i;
        }
        w.setFontStyle(1);
        this.printColumns(w, columnStrings, columnSize);
        w.setFontStyle(0);
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), (columnSize + 1) * this.getColumnCount());
        StringBuilder spaces = new StringBuilder("");
        int i2 = 0;
        while (i2 < columnSize) {
            spaces.append(" ");
            ++i2;
        }
        i2 = 0;
        while (i2 < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                columnStrings[j] = this.getValueAt(i2, j) == null ? spaces.toString() : (this.getValueAt(i2, j) instanceof JComboBox ? (String)((JComboBox)this.getValueAt(i2, j)).getSelectedItem() : (this.getValueAt(i2, j) instanceof Boolean ? this.getValueAt(i2, j).toString() : (String)this.getValueAt(i2, j)));
                ++j;
            }
            this.printColumns(w, columnStrings, columnSize);
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), (columnSize + 1) * this.getColumnCount());
            ++i2;
        }
        w.close();
    }

    protected void printColumns(HardcopyWriter w, String[] columnStrings, int columnSize) {
        String columnString = "";
        StringBuilder lineString = new StringBuilder("");
        StringBuilder spaces = new StringBuilder("");
        int i = 0;
        while (i < columnSize) {
            spaces.append(" ");
            ++i;
        }
        boolean complete = false;
        while (!complete) {
            complete = true;
            int i2 = 0;
            while (i2 < columnStrings.length) {
                if (columnStrings[i2].length() > columnSize) {
                    boolean noWord = true;
                    int k = columnSize;
                    while (k >= 1) {
                        if (columnStrings[i2].substring(k - 1, k).equals(" ") || columnStrings[i2].substring(k - 1, k).equals("-") || columnStrings[i2].substring(k - 1, k).equals("_")) {
                            columnString = String.valueOf(columnStrings[i2].substring(0, k)) + spaces.substring(columnStrings[i2].substring(0, k).length());
                            columnStrings[i2] = columnStrings[i2].substring(k);
                            noWord = false;
                            complete = false;
                            break;
                        }
                        --k;
                    }
                    if (noWord) {
                        columnString = columnStrings[i2].substring(0, columnSize);
                        columnStrings[i2] = columnStrings[i2].substring(columnSize);
                        complete = false;
                    }
                } else {
                    columnString = String.valueOf(columnStrings[i2]) + spaces.substring(columnStrings[i2].length());
                    columnStrings[i2] = "";
                }
                lineString.append(columnString).append(" ");
                ++i2;
            }
            try {
                w.write(lineString.toString());
                i2 = 0;
                while (i2 < w.getCharactersPerLine()) {
                    w.write(w.getCurrentLineNumber(), i2, w.getCurrentLineNumber() + 1, i2);
                    i2 = i2 + columnSize + 1;
                }
                w.write("\n");
                lineString = new StringBuilder("");
            }
            catch (IOException e) {
                log.warn("error during printing:", (Throwable)e);
            }
        }
    }
}

