/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.soundloader;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.jmrit.XmlFile;
import jmri.jmrix.loconet.soundloader.Bundle;
import jmri.jmrix.loconet.soundloader.EditorFilePane;
import jmri.jmrix.loconet.swing.LnPanel;

public class EditorPane
extends LnPanel {
    EditorFilePane pane;
    JButton open = new JButton(Bundle.getMessage("ButtonOpen"));
    JButton save;
    static JFileChooser chooser;

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.soundloader.EditorFrame";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("MenuItemSoundEditor"));
    }

    public EditorPane() {
        super.setLayout(new BoxLayout(this, 1));
        this.open.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorPane.this.selectInputFile();
            }
        });
        this.save = new JButton(Bundle.getMessage("ButtonSave"));
        this.save.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorPane.this.selectSaveFile();
            }
        });
        super.add(this.save);
        this.save.setEnabled(false);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(this.open);
        p.add(this.save);
        super.add(p);
    }

    void selectInputFile() {
        if (chooser == null) {
            chooser = XmlFile.userFileChooser();
        }
        chooser.rescanCurrentDirectory();
        int retVal = chooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        this.addFile(chooser.getSelectedFile());
    }

    void selectSaveFile() {
        int retVal;
        if (chooser == null) {
            chooser = new JFileChooser(System.getProperty("user.dir"));
        }
        if ((retVal = chooser.showSaveDialog(this)) != 0) {
            return;
        }
        try {
            this.saveFile(chooser.getSelectedFile().getPath());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error during save: " + e, "Save failed!", 2);
        }
    }

    void addFile(File name) {
        if (this.pane != null) {
            return;
        }
        this.pane = new EditorFilePane(name);
        this.add(this.pane);
        this.open.setEnabled(false);
        this.save.setEnabled(true);
        this.revalidate();
        Container co = this.getTopLevelAncestor();
        if (co instanceof JFrame) {
            ((JFrame)co).pack();
        }
    }

    void saveFile(String name) throws IOException {
        this.pane.saveFile(name);
    }

    @Override
    public void dispose() {
        if (this.pane != null) {
            this.pane.dispose();
        }
        super.dispose();
    }
}

