/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.soundloader;

import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.table.TableRowSorter;
import jmri.jmrix.loconet.soundloader.Bundle;
import jmri.jmrix.loconet.soundloader.EditorTableDataModel;
import jmri.jmrix.loconet.spjfile.SpjFile;
import jmri.swing.RowSorterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorFilePane
extends JPanel {
    SpjFile file;
    EditorTableDataModel dataModel;
    private static final Logger log = LoggerFactory.getLogger(EditorFilePane.class);

    public EditorFilePane(File name) {
        try {
            this.file = new SpjFile(name);
            this.file.read();
        }
        catch (IOException e) {
            log.error("Exception reading file", (Throwable)e);
            return;
        }
        this.setLayout(new BoxLayout(this, 1));
        this.dataModel = new EditorTableDataModel(this.file);
        JTable dataTable = new JTable(this.dataModel);
        JScrollPane dataScroll = new JScrollPane(dataTable);
        TableRowSorter<EditorTableDataModel> sorter = new TableRowSorter<EditorTableDataModel>(this.dataModel);
        RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
        this.dataModel.configureTable(dataTable);
        this.add(dataScroll);
        this.add(new JSeparator());
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 1));
        JPanel p1 = new JPanel();
        p1.add(new JLabel(Bundle.getMessage("LabelSize")));
        JTextField t1 = new JTextField(12);
        t1.setEditable(false);
        p1.add(t1);
        bottom.add(p1);
        this.add(bottom);
    }

    public void saveFile(String name) throws IOException {
        this.file.save(name);
    }

    void dispose() {
        this.file.dispose();
        this.file = null;
    }
}

