/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.slotmon;

import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.slotmon.Bundle;
import jmri.jmrix.loconet.slotmon.SlotMonDataModel;
import jmri.jmrix.loconet.swing.LnNamedPaneAction;
import jmri.jmrix.loconet.swing.LnPanel;
import jmri.swing.JmriJTablePersistenceManager;
import jmri.util.swing.sdi.JmriJFrameInterface;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;

public class SlotMonPane
extends LnPanel {
    protected final JCheckBox showUnusedCheckBox = new JCheckBox();
    protected final JCheckBox showSystemCheckBox = new JCheckBox();
    private final JButton estopAllButton = new JButton(Bundle.getMessage("ButtonSlotMonEStopAll"));
    private final JButton clearAllButton = new JButton(Bundle.getMessage("ButtonSlotMonClearAll"));
    private final JButton refreshAllButton = new JButton(Bundle.getMessage("ButtonSlotRefresh"));
    private SlotMonDataModel slotModel;
    private JTable slotTable;
    private JScrollPane slotScroll;
    private transient TableRowSorter<SlotMonDataModel> sorter;

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.slotModel = new SlotMonDataModel(128, 16, memo);
        this.slotTable = new JTable(this.slotModel);
        this.slotTable.setName(this.getTitle());
        this.sorter = new TableRowSorter<SlotMonDataModel>(this.slotModel);
        this.slotTable.setRowSorter(this.sorter);
        this.slotScroll = new JScrollPane(this.slotTable);
        this.showUnusedCheckBox.setText(Bundle.getMessage("TextSlotMonShowUnused"));
        this.showUnusedCheckBox.setVisible(true);
        this.showUnusedCheckBox.setSelected(false);
        this.showUnusedCheckBox.setToolTipText(Bundle.getMessage("TooltipSlotMonShowUnused"));
        this.showSystemCheckBox.setText(Bundle.getMessage("TextSlotMonShowSystem"));
        this.showSystemCheckBox.setVisible(true);
        this.showSystemCheckBox.setSelected(false);
        this.showSystemCheckBox.setToolTipText(Bundle.getMessage("TooltipSlotMonShowSystem"));
        this.slotTable.getTableHeader().setReorderingAllowed(true);
        this.slotTable.setAutoResizeMode(0);
        int i = 0;
        while (i < this.slotTable.getColumnCount()) {
            int width = this.slotModel.getPreferredWidth(i);
            this.slotTable.getColumnModel().getColumn(i).setPreferredWidth(width);
            ++i;
        }
        this.slotTable.sizeColumnsToFit(-1);
        InstanceManager.getOptionalDefault(JmriJTablePersistenceManager.class).ifPresent(tpm -> {});
        this.setColumnToHoldButton(this.slotTable, this.slotTable.convertColumnIndexToView(6));
        this.setColumnToHoldEStopButton(this.slotTable, this.slotTable.convertColumnIndexToView(1));
        this.refreshAllButton.addActionListener(e -> this.slotModel.refreshSlots());
        this.showUnusedCheckBox.addActionListener(e -> this.filter());
        this.showSystemCheckBox.addActionListener(e -> this.filter());
        this.estopAllButton.addActionListener(e -> this.slotModel.estopAll());
        this.clearAllButton.addActionListener(e -> this.slotModel.clearAllSlots());
        this.filter();
        this.setLayout(new BoxLayout(this, 1));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new FlowLayout());
        pane1.add(this.refreshAllButton);
        pane1.add(this.showUnusedCheckBox);
        pane1.add(this.showSystemCheckBox);
        pane1.add(this.estopAllButton);
        pane1.add(this.clearAllButton);
        this.add(pane1);
        this.add(this.slotScroll);
        if (pane1.getMaximumSize().height > 0 && pane1.getMaximumSize().width > 0) {
            pane1.setMaximumSize(pane1.getPreferredSize());
        }
    }

    void setColumnToHoldButton(JTable slotTable, int column) {
        TableColumnModel tcm = slotTable.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(column).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        slotTable.setDefaultEditor(JButton.class, buttonEditor);
        slotTable.setRowHeight(new JButton((String)new StringBuilder((String)"  ").append((Object)this.slotModel.getValueAt((int)1, (int)column)).toString()).getPreferredSize().height);
        slotTable.getColumnModel().getColumn(column).setPreferredWidth(new JButton((String)new StringBuilder((String)"  ").append((Object)this.slotModel.getValueAt((int)1, (int)column)).toString()).getPreferredSize().width);
    }

    void setColumnToHoldEStopButton(JTable slotTable, int column) {
        TableColumnModel tcm = slotTable.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(column).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        slotTable.setDefaultEditor(JButton.class, buttonEditor);
        slotTable.setRowHeight(new JButton((String)new StringBuilder((String)"  ").append((Object)this.slotModel.getValueAt((int)1, (int)column)).toString()).getPreferredSize().height);
        slotTable.getColumnModel().getColumn(column).setPreferredWidth(new JButton((String)new StringBuilder((String)"  ").append((Object)this.slotModel.getValueAt((int)1, (int)column)).toString()).getPreferredSize().width);
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.slotmon.SlotMonFrame";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("MenuItemSlotMonitor"));
    }

    @Override
    public void dispose() {
        this.slotModel.dispose();
        this.slotModel = null;
        this.slotTable = null;
        this.slotScroll = null;
        super.dispose();
    }

    private void filter() {
        RowFilter<SlotMonDataModel, Integer> rf = new RowFilter<SlotMonDataModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SlotMonDataModel, ? extends Integer> entry) {
                boolean include;
                int slotNum = entry.getIdentifier();
                boolean bl = include = entry.getModel().getSlot(entry.getIdentifier()).slotStatus() != 0 && slotNum > 0 && slotNum < 121;
                if (!include && SlotMonPane.this.showUnusedCheckBox.isSelected() && slotNum > 0 && slotNum < 121) {
                    include = true;
                }
                if (!include && SlotMonPane.this.showSystemCheckBox.isSelected() && (slotNum == 0 || slotNum > 120)) {
                    include = true;
                }
                return include;
            }
        };
        this.sorter.setRowFilter(rf);
    }

    @Deprecated
    public static class Default
    extends LnNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemSlotMonitor"), new JmriJFrameInterface(), SlotMonPane.class.getName(), InstanceManager.getDefault(LocoNetSystemConnectionMemo.class));
        }
    }
}

