/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.slotmon;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotListener;
import jmri.jmrix.loconet.slotmon.Bundle;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotMonDataModel
extends AbstractTableModel
implements SlotListener {
    public static final int SLOTCOLUMN = 0;
    public static final int ESTOPCOLUMN = 1;
    public static final int ADDRCOLUMN = 2;
    public static final int SPDCOLUMN = 3;
    public static final int TYPECOLUMN = 4;
    public static final int STATCOLUMN = 5;
    public static final int DISPCOLUMN = 6;
    public static final int CONSCOLUMN = 7;
    public static final int THROTCOLUMN = 8;
    public static final int DIRCOLUMN = 9;
    public static final int F0COLUMN = 10;
    public static final int F1COLUMN = 11;
    public static final int F2COLUMN = 12;
    public static final int F3COLUMN = 13;
    public static final int F4COLUMN = 14;
    public static final int F5COLUMN = 15;
    public static final int F6COLUMN = 16;
    public static final int F7COLUMN = 17;
    public static final int F8COLUMN = 18;
    public static final int NUMCOLUMN = 19;
    private final transient LocoNetSystemConnectionMemo memo;
    private static final Logger log = LoggerFactory.getLogger(SlotMonDataModel.class);

    SlotMonDataModel(int row, int column, LocoNetSystemConnectionMemo memo) {
        this.memo = memo;
        memo.getSlotManager().addSlotListener(this);
        memo.getSlotManager().update();
    }

    public void refreshSlots() {
        this.memo.getSlotManager().update();
    }

    @Override
    public int getRowCount() {
        return 128;
    }

    @Override
    public int getColumnCount() {
        return 19;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("SlotCol");
            }
            case 1: {
                return "";
            }
            case 2: {
                return Bundle.getMessage("AddressCol");
            }
            case 3: {
                return Bundle.getMessage("SpeedCol");
            }
            case 4: {
                return Bundle.getMessage("StatusCol");
            }
            case 5: {
                return Bundle.getMessage("UseCol");
            }
            case 7: {
                return Bundle.getMessage("ConsistedCol");
            }
            case 9: {
                return Bundle.getMessage("DirectionCol");
            }
            case 6: {
                return "";
            }
            case 10: {
                return "F0";
            }
            case 11: {
                return "F1";
            }
            case 12: {
                return "F2";
            }
            case 13: {
                return "F3";
            }
            case 14: {
                return "F4";
            }
            case 15: {
                return "F5";
            }
            case 16: {
                return "F6";
            }
            case 17: {
                return "F7";
            }
            case 18: {
                return "F8";
            }
            case 8: {
                return Bundle.getMessage("ThrottleIDCol");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 2: {
                return Integer.class;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                return String.class;
            }
            case 1: 
            case 6: {
                return JButton.class;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 1: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return row > 0 && row < 121;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        LocoNetSlot s = this.memo.getSlotManager().slot(row);
        if (s == null) {
            log.error("slot pointer was null for slot row: {} col: {}", (Object)row, (Object)col);
            return null;
        }
        switch (col) {
            case 0: {
                return row;
            }
            case 1: {
                return Bundle.getMessage("ButtonEstop");
            }
            case 2: {
                return s.locoAddr();
            }
            case 3: {
                switch (s.consistStatus()) {
                    case 0: 
                    case 8: {
                        String t = s.speed() == 1 ? "(estop) 1" : "          " + s.speed();
                        return t.substring(t.length() - 9, t.length());
                    }
                    case 64: 
                    case 72: {
                        return Bundle.getMessage("SlotSpeedConsist");
                    }
                }
                return Bundle.getMessage("StateError");
            }
            case 4: {
                switch (s.decoderType()) {
                    case 7: {
                        return "128 step adv";
                    }
                    case 4: {
                        return " 28 step adv";
                    }
                    case 3: {
                        return "128 step";
                    }
                    case 2: {
                        return " 14 step";
                    }
                    case 1: {
                        return " 28 step trinary";
                    }
                    case 0: {
                        return " 28 step";
                    }
                }
                return Bundle.getMessage("StateUnknown");
            }
            case 5: {
                switch (s.slotStatus()) {
                    case 48: {
                        return Bundle.getMessage("StateInUse");
                    }
                    case 32: {
                        return Bundle.getMessage("StateIdle");
                    }
                    case 16: {
                        return Bundle.getMessage("StateCommon");
                    }
                    case 0: {
                        return Bundle.getMessage("StateFree");
                    }
                }
                return Bundle.getMessage("StateError");
            }
            case 7: {
                switch (s.consistStatus()) {
                    case 72: {
                        String t = Bundle.getMessage("SlotConsistMidX", s.speed());
                        return t;
                    }
                    case 8: {
                        return Bundle.getMessage("SlotConsistTop");
                    }
                    case 64: {
                        String t = Bundle.getMessage("SlotConsistSubX", s.speed());
                        return t;
                    }
                    case 0: {
                        return Bundle.getMessage("SlotConsistNone");
                    }
                }
                return Bundle.getMessage("StateError");
            }
            case 6: {
                return Bundle.getMessage("ButtonRelease");
            }
            case 9: {
                return s.isForward() ? Bundle.getMessage("DirColForward") : Bundle.getMessage("DirColReverse");
            }
            case 10: {
                return s.isF0();
            }
            case 11: {
                return s.isF1();
            }
            case 12: {
                return s.isF2();
            }
            case 13: {
                return s.isF3();
            }
            case 14: {
                return s.isF4();
            }
            case 15: {
                return s.isF5();
            }
            case 16: {
                return s.isF6();
            }
            case 17: {
                return s.isF7();
            }
            case 18: {
                return s.isF8();
            }
            case 8: {
                int upper = s.id() >> 7 & 0x7F;
                int lower = s.id() & 0x7F;
                return String.valueOf(StringUtil.twoHexFromInt(upper)) + " " + StringUtil.twoHexFromInt(lower);
            }
        }
        log.error("internal state inconsistent with table requst for {} {}", (Object)row, (Object)col);
        return null;
    }

    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: {
                return new JTextField((int)3).getPreferredSize().width;
            }
            case 1: {
                return new JButton((String)Bundle.getMessage((String)"ButtonEstop")).getPreferredSize().width;
            }
            case 2: {
                return new JTextField((int)5).getPreferredSize().width;
            }
            case 3: 
            case 5: {
                return new JTextField((int)6).getPreferredSize().width;
            }
            case 4: {
                return new JTextField((int)12).getPreferredSize().width;
            }
            case 7: {
                return new JTextField((int)4).getPreferredSize().width;
            }
            case 9: {
                return new JLabel((String)Bundle.getMessage((String)"DirectionCol")).getPreferredSize().width;
            }
            case 6: {
                return new JButton((String)Bundle.getMessage((String)"ButtonRelease")).getPreferredSize().width;
            }
            case 8: {
                return new JTextField((int)7).getPreferredSize().width;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return new JLabel((String)"       ").getPreferredSize().width;
            }
        }
        return new JLabel((String)" <unknown> ").getPreferredSize().width;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        LocoNetSlot s = this.memo.getSlotManager().slot(row);
        if (s == null) {
            log.error("slot pointer was null for slot row: {} col: {}", (Object)row, (Object)col);
            return;
        }
        switch (col) {
            case 1: {
                log.debug("Start estop in slot {}", (Object)row);
                if (s.consistStatus() == 64 || s.consistStatus() == 72) {
                    Object[] options = new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonCancel")};
                    int result = JOptionPane.showOptionDialog(null, Bundle.getMessage("SlotEstopWarning"), Bundle.getMessage("WarningTitle"), -1, 2, null, options, options[1]);
                    if (result == 1) {
                        return;
                    }
                }
                LocoNetMessage msg = new LocoNetMessage(4);
                msg.setOpCode(160);
                msg.setElement(1, s.getSlot());
                msg.setElement(2, 1);
                this.memo.getLnTrafficController().sendLocoNetMessage(msg);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                boolean tempF3;
                boolean tempF2;
                boolean tempF1;
                boolean tempF0;
                log.debug("F0-F4 change requested {}", (Object)row);
                s = this.memo.getSlotManager().slot(row);
                if (s == null) {
                    log.error("slot pointer was null for slot row: {} col: {}", (Object)row, (Object)col);
                    return;
                }
                boolean bl = col == 10 ? !s.isF0() : (tempF0 = s.isF0());
                boolean bl2 = col == 11 ? !s.isF1() : (tempF1 = s.isF1());
                boolean bl3 = col == 12 ? !s.isF2() : (tempF2 = s.isF2());
                boolean bl4 = col == 13 ? !s.isF3() : (tempF3 = s.isF3());
                boolean tempF4 = col == 14 ? !s.isF4() : s.isF4();
                int new_dirf = (s.isForward() ? 0 : 32) | (tempF0 ? 16 : 0) | (tempF1 ? 1 : 0) | (tempF2 ? 2 : 0) | (tempF3 ? 4 : 0) | (tempF4 ? 8 : 0);
                int status = s.slotStatus();
                if (status != 48) {
                    this.memo.getLnTrafficController().sendLocoNetMessage(s.writeStatus(48));
                }
                LocoNetMessage msg = new LocoNetMessage(4);
                msg.setOpCode(161);
                msg.setElement(1, s.getSlot());
                msg.setElement(2, new_dirf);
                this.memo.getLnTrafficController().sendLocoNetMessage(msg);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                }
                if (status != 48) {
                    this.memo.getLnTrafficController().sendLocoNetMessage(s.writeStatus(status));
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                boolean tempF7;
                boolean tempF6;
                boolean tempF5;
                log.debug("F5-F8 change requested {}", (Object)row);
                boolean bl = col == 15 ? !s.isF5() : (tempF5 = s.isF5());
                boolean bl5 = col == 16 ? !s.isF6() : (tempF6 = s.isF6());
                boolean bl6 = col == 17 ? !s.isF7() : (tempF7 = s.isF7());
                boolean tempF8 = col == 18 ? !s.isF8() : s.isF8();
                int new_snd = (tempF8 ? 8 : 0) | (tempF7 ? 4 : 0) | (tempF6 ? 2 : 0) | (tempF5 ? 1 : 0);
                int status = s.slotStatus();
                if (status != 48) {
                    this.memo.getLnTrafficController().sendLocoNetMessage(s.writeStatus(48));
                }
                LocoNetMessage msg = new LocoNetMessage(4);
                msg.setOpCode(162);
                msg.setElement(1, s.getSlot());
                msg.setElement(2, new_snd);
                this.memo.getLnTrafficController().sendLocoNetMessage(msg);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                }
                if (status != 48) {
                    this.memo.getLnTrafficController().sendLocoNetMessage(s.writeStatus(status));
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 6: {
                log.debug("Start freeing slot {}", (Object)row);
                if (s.slotStatus() != 0) {
                    Object[] options;
                    int result;
                    if (s.consistStatus() != 0 && (result = JOptionPane.showOptionDialog(null, "Freeing a consist member will destroy the consist.\n\nAre you sure you want to do that?", "Warning", -1, 2, null, options = new Object[]{"OK", "Cancel"}, options[1])) == 1) {
                        return;
                    }
                    this.memo.getLnTrafficController().sendLocoNetMessage(s.writeStatus(0));
                } else {
                    log.debug("Slot not in use");
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
        }
    }

    public void clearAllSlots() {
        int count = this.getRowCount();
        int row = 0;
        while (row < count - 1) {
            LocoNetSlot s = this.memo.getSlotManager().slot(row);
            if (s.slotStatus() != 48 && s.consistStatus() == 0) {
                log.debug("Freeing {} from slot {}, old status: {}", new Object[]{s.locoAddr(), s.getSlot(), s.slotStatus()});
                this.memo.getLnTrafficController().sendLocoNetMessage(s.writeStatus(0));
                this.fireTableRowsUpdated(row, row);
            }
            count = this.getRowCount();
            ++row;
        }
    }

    public void configureTable(JTable slotTable) {
    }

    @Override
    public synchronized void notifyChangedSlot(LocoNetSlot s) {
        int slotNum = s.getSlot();
        if (slotNum == 127) {
            int slotStatus2 = s.ss2() & 0x78;
            if (slotStatus2 > 0) {
                this.memo.getSlotManager().update();
            }
        } else {
            slotNum = -1;
        }
        SwingUtilities.invokeLater(new Notify(slotNum, this));
    }

    protected LocoNetSlot getSlot(int row) {
        return this.memo.getSlotManager().slot(row);
    }

    public void estopAll() {
        int slotNum = 0;
        while (slotNum < 120) {
            LocoNetSlot s = this.memo.getSlotManager().slot(slotNum);
            if (s.slotStatus() != 0 && (s.consistStatus() == 0 || s.consistStatus() == 8) && s.speed() != 1) {
                LocoNetMessage msg = new LocoNetMessage(4);
                msg.setOpCode(160);
                msg.setElement(1, s.getSlot());
                msg.setElement(2, 1);
                this.memo.getLnTrafficController().sendLocoNetMessage(msg);
            }
            ++slotNum;
        }
    }

    public void dispose() {
        this.memo.getSlotManager().removeSlotListener(this);
    }

    private static class Notify
    implements Runnable {
        private final int _row;
        AbstractTableModel _model;

        public Notify(int row, AbstractTableModel model) {
            this._row = row;
            this._model = model;
        }

        @Override
        public void run() {
            if (-1 == this._row) {
                this._model.fireTableDataChanged();
            } else {
                this._model.fireTableRowsUpdated(this._row, this._row);
            }
        }
    }
}

