/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdfeditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.jmrix.loconet.sdf.Play;
import jmri.jmrix.loconet.sdf.SdfConstants;
import jmri.jmrix.loconet.sdf.SdfMacro;
import jmri.jmrix.loconet.sdfeditor.SdfMacroEditor;

class PlayEditor
extends SdfMacroEditor {
    SpinnerNumberModel handleModel = new SpinnerNumberModel(0, 0, 63, 1);
    JSpinner handle = new JSpinner(this.handleModel);
    JComboBox<String> loop = new JComboBox<String>(SdfConstants.loopNames);
    JCheckBox wavbrk1 = new JCheckBox("Invert Loop Reason");
    JCheckBox wavbrk2 = new JCheckBox("Global Loop Reason");

    public PlayEditor(SdfMacro inst) {
        super(inst);
        this.removeAll();
        this.update();
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("Play handle number: "));
        p.add(this.handle);
        this.add(p);
        p = new JPanel();
        p.add(new JLabel("Loop control: "));
        p.add(this.loop);
        this.add(p);
        p = new JPanel();
        p.add(this.wavbrk1);
        p.add(this.wavbrk2);
        this.add(p);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayEditor.this.guiChanged();
            }
        };
        this.loop.addActionListener(l);
        this.wavbrk1.addActionListener(l);
        this.wavbrk2.addActionListener(l);
        ChangeListener c = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PlayEditor.this.guiChanged();
            }
        };
        this.handle.addChangeListener(c);
    }

    void guiChanged() {
        Play instruction = (Play)this.inst;
        instruction.setHandle(this.handleModel.getNumber().intValue());
        instruction.setBrk((String)this.loop.getSelectedItem());
        int flag = 0;
        if (this.wavbrk1.isSelected()) {
            flag |= 1;
        }
        if (this.wavbrk2.isSelected()) {
            flag |= 2;
        }
        instruction.setWaveBrkFlags(flag);
        this.updated();
    }

    @Override
    public void update() {
        Play instruction = (Play)this.inst;
        int handleVal = Integer.parseInt(instruction.handleVal());
        this.handleModel.setValue(handleVal);
        this.loop.setSelectedItem(instruction.brkVal());
        int flags = instruction.getWaveBrkFlags();
        this.wavbrk1.setSelected((flags & 1) != 0);
        this.wavbrk2.setSelected((flags & 2) != 0);
    }
}

