/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdfeditor;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrix.loconet.sdf.InitiateSound;
import jmri.jmrix.loconet.sdf.SdfConstants;
import jmri.jmrix.loconet.sdf.SdfMacro;
import jmri.jmrix.loconet.sdfeditor.SdfMacroEditor;
import jmri.util.StringUtil;

class InitiateSoundEditor
extends SdfMacroEditor {
    JComboBox<String> box;
    JCheckBox zap = new JCheckBox("Zap");
    JCheckBox run = new JCheckBox("Run while triggered");
    JCheckBox noprempt = new JCheckBox("No preemptive trigger");
    JCheckBox nottrig = new JCheckBox("Not triggered");

    public InitiateSoundEditor(SdfMacro inst) {
        super(inst);
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel("Start sequence when: "));
        this.box = new JComboBox<String>(SdfConstants.editorTriggerNames);
        this.update();
        p.add(this.box);
        this.add(p);
        this.add(this.zap);
        this.add(this.run);
        this.add(this.noprempt);
        this.add(this.nottrig);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String trigger = (String)InitiateSoundEditor.this.box.getSelectedItem();
                int value = StringUtil.getStateFromName(trigger, SdfConstants.triggerCodes, SdfConstants.editorTriggerNames);
                ((InitiateSound)InitiateSoundEditor.this.inst).setTrigger(value);
                int prempt = 0;
                if (InitiateSoundEditor.this.zap.isSelected()) {
                    prempt |= 1;
                }
                if (InitiateSoundEditor.this.run.isSelected()) {
                    prempt |= 2;
                }
                if (InitiateSoundEditor.this.noprempt.isSelected()) {
                    prempt |= 4;
                }
                if (InitiateSoundEditor.this.nottrig.isSelected()) {
                    prempt |= 0x80;
                }
                ((InitiateSound)InitiateSoundEditor.this.inst).setPrempt(prempt);
                InitiateSoundEditor.this.updated();
            }
        };
        this.box.addActionListener(l);
        this.zap.addActionListener(l);
        this.run.addActionListener(l);
        this.noprempt.addActionListener(l);
        this.nottrig.addActionListener(l);
    }

    @Override
    public void update() {
        InitiateSound instruction = (InitiateSound)this.inst;
        int trig = instruction.getTrigger();
        int i = 0;
        while (i < SdfConstants.triggerCodes.length) {
            if (SdfConstants.triggerCodes[i] == trig) {
                this.box.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        int prempt = instruction.getPrempt();
        this.zap.setSelected((prempt & 1) != 0);
        this.run.setSelected((prempt & 2) != 0);
        this.noprempt.setSelected((prempt & 4) != 0);
        this.nottrig.setSelected((prempt & 0x80) != 0);
    }
}

