/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdfeditor;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;
import jmri.jmrix.loconet.sdfeditor.MonitoringLabel;
import jmri.jmrix.loconet.sdfeditor.SdfMacroEditor;

public class EditorPane
extends JPanel
implements TreeSelectionListener {
    static ResourceBundle res = ResourceBundle.getBundle("jmri.jmrix.loconet.sdfeditor.Editor");
    static ResourceBundle exp = ResourceBundle.getBundle("jmri.jmrix.loconet.sdfeditor.Explanations");
    JSplitPane split;
    JTree tree;
    DefaultMutableTreeNode topNode;
    SdfMacroEditor lastEditor = null;
    MonitoringLabel instruction = new MonitoringLabel();
    JEditorPane explanation = new JEditorPane();
    JPanel detailed = new JPanel();

    public EditorPane() {
        this.setLayout(new BoxLayout(this, 0));
        this.split = new JSplitPane(1, this.newTree(), this.newEditPane());
        this.add(this.split);
    }

    JComponent newTree() {
        this.topNode = new DefaultMutableTreeNode("file");
        this.tree = new JTree(this.topNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setMinimumSize(new Dimension(250, 600));
        treeView.setPreferredSize(new Dimension(250, 600));
        return treeView;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        SdfMacroEditor nodeInfo = (SdfMacroEditor)node.getUserObject();
        this.instruction.setText(nodeInfo.oneInstructionString());
        this.explanation.setText(exp.getString(nodeInfo.getMacro().name()));
        if (this.lastEditor != null) {
            this.lastEditor.setVisible(false);
        }
        this.lastEditor = nodeInfo;
        nodeInfo.update();
        nodeInfo.setVisible(true);
    }

    public void updateSummary() {
        if (this.lastEditor != null) {
            this.instruction.setText(this.lastEditor.oneInstructionString());
        }
    }

    JPanel newEditPane() {
        JPanel p = new JPanel();
        p.setMinimumSize(new Dimension(600, 400));
        p.setPreferredSize(new Dimension(600, 400));
        p.setMaximumSize(new Dimension(600, 400));
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.newInstructionPane());
        p.add(new JSeparator());
        p.add(this.explanation);
        this.explanation.setEditable(false);
        this.explanation.setContentType("text/html");
        this.explanation.setMinimumSize(new Dimension(600, 200));
        this.explanation.setPreferredSize(new Dimension(600, 200));
        this.explanation.setMaximumSize(new Dimension(600, 200));
        this.explanation.setBackground(new JLabel().getBackground());
        p.add(new JSeparator());
        p.add(this.newDetailPane());
        return p;
    }

    JComponent newInstructionPane() {
        this.instruction.setLineWrap(true);
        this.instruction.setWrapStyleWord(true);
        this.instruction.setText("Select an instruction in the tree to the left");
        this.instruction.setEditable(false);
        this.instruction.setMinimumSize(new Dimension(600, 80));
        this.instruction.setPreferredSize(new Dimension(600, 80));
        this.instruction.setMaximumSize(new Dimension(600, 80));
        this.instruction.setBackground(new JLabel().getBackground());
        return this.instruction;
    }

    JPanel newDetailPane() {
        this.detailed.setLayout(new FlowLayout());
        return this.detailed;
    }

    void addSdf(SdfBuffer buff) {
        List<SdfMacro> ops = buff.getMacroList();
        int i = 0;
        while (i < ops.size()) {
            this.nestNodes(this.topNode, ops.get(i));
            ++i;
        }
        this.tree.expandPath(new TreePath(this.topNode));
        this.tree.setRootVisible(false);
    }

    void nestNodes(DefaultMutableTreeNode parent, SdfMacro macro) {
        SdfMacroEditor e = SdfMacroEditor.attachEditor(macro);
        this.detailed.add(e);
        e.setVisible(false);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(e);
        e.setNotify(newNode, this);
        parent.add(newNode);
        List<SdfMacro> children = macro.getChildren();
        if (children == null) {
            return;
        }
        int i = 0;
        while (i < children.size()) {
            this.nestNodes(newNode, children.get(i));
            ++i;
        }
    }

    void dispose() {
    }
}

