/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import java.util.ArrayList;
import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;

public class SkemeStart
extends SdfMacro {
    int byte1;
    int byte2;
    int byte3;
    int byte4;
    int number;
    int length;

    public SkemeStart(int byte1, int byte2, int byte3, int byte4) {
        this.byte1 = byte1;
        this.byte2 = byte2;
        this.byte3 = byte3;
        this.byte4 = byte4;
        this.number = byte2;
        this.length = byte3 * 256 + byte4;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int num) {
        this.number = num;
        this.byte2 = num;
    }

    @Override
    public String name() {
        return "SKEME_START";
    }

    @Override
    public int length() {
        return 4;
    }

    public static SdfMacro match(SdfBuffer buff) {
        if ((buff.getAtIndex() & 0xFF) != 241) {
            return null;
        }
        int byte1 = buff.getAtIndexAndInc();
        int byte2 = buff.getAtIndexAndInc();
        int byte3 = buff.getAtIndexAndInc();
        int byte4 = buff.getAtIndexAndInc();
        SkemeStart result = new SkemeStart(byte1, byte2, byte3, byte4);
        while (buff.moreData()) {
            int peek = buff.getAtIndex() & 0xFF;
            if (peek == 241) break;
            SdfMacro next = SkemeStart.decodeInstruction(buff);
            if (result.children == null) {
                result.children = new ArrayList();
            }
            result.children.add(next);
        }
        return result;
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(this.byte1);
        buffer.setAtIndexAndInc(this.byte2);
        buffer.setAtIndexAndInc(this.byte3);
        buffer.setAtIndexAndInc(this.byte4);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return "Scheme " + this.number + "\n";
    }

    @Override
    public String oneInstructionString() {
        return String.valueOf(this.name()) + ' ' + this.number + "; length=" + this.length + '\n';
    }

    @Override
    public String allInstructionString(String indent) {
        String output = String.valueOf(indent) + this.oneInstructionString();
        if (this.children == null) {
            return output;
        }
        int i = 0;
        while (i < this.children.size()) {
            output = String.valueOf(output) + ((SdfMacro)this.children.get(i)).allInstructionString(String.valueOf(indent) + "  ");
            ++i;
        }
        return output;
    }
}

