/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;

public class SdlVersion
extends SdfMacro {
    int version;

    public SdlVersion(int version) {
        this.version = version;
    }

    @Override
    public String name() {
        return "SDL_VERSION";
    }

    @Override
    public int length() {
        return 2;
    }

    public static SdfMacro match(SdfBuffer buff) {
        if ((buff.getAtIndex() & 0xFF) != 130) {
            return null;
        }
        buff.getAtIndexAndInc();
        return new SdlVersion(buff.getAtIndexAndInc());
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(130);
        buffer.setAtIndexAndInc(this.version);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return "Version " + (this.version == 16 ? "1" : "<unknown code>") + '\n';
    }

    @Override
    public String oneInstructionString() {
        return String.valueOf(this.name()) + ' ' + (this.version == 16 ? "VERSION_1" : "Unknown code " + this.version) + '\n';
    }

    @Override
    public String allInstructionString(String indent) {
        return String.valueOf(indent) + this.oneInstructionString();
    }
}

