/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jmri.jmrix.loconet.sdf.SdfMacro;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfBuffer {
    protected int index;
    ArrayList<SdfMacro> ops;
    byte[] buffer;
    private static final Logger log = LoggerFactory.getLogger(SdfBuffer.class);

    public SdfBuffer(byte[] buffer) {
        this.buffer = Arrays.copyOf(buffer, buffer.length);
        this.loadMacroList();
    }

    public SdfBuffer(String name) throws IOException {
        File file = new File(name);
        int length = (int)file.length();
        BufferedInputStream s = new BufferedInputStream(new FileInputStream(file));
        try {
            try {
                this.buffer = new byte[length];
                int i = 0;
                while (i < length) {
                    this.buffer[i] = (byte)(((InputStream)s).read() & 0xFF);
                    ++i;
                }
                this.loadMacroList();
            }
            catch (IOException e1) {
                log.error("error reading file", (Throwable)e1);
                throw e1;
            }
        }
        finally {
            try {
                ((InputStream)s).close();
            }
            catch (IOException e2) {
                log.error("Exception closing file", (Throwable)e2);
            }
        }
    }

    public void resetIndex() {
        this.index = 0;
    }

    public int getAtIndex() {
        return this.buffer[this.index] & 0xFF;
    }

    public int getAtIndexAndInc() {
        return this.buffer[this.index++] & 0xFF;
    }

    public boolean moreData() {
        return this.index < this.buffer.length;
    }

    public void setAtIndex(int data) {
        this.buffer[this.index] = (byte)(data & 0xFF);
    }

    public void setAtIndexAndInc(int data) {
        this.buffer[this.index++] = (byte)(data & 0xFF);
    }

    public void loadByteArray() {
        int length = 0;
        int i = 0;
        while (i < this.ops.size()) {
            length += this.ops.get(i).totalLength();
            ++i;
        }
        this.buffer = new byte[length];
        log.debug("create buffer of length {}", (Object)length);
        this.resetIndex();
        i = 0;
        while (i < this.ops.size()) {
            this.ops.get(i).loadByteArray(this);
            ++i;
        }
        if (this.index != length) {
            log.error("Lengths did not match: {} {}", (Object)this.index, (Object)length);
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder("");
        int i = 0;
        while (i < this.ops.size()) {
            SdfMacro m = this.ops.get(i);
            out.append(m.allInstructionString("    "));
            ++i;
        }
        return out.toString();
    }

    public byte[] getByteArray() {
        return Arrays.copyOf(this.buffer, this.buffer.length);
    }

    public List<SdfMacro> getMacroList() {
        return this.ops;
    }

    void loadMacroList() {
        this.resetIndex();
        this.ops = new ArrayList();
        while (this.moreData()) {
            SdfMacro m = SdfMacro.decodeInstruction(this);
            this.ops.add(m);
        }
    }
}

