/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;
import jmri.util.StringUtil;

public class MaskCompare
extends SdfMacro {
    int src;
    int immed;
    int targ;
    int mask;
    int skip;
    byte[] bytes = new byte[4];

    public MaskCompare(int byte1, int byte2, int byte3, int byte4) {
        this.bytes[0] = (byte)(byte1 & 0xFF);
        this.bytes[1] = (byte)(byte2 & 0xFF);
        this.bytes[2] = (byte)(byte3 & 0xFF);
        this.bytes[3] = (byte)(byte4 & 0xFF);
        this.src = byte2;
        this.immed = byte1 & 4;
        this.targ = byte3;
        this.mask = byte4;
        this.skip = byte1 & 3;
    }

    @Override
    public String name() {
        return "MASK_COMPARE";
    }

    @Override
    public int length() {
        return 4;
    }

    String srcVal() {
        return "(src = " + this.src + ")";
    }

    String immedVal() {
        if (this.immed != 0) {
            return "IMMED_DATA";
        }
        return "TARGET_DATA";
    }

    String targVal() {
        return "(target = " + this.targ + ")";
    }

    String maskVal() {
        return "(mask = " + this.mask + ")";
    }

    String skipVal() {
        return "(skip = " + this.skip + ")";
    }

    public static SdfMacro match(SdfBuffer buff) {
        if ((buff.getAtIndex() & 0xF8) != 248) {
            return null;
        }
        return new MaskCompare(buff.getAtIndexAndInc(), buff.getAtIndexAndInc(), buff.getAtIndexAndInc(), buff.getAtIndexAndInc());
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(this.bytes[0]);
        buffer.setAtIndexAndInc(this.bytes[1]);
        buffer.setAtIndexAndInc(this.bytes[2]);
        buffer.setAtIndexAndInc(this.bytes[3]);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return "Check Mask\n";
    }

    @Override
    public String oneInstructionString() {
        return String.valueOf(this.name()) + ' ' + StringUtil.hexStringFromBytes(this.bytes) + '\n';
    }

    @Override
    public String allInstructionString(String indent) {
        return String.valueOf(indent) + this.oneInstructionString();
    }
}

