/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadModifier
extends SdfMacro {
    int byte0;
    int modType;
    int arg1;
    int arg2;
    int arg3;
    private static final Logger log = LoggerFactory.getLogger(LoadModifier.class);

    public LoadModifier(int byte0, int arg1, int arg2, int arg3) {
        this.modType = byte0 & 0xF;
        this.byte0 = byte0;
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.arg3 = arg3;
    }

    @Override
    public String name() {
        return "LOAD_MODIFIER";
    }

    @Override
    public int length() {
        return 4;
    }

    public static SdfMacro match(SdfBuffer buff) {
        if ((buff.getAtIndex() & 0xF0) != 224) {
            return null;
        }
        int byte1 = buff.getAtIndexAndInc() & 0xFF;
        int byte2 = buff.getAtIndexAndInc() & 0xFF;
        int byte3 = buff.getAtIndexAndInc() & 0xFF;
        int byte4 = buff.getAtIndexAndInc() & 0xFF;
        return new LoadModifier(byte1, byte2, byte3, byte4);
    }

    String modTypeVal() {
        return StringUtil.getNameFromState(this.modType, modControlCodes, modControlNames);
    }

    String argVal() {
        String arg1Val = "" + this.arg1;
        String arg2Val = "" + this.arg2;
        String arg3Val = "" + this.arg3;
        return String.valueOf(arg1Val) + "," + arg2Val + "," + arg3Val;
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(this.byte0);
        buffer.setAtIndexAndInc(this.arg1);
        buffer.setAtIndexAndInc(this.arg2);
        buffer.setAtIndexAndInc(this.arg3);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return "Set Modifier " + this.modTypeVal() + '\n';
    }

    @Override
    public String oneInstructionString() {
        switch (this.modType) {
            case 0: {
                String args = this.argVal();
                return String.valueOf(this.name()) + ' ' + this.modTypeVal() + "," + args + '\n';
            }
            case 1: {
                String arg3Val;
                String arg1Val = (this.arg1 & 0xE0) == 128 ? (this.arg1 == 128 ? "IMMED_GAIN_MODIFY" : "IMMED_GAIN_MODIFY+0x" + StringUtil.twoHexFromInt(this.arg1 & 0x1F)) : ((this.arg1 & 0xE0) == 160 ? (this.arg1 == 160 ? "ANALOG_GAIN_MODIFY" : "ANALOG_GAIN_MODIFY+" + StringUtil.getNameFromState(this.arg1 & 0x1F, workRegCodes, workRegNames)) : StringUtil.twoHexFromInt(this.arg1));
                String arg2Val = StringUtil.getNameFromState(this.arg2, fixedCVCodes, fixedCVNames);
                if (arg2Val == null) {
                    arg2Val = "0x" + StringUtil.twoHexFromInt(this.arg2);
                }
                if ((arg3Val = this.decodeFlags(this.arg3, arg3ModCodes, arg3ModMasks, arg3ModNames)) == null) {
                    arg3Val = "0x" + StringUtil.twoHexFromInt(this.arg3);
                }
                return String.valueOf(this.name()) + ' ' + this.modTypeVal() + "," + arg1Val + "," + arg2Val + "," + arg3Val + '\n';
            }
            case 2: {
                String arg3Val;
                String arg1Val = (this.arg1 & 0xE0) == 128 ? (this.arg1 == 128 ? "CV_PITCH_MODIFY" : "CV_PITCH_MODIFY+0x" + StringUtil.twoHexFromInt(this.arg1 & 0x1F)) : ((this.arg1 & 0xE0) == 160 ? (this.arg1 == 160 ? "ANALOG_PITCH_MODIFY" : "ANALOG_PITCH_MODIFY+" + StringUtil.getNameFromState(this.arg1 & 0x1F, workRegCodes, workRegNames)) : StringUtil.twoHexFromInt(this.arg1));
                String arg2Val = StringUtil.getNameFromState(this.arg2, maxPCodes, maxPNames);
                if (arg2Val == null) {
                    arg2Val = "0x" + StringUtil.twoHexFromInt(this.arg2);
                }
                if ((arg3Val = StringUtil.getNameFromState(this.arg3, ditherPCodes, ditherPNames)) == null) {
                    arg3Val = "0x" + StringUtil.twoHexFromInt(this.arg3);
                }
                return String.valueOf(this.name()) + ' ' + this.modTypeVal() + "," + arg1Val + "," + arg2Val + "," + arg3Val + '\n';
            }
            case 3: {
                String arg3Val;
                String arg1Val = this.decodeFlags(this.arg1, blendArg1Codes, blendArg1Masks, blendArg1Names);
                String arg2Val = StringUtil.getNameFromState(this.arg2, blendArg2Codes, blendArg2Names);
                if (arg2Val == null) {
                    arg2Val = "0x" + StringUtil.twoHexFromInt(this.arg2);
                }
                if ((arg3Val = StringUtil.getNameFromState(this.arg3, blendArg3Codes, blendArg3Names)) == null) {
                    arg3Val = "0x" + StringUtil.twoHexFromInt(this.arg3);
                }
                return String.valueOf(this.name()) + ' ' + this.modTypeVal() + "," + arg1Val + "," + arg2Val + "," + arg3Val + '\n';
            }
            case 4: {
                String arg3Val;
                String arg1Val = String.valueOf(StringUtil.getNameFromState(this.arg1 & 0x38, scatCommandCodes, scatCommandNames)) + "+" + StringUtil.getNameFromState(this.arg1 & 3, scatChannelCodes, scatChannelNames);
                String arg2Val = StringUtil.getNameFromState(this.arg2, fixedCVCodes, fixedCVNames);
                if (arg2Val == null) {
                    arg2Val = "0x" + StringUtil.twoHexFromInt(this.arg2);
                }
                if ((arg3Val = StringUtil.getNameFromState(this.arg3, sintenCodes, sintenNames)) == null) {
                    arg3Val = "0x" + StringUtil.twoHexFromInt(this.arg3);
                }
                return String.valueOf(this.name()) + ' ' + this.modTypeVal() + "," + arg1Val + "," + arg2Val + "," + arg3Val + '\n';
            }
            case 5: {
                String arg1Val = StringUtil.getNameFromState(this.arg1, fixedCVCodes, fixedCVNames);
                if (arg1Val == null) {
                    arg1Val = "0x" + StringUtil.twoHexFromInt(this.arg1);
                }
                String arg2Val = "" + this.arg2;
                String arg3Val = "" + this.arg3;
                return String.valueOf(this.name()) + ' ' + this.modTypeVal() + "," + arg1Val + "," + arg2Val + "," + arg3Val + '\n';
            }
            case 6: {
                String temp1 = StringUtil.getNameFromState(this.arg1 & 0xE0, arg1ModCodes, arg1ModNames);
                String temp2 = StringUtil.getNameFromState(this.arg1 & 0x1F, workRegCodes, workRegNames);
                String arg1Val = temp1 != null && temp2 != null ? String.valueOf(temp1) + "+" + temp2 : (temp1 != null && temp2 == null ? temp1 : (temp1 == null && temp2 != null ? temp2 : "0"));
                String arg2Val = StringUtil.getNameFromState(this.arg2, maxPCodes, maxPNames);
                if (arg2Val == null) {
                    arg2Val = "0x" + StringUtil.twoHexFromInt(this.arg2);
                }
                String arg3Val = "" + this.arg3;
                if ((this.arg1 & 0x1F) == 7) {
                    arg2Val = this.decodeFlags(this.arg2, workStatusBitCodes, workStatusBitCodes, workStatusBitNames);
                }
                if ((this.arg1 & 0x1F) == 8 && this.arg2 == 192) {
                    arg2Val = "DEFAULT_GLBL_GAIN";
                }
                return String.valueOf(this.name()) + ' ' + this.modTypeVal() + "," + arg1Val + "," + arg2Val + "," + arg3Val + '\n';
            }
            case 7: {
                String temp1 = StringUtil.getNameFromState(this.arg1 & 0xE0, arg1ModCodes, arg1ModNames);
                String temp2 = StringUtil.getNameFromState(this.arg1 & 0x1F, workRegCodes, workRegNames);
                String arg1Val = temp1 != null && temp2 != null ? String.valueOf(temp1) + "+" + temp2 : (temp1 != null && temp2 == null ? temp1 : (temp1 == null && temp2 != null ? temp2 : "0"));
                String arg2Val = StringUtil.getNameFromState(this.arg2 & 0x1F, workRegCodes, workRegNames);
                if (arg2Val == null) {
                    arg2Val = "0x" + StringUtil.twoHexFromInt(this.arg2);
                }
                String arg3Val = "" + this.arg3;
                return String.valueOf(this.name()) + ' ' + this.modTypeVal() + "," + arg1Val + "," + arg2Val + "," + arg3Val + '\n';
            }
        }
        log.warn("Unhandled modifyer type code: {}", (Object)this.modType);
        return "<could not parse, should not happen>";
    }

    @Override
    public String allInstructionString(String indent) {
        return String.valueOf(indent) + this.oneInstructionString();
    }
}

