/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import java.util.ArrayList;
import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;
import jmri.util.StringUtil;

public class InitiateSound
extends SdfMacro {
    int prempt;
    int trigger;
    int byte1;
    int byte2;

    public InitiateSound(int byte1, int byte2) {
        this.byte1 = byte1;
        this.byte2 = byte2;
        this.trigger = byte2 & 0x7F;
        this.prempt = (byte1 & 7) + (byte2 & 0x80);
    }

    @Override
    public String name() {
        return "INITIATE_SOUND";
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void setTrigger(int t) {
        this.trigger = t & 0x7F;
        this.byte2 = this.byte2 & 0x80 | t & 0x7F;
    }

    public int getPrempt() {
        return this.prempt;
    }

    public void setPrempt(int prempt) {
        this.byte1 = this.byte1 & 0xF8 | prempt & 7;
        this.byte2 = this.byte2 & 0x7F | prempt & 0x80;
        this.prempt = (this.byte1 & 7) + (this.byte2 & 0x80);
    }

    @Override
    public int length() {
        return 2;
    }

    String premptVal() {
        return this.decodeFlags(this.prempt, premptCodes, premptMasks, premptNames);
    }

    String triggerVal() {
        String trigName = StringUtil.getNameFromState(this.trigger, triggerCodes, triggerNames);
        if (trigName != null) {
            return trigName;
        }
        return "(trigger = 0x" + StringUtil.twoHexFromInt(this.trigger) + ")";
    }

    public static SdfMacro match(SdfBuffer buff) {
        if ((buff.getAtIndex() & 0xF8) != 144) {
            return null;
        }
        int byte1 = buff.getAtIndexAndInc();
        int byte2 = buff.getAtIndexAndInc();
        InitiateSound result = new InitiateSound(byte1, byte2);
        while (buff.moreData()) {
            SdfMacro next;
            int peek = buff.getAtIndex() & 0xFF;
            if (peek == 241 || peek == 129) break;
            if ((peek & 0xF8) == 144) {
                byte1 = buff.getAtIndexAndInc();
                byte2 = buff.getAtIndexAndInc();
                next = new InitiateSound(byte1, byte2);
            } else {
                next = InitiateSound.decodeInstruction(buff);
            }
            if (result.children == null) {
                result.children = new ArrayList();
            }
            result.children.add(next);
            if (peek == 0) break;
        }
        return result;
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(this.byte1);
        buffer.setAtIndexAndInc(this.byte2);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return "Define Sequence " + this.triggerVal() + "," + this.premptVal() + '\n';
    }

    @Override
    public String oneInstructionString() {
        return String.valueOf(this.name()) + " " + this.triggerVal() + "," + this.premptVal() + '\n';
    }

    @Override
    public String allInstructionString(String indent) {
        String output = String.valueOf(indent) + this.oneInstructionString();
        if (this.children == null) {
            return output;
        }
        int i = 0;
        while (i < this.children.size()) {
            output = String.valueOf(output) + ((SdfMacro)this.children.get(i)).allInstructionString(String.valueOf(indent) + "  ");
            ++i;
        }
        return output;
    }
}

