/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;
import jmri.util.StringUtil;

public class FourByteMacro
extends SdfMacro {
    byte[] bytes = new byte[4];

    public FourByteMacro(int byte1, int byte2, int byte3, int byte4) {
        this.bytes[0] = (byte)(byte1 & 0xFF);
        this.bytes[1] = (byte)(byte2 & 0xFF);
        this.bytes[2] = (byte)(byte3 & 0xFF);
        this.bytes[3] = (byte)(byte4 & 0xFF);
    }

    @Override
    public String name() {
        return "Four Byte Macro";
    }

    @Override
    public int length() {
        return 4;
    }

    public static SdfMacro match(SdfBuffer buff) {
        if ((buff.getAtIndex() & 0xFF) < 224) {
            return null;
        }
        return new FourByteMacro(buff.getAtIndexAndInc(), buff.getAtIndexAndInc(), buff.getAtIndexAndInc(), buff.getAtIndexAndInc());
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(this.bytes[0]);
        buffer.setAtIndexAndInc(this.bytes[1]);
        buffer.setAtIndexAndInc(this.bytes[2]);
        buffer.setAtIndexAndInc(this.bytes[3]);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return String.valueOf(this.name()) + ' ' + StringUtil.hexStringFromBytes(this.bytes) + '\n';
    }

    @Override
    public String oneInstructionString() {
        return String.valueOf(this.name()) + ' ' + StringUtil.hexStringFromBytes(this.bytes) + '\n';
    }

    @Override
    public String allInstructionString(String indent) {
        return String.valueOf(indent) + this.oneInstructionString();
    }
}

