/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;

public class DelaySound
extends SdfMacro {
    int mode;
    int value;
    int glbl;
    int byte1;
    int byte2;

    public DelaySound(int byte1, int byte2) {
        this.mode = byte2 & 0x80;
        this.value = byte2 & 0x7F;
        this.glbl = byte1 & 1;
        this.byte1 = byte1;
        this.byte2 = byte2;
    }

    @Override
    public String name() {
        return "DELAY_SOUND";
    }

    @Override
    public int length() {
        return 2;
    }

    public static SdfMacro match(SdfBuffer buff) {
        if ((buff.getAtIndex() & 0xFE) != 180) {
            return null;
        }
        int byte1 = buff.getAtIndexAndInc();
        int byte2 = buff.getAtIndexAndInc();
        return new DelaySound(byte1, byte2);
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(this.byte1);
        buffer.setAtIndexAndInc(this.byte2);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return "Delay Sound\n";
    }

    @Override
    public String oneInstructionString() {
        String modeVal = this.mode == 0 ? "DELAY_THIS" : "DELAY_CV";
        String valueVal = this.mode == 0 ? "" + this.value : "CV=" + this.value;
        String glblVal = this.glbl == 1 ? "DELAY_GLOBAL" : "0";
        return String.valueOf(this.name()) + ' ' + modeVal + "," + valueVal + "," + glblVal + '\n';
    }

    @Override
    public String allInstructionString(String indent) {
        return String.valueOf(indent) + this.oneInstructionString();
    }
}

