/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import java.util.ArrayList;
import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;

public class ChannelStart
extends SdfMacro {
    int number;

    public ChannelStart(int number) {
        this.number = number;
    }

    @Override
    public String name() {
        return "CHANNEL_START";
    }

    @Override
    public int length() {
        return 2;
    }

    public static SdfMacro match(SdfBuffer buff) {
        if ((buff.getAtIndex() & 0xFF) != 129) {
            return null;
        }
        buff.getAtIndexAndInc();
        ChannelStart result = new ChannelStart(buff.getAtIndexAndInc());
        while (buff.moreData()) {
            int peek = buff.getAtIndex() & 0xFF;
            if (peek == 241 || peek == 129) break;
            SdfMacro next = ChannelStart.decodeInstruction(buff);
            if (result.children == null) {
                result.children = new ArrayList();
            }
            result.children.add(next);
        }
        return result;
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(129);
        buffer.setAtIndexAndInc(this.number);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return "Channel " + this.number + '\n';
    }

    @Override
    public String oneInstructionString() {
        return String.valueOf(this.name()) + ' ' + this.number + '\n';
    }

    @Override
    public String allInstructionString(String indent) {
        String output = String.valueOf(indent) + this.oneInstructionString();
        if (this.children == null) {
            return output;
        }
        int i = 0;
        while (i < this.children.size()) {
            output = String.valueOf(output) + ((SdfMacro)this.children.get(i)).allInstructionString(String.valueOf(indent) + "  ");
            ++i;
        }
        return output;
    }
}

