/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.sdf;

import jmri.jmrix.loconet.sdf.SdfBuffer;
import jmri.jmrix.loconet.sdf.SdfMacro;

public class BranchTo
extends SdfMacro {
    int byte1;
    int byte2;
    int addr;
    int skemebase;

    public BranchTo(int byte1, int byte2) {
        this.addr = (byte1 & 0xF) * 256 + byte2;
        this.skemebase = 0;
        this.byte1 = byte1;
        this.byte2 = byte2;
    }

    @Override
    public String name() {
        return "BRANCH_TO";
    }

    @Override
    public int length() {
        return 2;
    }

    public static SdfMacro match(SdfBuffer buff) {
        if ((buff.getAtIndex() & 0xF0) != 192) {
            return null;
        }
        int byte1 = buff.getAtIndexAndInc();
        int byte2 = buff.getAtIndexAndInc();
        return new BranchTo(byte1, byte2);
    }

    @Override
    public void loadByteArray(SdfBuffer buffer) {
        buffer.setAtIndexAndInc(this.byte1);
        buffer.setAtIndexAndInc(this.byte2);
        super.loadByteArray(buffer);
    }

    @Override
    public String toString() {
        return "Branch\n";
    }

    @Override
    public String oneInstructionString() {
        return String.valueOf(this.name()) + ' ' + this.addr + "; from base of " + this.skemebase + '\n';
    }

    @Override
    public String allInstructionString(String indent) {
        return String.valueOf(indent) + this.oneInstructionString();
    }
}

