/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.pr3;

import jmri.jmrix.AbstractPortController;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.locobuffer.LocoBufferAdapter;
import jmri.jmrix.loconet.pr2.LnPr2Packetizer;
import jmri.jmrix.loconet.pr3.Bundle;
import jmri.jmrix.loconet.pr3.PR3SystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class PR3Adapter
extends LocoBufferAdapter {
    private static final Logger log = LoggerFactory.getLogger(PR3Adapter.class);

    public PR3Adapter() {
        super(new PR3SystemConnectionMemo());
        this.options.remove(this.option2Name);
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("CommandStationTypeLabel"), this.commandStationOptions(), false));
    }

    @Override
    protected void setSerialPort(SerialPort activeSerialPort) throws UnsupportedCommOperationException {
        int baud = this.currentBaudNumber(this.mBaudRate);
        activeSerialPort.setSerialPortParams(baud, 8, 1, 0);
        int flow = 2;
        if (this.getOptionState(this.option1Name).equals(this.validOption1[1])) {
            flow = 0;
        }
        this.configureLeadsAndFlowControl(activeSerialPort, flow);
        log.info("PR3 adapter{}{} RTSCTS_OUT=2 RTSCTS_IN=1", (Object)(activeSerialPort.getFlowControlMode() == 2 ? " set hardware flow control, mode=" : " set no flow control, mode="), (Object)activeSerialPort.getFlowControlMode());
    }

    @Override
    public void configure() {
        this.setCommandStationType(this.getOptionState(this.option2Name));
        this.setTurnoutHandling(this.getOptionState(this.option3Name));
        if (this.commandStationType == LnCommandStationType.COMMAND_STATION_PR3_ALONE) {
            LnPr2Packetizer packets = new LnPr2Packetizer(this.getSystemConnectionMemo());
            packets.connectPort(this);
            this.getSystemConnectionMemo().setLnTrafficController(packets);
            this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable);
            this.getSystemConnectionMemo().configureManagersPR2();
            packets.startThreads();
            LocoNetMessage msg = new LocoNetMessage(6);
            msg.setOpCode(211);
            msg.setElement(1, 16);
            msg.setElement(2, 1);
            msg.setElement(3, 0);
            msg.setElement(4, 0);
            packets.sendLocoNetMessage(msg);
        } else {
            this.setTranspondingAvailable(this.getOptionState("TranspondingPresent"));
            LnPacketizer packets = this.getPacketizer(this.getOptionState(this.option4Name));
            packets.connectPort(this);
            this.getSystemConnectionMemo().setLnTrafficController(packets);
            this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable);
            this.getSystemConnectionMemo().configureManagersMS100();
            packets.startThreads();
            LocoNetMessage msg = new LocoNetMessage(6);
            msg.setOpCode(211);
            msg.setElement(1, 16);
            msg.setElement(2, 0);
            if (this.commandStationType == LnCommandStationType.COMMAND_STATION_STANDALONE) {
                msg.setElement(2, 3);
            }
            msg.setElement(3, 0);
            msg.setElement(4, 0);
            packets.sendLocoNetMessage(msg);
        }
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"57,600 baud"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{57600};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    public String[] commandStationOptions() {
        String[] retval = new String[this.commandStationNames.length + 2];
        retval[0] = LnCommandStationType.COMMAND_STATION_PR3_ALONE.getName();
        int i = 0;
        while (i < this.commandStationNames.length) {
            retval[i + 1] = this.commandStationNames[i];
            ++i;
        }
        retval[retval.length - 1] = LnCommandStationType.COMMAND_STATION_STANDALONE.getName();
        return retval;
    }

    @Override
    public PR3SystemConnectionMemo getSystemConnectionMemo() {
        LocoNetSystemConnectionMemo m = super.getSystemConnectionMemo();
        if (m instanceof PR3SystemConnectionMemo) {
            return (PR3SystemConnectionMemo)m;
        }
        log.error("Cannot cast the system connection memo to a PR3SystemConnection Memo.");
        return null;
    }
}

