/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.pr2;

import jmri.AddressedProgrammerManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.PowerManager;
import jmri.ThrottleManager;
import jmri.jmrix.loconet.LnPowerManager;
import jmri.jmrix.loconet.LnPr2ThrottleManager;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotManager;
import jmri.jmrix.loconet.pr2.LnPr2PowerManager;

public class PR2SystemConnectionMemo
extends LocoNetSystemConnectionMemo {
    public PR2SystemConnectionMemo(LnTrafficController lt, SlotManager sm) {
        super(lt, sm);
    }

    public PR2SystemConnectionMemo() {
    }

    @Override
    public void configureManagers() {
        InstanceManager.store(this.getPowerPr2Manager(), PowerManager.class);
        InstanceManager.setThrottleManager(this.getPr2ThrottleManager());
        if (this.getProgrammerManager().isAddressedModePossible()) {
            InstanceManager.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
        }
        if (this.getProgrammerManager().isGlobalProgrammerAvailable()) {
            InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        }
        this.register();
    }

    public LnPr2PowerManager getPowerPr2Manager() {
        if (this.getDisabled()) {
            return null;
        }
        return (LnPr2PowerManager)this.classObjectMap.computeIfAbsent(PowerManager.class, c -> new LnPr2PowerManager(this));
    }

    public LnPr2ThrottleManager getPr2ThrottleManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (LnPr2ThrottleManager)this.classObjectMap.computeIfAbsent(ThrottleManager.class, c -> new LnPr2ThrottleManager(this));
    }

    @Override
    public void dispose() {
        InstanceManager.deregister(this, PR2SystemConnectionMemo.class);
        LnPr2PowerManager powerPr2Manager = (LnPr2PowerManager)this.get(PowerManager.class);
        if (powerPr2Manager != null) {
            powerPr2Manager.dispose();
            InstanceManager.deregister(powerPr2Manager, LnPowerManager.class);
            this.deregister(powerPr2Manager, PowerManager.class);
        }
        super.dispose();
    }
}

