/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.pr2;

import jmri.jmrix.AbstractPortController;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.locobuffer.LocoBufferAdapter;
import jmri.jmrix.loconet.pr2.Bundle;
import jmri.jmrix.loconet.pr2.LnPr2Packetizer;
import jmri.jmrix.loconet.pr2.PR2SystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class PR2Adapter
extends LocoBufferAdapter {
    private static final Logger log = LoggerFactory.getLogger(PR2Adapter.class);

    public PR2Adapter() {
        super(new PR2SystemConnectionMemo());
        this.options.remove(this.option2Name);
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("CommandStationTypeLabel"), this.commandStationOptions(), false));
    }

    @Override
    protected void setSerialPort(SerialPort activeSerialPort) throws UnsupportedCommOperationException {
        int baud = this.currentBaudNumber(this.mBaudRate);
        activeSerialPort.setSerialPortParams(baud, 8, 1, 0);
        int flow = 2;
        if (this.getOptionState(this.option1Name).equals(this.validOption1[1])) {
            flow = 0;
        }
        this.configureLeadsAndFlowControl(activeSerialPort, flow);
        log.info("PR2 adapter{}{} RTSCTS_OUT=2 RTSCTS_IN=1", (Object)(activeSerialPort.getFlowControlMode() == 2 ? " set hardware flow control, mode=" : " set no flow control, mode="), (Object)activeSerialPort.getFlowControlMode());
    }

    @Override
    public void configure() {
        this.setCommandStationType(this.getOptionState(this.option2Name));
        this.setTurnoutHandling(this.getOptionState(this.option3Name));
        LnPr2Packetizer packets = new LnPr2Packetizer();
        packets.connectPort(this);
        this.getSystemConnectionMemo().setLnTrafficController(packets);
        this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable);
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"57,600 baud"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{57600};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    public String[] commandStationOptions() {
        return new String[]{LnCommandStationType.COMMAND_STATION_PR2_ALONE.getName()};
    }
}

