/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.pr2;

import javax.swing.Timer;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrix.loconet.LnOpsModeProgrammer;
import jmri.jmrix.loconet.LnPowerManager;
import jmri.jmrix.loconet.LnPr2ThrottleManager;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;

public class LnPr2PowerManager
extends LnPowerManager {
    LnTrafficController tc;
    LnOpsModeProgrammer pm = null;
    Timer timer = null;

    public LnPr2PowerManager(LocoNetSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getLnTrafficController();
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        if (v == 2) {
            DccLocoAddress activeAddress = ((LnPr2ThrottleManager)InstanceManager.throttleManagerInstance()).getActiveAddress();
            if (activeAddress != null) {
                this.pm = new LnOpsModeProgrammer((LocoNetSystemConnectionMemo)this.memo, activeAddress.getNumber(), activeAddress.isLongAddress());
                this.checkOpsProg();
                this.pm.writeCV("128", 1, null);
                this.power = 2;
                this.firePowerPropertyChange(old, this.power);
                if (this.timer == null) {
                    this.timer = new Timer(2000, e -> this.refresh());
                    this.timer.setInitialDelay(2000);
                    this.timer.setRepeats(true);
                }
                this.timer.start();
            }
        } else if (v == 4) {
            DccLocoAddress activeAddress;
            if (this.timer != null) {
                this.timer.stop();
            }
            if ((activeAddress = ((LnPr2ThrottleManager)InstanceManager.throttleManagerInstance()).getActiveAddress()) != null) {
                this.pm = new LnOpsModeProgrammer((LocoNetSystemConnectionMemo)this.memo, activeAddress.getNumber(), activeAddress.isLongAddress());
                this.checkOpsProg();
                this.pm.writeCV("128", 0, null);
                this.power = 4;
            }
        }
        this.firePowerPropertyChange(old, this.power);
    }

    void refresh() {
        LocoNetMessage msg = new LocoNetMessage(2);
        msg.setOpCode(129);
        this.tc.sendLocoNetMessage(msg);
    }

    private void checkOpsProg() throws JmriException {
        if (this.pm == null) {
            throw new JmriException("Use PR2 power manager after dispose");
        }
    }

    @Override
    public void message(LocoNetMessage m) {
        int[] data;
        int old = this.power;
        if (m.getOpCode() == 131) {
            this.power = 2;
        } else if (m.getOpCode() == 130) {
            this.power = 4;
            if (this.timer != null) {
                this.timer.stop();
            }
        } else if (m.getOpCode() == 239) {
            if (m.getElement(1) == 14 && m.getElement(2) == 124 && (m.getElement(3) & 4) == 0 && this.power == 2) {
                this.power = 4;
                if (this.timer != null) {
                    this.timer.stop();
                }
            }
        } else if (m.getOpCode() == 229 && m.getElement(1) == 16 && m.getElement(2) == 34 && m.getElement(3) == 34 && m.getElement(4) == 1 && ((data = m.getPeerXfrData())[2] & 0x40) != 64 && this.power == 2) {
            this.power = 4;
            if (this.timer != null) {
                this.timer.stop();
            }
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public boolean implementsIdle() {
        return false;
    }
}

