/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.ms100;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LnPortController;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.ms100.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class MS100Adapter
extends LnPortController {
    Vector<String> portNameVector = null;
    SerialPort activeSerialPort = null;
    private boolean opened = false;
    InputStream serialInStream = null;
    OutputStream serialOutStream = null;
    private static final Logger log = LoggerFactory.getLogger(MS100Adapter.class);

    public MS100Adapter() {
        super(new LocoNetSystemConnectionMemo());
        this.option2Name = "CommandStation";
        this.option3Name = "TurnoutHandle";
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("CommandStationTypeLabel"), this.commandStationNames, false));
        this.options.put(this.option3Name, new AbstractPortController.Option(Bundle.getMessage("TurnoutHandling"), new String[]{Bundle.getMessage("HandleNormal"), Bundle.getMessage("HandleSpread"), Bundle.getMessage("HandleOneOnly"), Bundle.getMessage("HandleBoth")}));
    }

    @Override
    public Vector<String> getPortNames() {
        this.portNameVector = new Vector();
        Enumeration<CommPortIdentifier> portIDs = CommPortIdentifier.getPortIdentifiers();
        while (portIDs.hasMoreElements()) {
            CommPortIdentifier id = portIDs.nextElement();
            if (id.getPortType() == 2) continue;
            this.portNameVector.addElement(id.getName());
        }
        return this.portNameVector;
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.activeSerialPort.setSerialPortParams(16600, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                log.warn("attempting to fall back to 16457 baud after 16600 failed");
                try {
                    this.activeSerialPort.setSerialPortParams(16457, 8, 1, 0);
                }
                catch (UnsupportedCommOperationException unsupportedCommOperationException2) {
                    log.warn("trouble setting 16600 baud");
                    JOptionPane.showMessageDialog(null, "Failed to set the correct baud rate for the MS100. Port is set to " + this.activeSerialPort.getBaudRate() + " baud. See the README file for more info.", "Connection failed", 0);
                }
            }
            this.configureLeadsAndFlowControl(this.activeSerialPort, 0, true, false);
            try {
                this.activeSerialPort.enableReceiveTimeout(10);
                log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            }
            catch (UnsupportedCommOperationException et) {
                log.info("failed to set serial timeout: {}", (Throwable)et);
            }
            this.serialInStream = this.activeSerialPort.getInputStream();
            this.serialOutStream = this.activeSerialPort.getOutputStream();
            this.purgeStream(this.serialInStream);
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException ex) {
            log.error("Unexpected exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    @Override
    public void configure() {
        this.setCommandStationType(this.getOptionState(this.option2Name));
        this.setTurnoutHandling(this.getOptionState(this.option3Name));
        LnPacketizer packets = new LnPacketizer(this.getSystemConnectionMemo());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setLnTrafficController(packets);
        this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable);
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialInStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
            return null;
        }
        return new DataOutputStream(this.serialOutStream);
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"fixed at 16,600 baud"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{16600};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    @Override
    public void configureOption2(String value) {
        super.configureOption2(value);
        log.debug("configureOption2: {}", (Object)value);
        this.setCommandStationType(value);
    }
}

