/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.messageinterp;

import java.time.LocalTime;
import java.util.ArrayList;
import jmri.InstanceManager;
import jmri.NmraPacket;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrix.loconet.LnConstants;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.lnsvf2.LnSv2MessageContents;
import jmri.jmrix.loconet.messageinterp.Bundle;
import jmri.jmrix.loconet.uhlenbrock.LncvMessageContents;
import jmri.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoNetMessageInterpret {
    private static final String[] ds54sensors = new String[]{"AuxA", "SwiA", "AuxB", "SwiB", "AuxC", "SwiC", "AuxD", "SwiD"};
    private static final String[] ds64sensors = new String[]{"A1", "S1", "A2", "S2", "A3", "S3", "A4", "S4"};
    private static final String[] se8csensors = new String[]{"DS01", "DS02", "DS03", "DS04", "DS05", "DS06", "DS07", "DS08"};
    private static final Logger log = LoggerFactory.getLogger(LocoNetMessageInterpret.class);

    public static String interpretMessage(LocoNetMessage l, String turnoutPrefix, String sensorPrefix, String reporterPrefix) {
        String result = "";
        switch (l.getOpCode()) {
            case 133: {
                return Bundle.getMessage("LN_MSG_IDLE");
            }
            case 131: {
                return Bundle.getMessage("LN_MSG_GPON");
            }
            case 130: {
                return Bundle.getMessage("LN_MSG_GPOFF");
            }
            case 129: {
                return Bundle.getMessage("LN_MSG_MASTER_BUSY");
            }
            case 138: {
                return Bundle.getMessage("LN_MSG_RE_LOCO_RESET");
            }
            case 191: {
                String locoAddress = LocoNetMessageInterpret.convertToMixed(l.getElement(2), l.getElement(1));
                return Bundle.getMessage("LN_MSG_REQ_SLOT_FOR_ADDR", locoAddress);
            }
            case 190: {
                String locoAddress = LocoNetMessageInterpret.convertToMixed(l.getElement(2), l.getElement(1));
                return Bundle.getMessage("LN_MSG_REQ_EXP_SLOT_FOR_ADDR", locoAddress);
            }
            case 189: {
                result = LocoNetMessageInterpret.interpretOpcSwAck(l, turnoutPrefix);
                if (result.length() <= 0) break;
                return result;
            }
            case 188: {
                result = LocoNetMessageInterpret.interpretOpcSwState(l, turnoutPrefix);
                if (result.length() <= 0) break;
                return result;
            }
            case 187: {
                result = LocoNetMessageInterpret.interpretOpcRqSlData(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 186: {
                result = LocoNetMessageInterpret.interpretOpcMoveSlots(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 185: {
                int src = l.getElement(1);
                int dest = l.getElement(2);
                return Bundle.getMessage("LN_MSG_LINK_SLOTS", src, dest);
            }
            case 184: {
                int src = l.getElement(1);
                int dest = l.getElement(2);
                return Bundle.getMessage("LN_MSG_UNLINK_SLOTS", src, dest);
            }
            case 182: {
                result = LocoNetMessageInterpret.interpretOpcConsistFunc(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 181: {
                int slot = l.getElement(1);
                int stat = l.getElement(2);
                return Bundle.getMessage("LN_MSG_SLOT_STAT1", slot, stat, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(stat)), LnConstants.CONSIST_STAT(stat), LnConstants.LOCO_STAT(stat), LnConstants.DEC_MODE(stat));
            }
            case 180: {
                result = LocoNetMessageInterpret.interpretLongAck(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 178: {
                result = LocoNetMessageInterpret.interpretOpcInputRep(l, sensorPrefix);
                if (result.length() <= 0) break;
                return result;
            }
            case 177: {
                result = LocoNetMessageInterpret.interpretOpcSwRep(l, turnoutPrefix);
                if (result.length() <= 0) break;
                return result;
            }
            case 176: {
                result = LocoNetMessageInterpret.interpretOpcSwReq(l, turnoutPrefix);
                if (result.length() <= 0) break;
                return result;
            }
            case 162: {
                result = LocoNetMessageInterpret.interpretOpcLocoSnd(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 161: {
                result = LocoNetMessageInterpret.interpretOpcLocoDirf(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 160: {
                result = LocoNetMessageInterpret.interpretOpcLocoSpd(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 213: {
                result = LocoNetMessageInterpret.interpretPocExpLocoSpdDirFunction(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 223: {
                result = LocoNetMessageInterpret.interpretOpcPanelQuery(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 215: {
                result = LocoNetMessageInterpret.interpretOpcPanelResponse(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 208: {
                result = LocoNetMessageInterpret.interpretOpcMultiSense(l, reporterPrefix);
                if (result.length() <= 0) break;
                return result;
            }
            case 224: {
                result = LocoNetMessageInterpret.interpretOpcMultiSenseLong(l, reporterPrefix);
                if (result.length() <= 0) break;
                return result;
            }
            case 231: 
            case 239: {
                result = LocoNetMessageInterpret.interpretOpcWrSlDataOpcSlRdData(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 230: 
            case 238: {
                result = LocoNetMessageInterpret.interpretAlm(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 229: {
                result = LocoNetMessageInterpret.interpretOpcPeerXfer(l, reporterPrefix);
                if (result.length() <= 0) break;
                return result;
            }
            case 228: {
                result = LocoNetMessageInterpret.interpretOpcLissyUpdate(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 237: {
                result = LocoNetMessageInterpret.interpretOpcImmPacket(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 211: {
                result = LocoNetMessageInterpret.interpretOpcPr3Mode(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 163: {
                result = LocoNetMessageInterpret.interpretIb2F9_to_F12(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 212: {
                result = LocoNetMessageInterpret.interpretIb2Special(l);
                if (result.length() > 0) {
                    return result;
                }
                result = LocoNetMessageInterpret.interpretOpcExpMoveSlots(l);
                if (result.length() <= 0) break;
                return result;
            }
        }
        return String.valueOf(Bundle.getMessage("LN_MSG_UNKNOWN_MESSAGE")) + Bundle.getMessage("LN_MONITOR_MESSAGE_RAW_HEX_INFO", l.toString());
    }

    private static String interpretOpcPeerXfer20_1(LocoNetMessage l) {
        switch (l.getElement(3)) {
            case 8: {
                return Bundle.getMessage("LN_MSG_DUPLEX_RECEIVER_QUERY");
            }
            case 16: {
                return Bundle.getMessage("LN_MSG_DUPLEX_RECEIVER_RESPONSE");
            }
        }
        return "";
    }

    private static String interpretOpcPeerXfer20_2(LocoNetMessage l) {
        switch (l.getElement(3)) {
            case 0: {
                int channel = l.getElement(5) | (l.getElement(4) & 1) << 7;
                return Bundle.getMessage("LN_MSG_DUPLEX_CHANNEL_SET", Integer.toString(channel));
            }
            case 8: {
                return Bundle.getMessage("LN_MSG_DUPLEX_CHANNEL_QUERY");
            }
            case 16: {
                int channel = l.getElement(5) | (l.getElement(4) & 1) << 7;
                return Bundle.getMessage("LN_MSG_DUPLEX_CHANNEL_REPORT", Integer.toString(channel));
            }
        }
        return "";
    }

    private static String interpretOpcPeerXfer20_3(LocoNetMessage l) {
        char[] groupNameArray = new char[]{(char)(l.getElement(5) | (l.getElement(4) & 1) << 7), (char)(l.getElement(6) | (l.getElement(4) & 2) << 6), (char)(l.getElement(7) | (l.getElement(4) & 4) << 5), (char)(l.getElement(8) | (l.getElement(4) & 8) << 4), (char)(l.getElement(10) | (l.getElement(9) & 1) << 7), (char)(l.getElement(11) | (l.getElement(9) & 2) << 6), (char)(l.getElement(12) | (l.getElement(9) & 4) << 5), (char)(l.getElement(13) | (l.getElement(9) & 8) << 4)};
        String groupName = new String(groupNameArray);
        int p1 = (l.getElement(14) & 1) << 3 | (l.getElement(15) & 0x70) >> 4;
        int p2 = l.getElement(15) & 0xF;
        int p3 = (l.getElement(14) & 2) << 2 | (l.getElement(16) & 0x70) >> 4;
        int p4 = l.getElement(16) & 0xF;
        String passcode = String.valueOf(StringUtil.twoHexFromInt(p1)) + StringUtil.twoHexFromInt(p2) + StringUtil.twoHexFromInt(p3) + StringUtil.twoHexFromInt(p4);
        int channel = l.getElement(17) | (l.getElement(14) & 4) << 5;
        int id = l.getElement(18) | (l.getElement(14) & 8) << 4;
        switch (l.getElement(3)) {
            case 0: {
                return Bundle.getMessage("LN_MSG_DUPLEX_NAME_WRITE", groupName);
            }
            case 8: {
                return Bundle.getMessage("LN_MSG_DUPLEX_NAME_QUERY");
            }
            case 16: {
                return Bundle.getMessage("LN_MSG_DUPLEX_NAME_REPORT", groupName, passcode, channel, id);
            }
        }
        return "";
    }

    private static String interpretOpcPeerXfer20_4(LocoNetMessage l) {
        int id = l.getElement(5) | (l.getElement(4) & 1) << 7;
        switch (l.getElement(3)) {
            case 0: {
                return Bundle.getMessage("LN_MSG_DUPLEX_ID_SET", id);
            }
            case 8: {
                return Bundle.getMessage("LN_MSG_DUPLEX_ID_QUERY");
            }
            case 16: {
                return Bundle.getMessage("LN_MSG_DUPLEX_ID_REPORT", id);
            }
        }
        return "";
    }

    private static String interpretOpcPeerXfer20_7(LocoNetMessage l) {
        if (l.getElement(3) == 8) {
            return Bundle.getMessage("LN_MSG_DUPLEX_PASSWORD_QUERY");
        }
        if (l.getElement(5) < 48 || l.getElement(5) > 60 || l.getElement(6) < 48 || l.getElement(6) > 60 || l.getElement(7) < 48 || l.getElement(7) > 60 || l.getElement(8) < 48 || l.getElement(8) > 60) {
            return "";
        }
        char[] groupPasswordArray = new char[]{(char)l.getElement(5), (char)l.getElement(6), (char)l.getElement(7), (char)l.getElement(8)};
        if (groupPasswordArray[0] > '9' && groupPasswordArray[0] < '=') {
            groupPasswordArray[0] = (char)(groupPasswordArray[0] + 7);
        }
        if (groupPasswordArray[1] > '9' && groupPasswordArray[1] < '=') {
            groupPasswordArray[1] = (char)(groupPasswordArray[1] + 7);
        }
        if (groupPasswordArray[2] > '9' && groupPasswordArray[2] < '=') {
            groupPasswordArray[2] = (char)(groupPasswordArray[2] + 7);
        }
        if (groupPasswordArray[3] > '9' && groupPasswordArray[3] < '=') {
            groupPasswordArray[3] = (char)(groupPasswordArray[3] + 7);
        }
        String groupPassword = new String(groupPasswordArray);
        switch (l.getElement(3)) {
            case 0: {
                return Bundle.getMessage("LN_MSG_DUPLEX_PASSWORD_SET", groupPassword);
            }
            case 16: {
                return Bundle.getMessage("LN_MSG_DUPLEX_PASSWORD_REPORT", groupPassword);
            }
        }
        return "";
    }

    private static String interpretOpcPeerXfer20_10(LocoNetMessage l) {
        switch (l.getElement(3)) {
            case 8: {
                return Bundle.getMessage("LN_MSG_DUPLEX_CHANNEL_SCAN_QUERY", l.getElement(5));
            }
            case 16: {
                int level = (l.getElement(6) & 0x7F) + ((l.getElement(4) & 2) << 6);
                return Bundle.getMessage("LN_MSG_DUPLEX_CHANNEL_SCAN_REPORT", l.getElement(5), level);
            }
        }
        return "";
    }

    private static String interpretOpcPeerXfer20_8(LocoNetMessage l) {
        switch (l.getElement(3)) {
            case 8: {
                if ((l.getElement(4) & 0xF) == 0 && l.getElement(5) == 0 && l.getElement(6) == 0 && l.getElement(7) == 0 && l.getElement(8) == 0 || l.getElement(9) != 0 || l.getElement(10) != 0 || l.getElement(11) != 0 || l.getElement(12) != 0 || l.getElement(13) != 0 || l.getElement(14) != 0 || l.getElement(15) != 0 || l.getElement(16) != 0 || l.getElement(17) != 0 || l.getElement(18) != 0) break;
                int hostSnInt = l.getElement(5) + ((l.getElement(4) & 1) == 1 ? 128 : 0) + (l.getElement(6) + ((l.getElement(4) & 2) == 2 ? 128 : 0)) * 256 + (l.getElement(7) + ((l.getElement(4) & 4) == 4 ? 128 : 0)) * 256 * 256 + (l.getElement(8) + ((l.getElement(4) & 8) == 8 ? 128 : 0)) * 256 * 256 * 256;
                return Bundle.getMessage("LN_MSG_DUPLEX_PING_REQUEST", Integer.toHexString(hostSnInt).toUpperCase());
            }
            case 16: {
                if ((l.getElement(4) & 0xF) == 0 && l.getElement(5) == 0 && l.getElement(6) == 0 && l.getElement(7) == 0 && l.getElement(8) == 0) break;
                int hostSnInt = l.getElement(5) + ((l.getElement(4) & 1) == 1 ? 128 : 0) + (l.getElement(6) + ((l.getElement(4) & 2) == 2 ? 128 : 0)) * 256 + (l.getElement(7) + ((l.getElement(4) & 4) == 4 ? 128 : 0)) * 256 * 256 + (l.getElement(8) + ((l.getElement(4) & 8) == 8 ? 128 : 0)) * 256 * 256 * 256;
                return Bundle.getMessage("LN_MSG_DUPLEX_PING_REPORT", Integer.toHexString(hostSnInt).toUpperCase(), StringUtil.twoHexFromInt(l.getElement(12) + ((l.getElement(9) & 4) == 4 ? 128 : 0)).toUpperCase(), StringUtil.twoHexFromInt(l.getElement(13) + ((l.getElement(9) & 8) == 8 ? 128 : 0)).toUpperCase());
            }
        }
        return "";
    }

    private static String interpretOpcPeerXfer20_0f(LocoNetMessage l) {
        switch (l.getElement(3)) {
            case 8: {
                if (l.getElement(4) == 0 && l.getElement(5) == 0 && l.getElement(6) == 0 && l.getElement(7) == 0 && l.getElement(8) == 0 && l.getElement(9) == 0 && l.getElement(10) == 0 && l.getElement(11) == 1 && l.getElement(12) == 0 && l.getElement(13) == 0 && l.getElement(14) == 0 && l.getElement(15) == 0 && l.getElement(16) == 0 && l.getElement(17) == 0 && l.getElement(18) == 0) {
                    return Bundle.getMessage("LN_MSG_IPL_DISCOVER_ALL_DEVICES");
                }
                if (l.getElement(5) == 0 && l.getElement(6) == 0) break;
                String device = LocoNetMessageInterpret.getDeviceNameFromIPLInfo(l.getElement(4), l.getElement(5));
                String slave = LocoNetMessageInterpret.getSlaveNameFromIPLInfo(l.getElement(4), l.getElement(6));
                return Bundle.getMessage("LN_MSG_IPL_DISCOVER_SPECIFIC_DEVICES", device, slave);
            }
            case 16: {
                return LocoNetMessageInterpret.interpretOpcPeerXfer20Sub10(l);
            }
        }
        return "";
    }

    private static String interpretOpcPeerXfer20(LocoNetMessage l) {
        switch (l.getElement(2)) {
            case 1: {
                String result = LocoNetMessageInterpret.interpretOpcPeerXfer20_1(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 2: {
                String result = LocoNetMessageInterpret.interpretOpcPeerXfer20_2(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 3: {
                String result = LocoNetMessageInterpret.interpretOpcPeerXfer20_3(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 4: {
                String result = LocoNetMessageInterpret.interpretOpcPeerXfer20_4(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 7: {
                String result = LocoNetMessageInterpret.interpretOpcPeerXfer20_7(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 16: {
                String result = LocoNetMessageInterpret.interpretOpcPeerXfer20_10(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 8: {
                String result = LocoNetMessageInterpret.interpretOpcPeerXfer20_8(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 15: {
                String result = LocoNetMessageInterpret.interpretOpcPeerXfer20_0f(l);
                if (result.length() <= 0) break;
                return result;
            }
        }
        return "";
    }

    private static String interpretOpcPeerXfer20Sub10(LocoNetMessage l) {
        String slaveInfo;
        String hostType = LocoNetMessageInterpret.getDeviceNameFromIPLInfo(l.getElement(4), l.getElement(5));
        String hostVer = String.valueOf((l.getElement(8) & 0x78) >> 3) + "." + (l.getElement(8) & 7);
        int hostSnInt = (l.getElement(13) + ((l.getElement(9) & 8) == 8 ? 128 : 0)) * 256 * 256 + (l.getElement(12) + ((l.getElement(9) & 4) == 4 ? 128 : 0)) * 256 + (l.getElement(11) + ((l.getElement(9) & 2) == 2 ? 128 : 0));
        String hostSN = Integer.toHexString(hostSnInt).toUpperCase();
        String hostInfo = Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_HOST_DETAILS", hostType, hostSN, hostVer);
        String slaveType = LocoNetMessageInterpret.getSlaveNameFromIPLInfo(l.getElement(4), l.getElement(6));
        if (l.getElement(6) != 0) {
            String slaveVer = String.valueOf(((l.getElement(10) & 0x78) >> 3) + ((l.getElement(9) & 1) << 4)) + "." + (l.getElement(10) & 7);
            int slaveSnInt = l.getElement(15) + ((l.getElement(14) & 1) == 1 ? 128 : 0) + (l.getElement(16) + ((l.getElement(14) & 2) == 2 ? 128 : 0)) * 256 + (l.getElement(17) + ((l.getElement(14) & 4) == 4 ? 128 : 0)) * 256 * 256 + (l.getElement(18) + ((l.getElement(14) & 8) == 8 ? 128 : 0)) * 256 * 256 * 256;
            slaveInfo = Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_SLAVE_DETAILS", slaveType, Integer.toHexString(slaveSnInt).toUpperCase(), slaveVer);
        } else {
            slaveInfo = Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_SLAVE_NO_SLAVE");
        }
        return Bundle.getMessage("LN_MSG_IPL_DEVICE_IDENTITY_REPORT", hostInfo, slaveInfo);
    }

    private static String interpretOpcPeerXfer16(LocoNetMessage l) {
        int src = l.getElement(2);
        int dst_l = l.getElement(3);
        int dst_h = l.getElement(4);
        int pxct1 = l.getElement(5);
        int pxct2 = l.getElement(10);
        int[] d = l.getPeerXfrData();
        if (src == 127 && dst_l == 127 && dst_h == 127 && (pxct1 & 0x70) == 64) {
            int sub = pxct2 & 0x70;
            switch (sub) {
                case 0: {
                    return Bundle.getMessage("LN_MSG_IPL_SETUP", l.getElement(6), l.getElement(8), l.getElement(9), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(l.getElement(7))), l.getElement(11));
                }
                case 16: {
                    return Bundle.getMessage("LN_MSG_IPL_SET_ADDRESS", Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", String.valueOf(StringUtil.twoHexFromInt(d[0])) + StringUtil.twoHexFromInt(d[1]) + StringUtil.twoHexFromInt(d[2])));
                }
                case 32: 
                case 48: {
                    return Bundle.getMessage(sub == 32 ? "LN_MSG_IPL_SEND_DATA" : "LN_MSG_IPL_VERIFY_REQUEST", Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(d[0])), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(d[1])), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(d[2])), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(d[3])), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(d[4])), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(d[5])), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(d[6])), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(d[7])));
                }
                case 64: {
                    return Bundle.getMessage("LN_MSG_IPL_END");
                }
            }
        }
        if (src == 127 && dst_l == 0 && dst_h == 0 && (pxct1 & 3) == 0 && (pxct2 & 0x70) == 112) {
            return Bundle.getMessage("LN_MSG_THROTTLE_SEMAPHORE", d[0] * 128 + d[1], Bundle.getMessage((d[2] & 0x10) == 16 ? "LN_MSG_THROTTLE_SEMAPHORE_HELPER_LIT" : "LN_MSG_THROTTLE_SEMAPHORE_HELPER_UNLIT"), Bundle.getMessage((d[2] & 8) == 8 ? "LN_MSG_THROTTLE_SEMAPHORE_HELPER_LIT" : "LN_MSG_THROTTLE_SEMAPHORE_HELPER_UNLIT"), Bundle.getMessage((d[2] & 4) == 4 ? "LN_MSG_THROTTLE_SEMAPHORE_HELPER_LIT" : "LN_MSG_THROTTLE_SEMAPHORE_HELPER_UNLIT"), Bundle.getMessage((d[2] & 2) == 2 ? "LN_MSG_THROTTLE_SEMAPHORE_HELPER_LIT" : "LN_MSG_THROTTLE_SEMAPHORE_HELPER_UNLIT"), Bundle.getMessage((d[2] & 1) == 1 ? "LN_MSG_THROTTLE_SEMAPHORE_HELPER_BLINKING" : "LN_MSG_THROTTLE_SEMAPHORE_HELPER_UNBLINKING"));
        }
        if (src == 127 && (pxct1 & 0x70) == 0) {
            if (dst_l == 0 && dst_h == 0) {
                char[] c = new char[]{(char)d[0], (char)d[1], (char)d[2], (char)d[3], (char)d[4], (char)d[5], (char)d[6], (char)d[7]};
                return Bundle.getMessage("LN_MSG_THROTTLE_TEXT_MESSAGE_ALL_THROTTLES", Character.valueOf(c[0]), Character.valueOf(c[1]), Character.valueOf(c[2]), Character.valueOf(c[3]), Character.valueOf(c[4]), Character.valueOf(c[5]), Character.valueOf(c[6]), Character.valueOf(c[7]));
            }
            return Bundle.getMessage("LN_MSG_THROTTLE_TEXT_MESSAGE_SPECIFIC_THROTTLE", Character.valueOf((char)d[0]), Character.valueOf((char)d[1]), Character.valueOf((char)d[2]), Character.valueOf((char)d[3]), Character.valueOf((char)d[4]), Character.valueOf((char)d[5]), Character.valueOf((char)d[6]), Character.valueOf((char)d[7]), LocoNetMessageInterpret.convertToMixed(dst_l, dst_h));
        }
        String result = LocoNetMessageInterpret.interpretSV1Message(l);
        if (result.length() > 0) {
            return result;
        }
        result = LocoNetMessageInterpret.interpretSV0Message(l);
        if (result.length() > 0) {
            return result;
        }
        result = LocoNetMessageInterpret.interpretSV2Message(l);
        if (result.length() > 0) {
            return result;
        }
        return "";
    }

    private static String interpretOpcPeerXfer15(LocoNetMessage l) {
        String result = LocoNetMessageInterpret.interpretLncvMessage(l);
        if (result.length() > 0) {
            return result;
        }
        return "";
    }

    private static String interpretSV1Message(LocoNetMessage l) {
        int[] d = l.getPeerXfrData();
        if (l.getElement(4) != 1 || (l.getElement(5) & 0x70) != 0 || (l.getElement(10) & 0x70) != 16) {
            return "";
        }
        if (l.getElement(2) == 80) {
            String dst_subaddrx = l.getElement(4) != 1 ? "" : (d[4] != 0 ? "/" + Integer.toHexString(d[4]) : "");
            return "LocoBuffer => LocoIO@" + (l.getElement(3) == 0 ? "broadcast" : String.valueOf(Integer.toHexString(l.getElement(3))) + dst_subaddrx) + " " + (d[0] == 2 ? "Query SV" + d[1] : "Write SV" + d[1] + "=0x" + Integer.toHexString(d[3])) + (d[2] != 0 ? " Firmware rev " + LocoNetMessageInterpret.dotme(d[2]) : "") + ".\n";
        }
        return "";
    }

    private static String interpretSV0Message(LocoNetMessage l) {
        String dst_dev;
        String src_dev;
        int dst_h = l.getElement(4);
        int pxct1 = l.getElement(5);
        int pxct2 = l.getElement(10);
        if (dst_h != 1 || (pxct1 & 0xF0) != 0 || (pxct2 & 0xF0) != 0) {
            return "";
        }
        int dst_l = l.getElement(3);
        int[] d = l.getPeerXfrData();
        int src = l.getElement(2);
        String src_subaddrx = d[4] != 0 ? "/" + Integer.toHexString(d[4]) : "";
        String dst_subaddrx = d[4] != 0 ? "/" + Integer.toHexString(d[4]) : "";
        String string = src_dev = src == 80 ? "Locobuffer" : "LocoIO@0x" + Integer.toHexString(src) + src_subaddrx;
        String string2 = dst_l == 80 ? "LocoBuffer " : (dst_dev = dst_l == 0 ? "broadcast" : "LocoIO@0x" + Integer.toHexString(dst_l) + dst_subaddrx);
        String operation = src == 80 ? (d[0] == 2 ? "Query" : "Write") : (d[0] == 2 ? "Report" : "Write");
        return String.valueOf(src_dev) + "=> " + dst_dev + " " + operation + " SV" + d[1] + (src == 80 ? (d[0] != 2 ? "=0x" + Integer.toHexString(d[3]) : "") : " = " + (d[0] == 2 ? (d[2] != 0 ? (d[5] < 10 ? "" + d[5] : String.valueOf(d[5]) + " (0x" + Integer.toHexString(d[5]) + ")") : (d[7] < 10 ? "" + d[7] : String.valueOf(d[7]) + " (0x" + Integer.toHexString(d[7]) + ")")) : (d[7] < 10 ? "" + d[7] : String.valueOf(d[7]) + " (0x" + Integer.toHexString(d[7]) + ")"))) + (d[2] != 0 ? " Firmware rev " + LocoNetMessageInterpret.dotme(d[2]) : "") + ".\n";
    }

    private static String interpretSV2Message(LocoNetMessage l) {
        String svReply = "";
        LnSv2MessageContents svmc = null;
        try {
            svmc = new LnSv2MessageContents(l);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (svmc != null) {
            try {
                svReply = svmc.toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return svReply;
    }

    private static String interpretLncvMessage(LocoNetMessage l) {
        String lncvReply = "";
        LncvMessageContents cvmc = null;
        try {
            cvmc = new LncvMessageContents(l);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (cvmc != null) {
            try {
                lncvReply = cvmc.toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return lncvReply;
    }

    private static String interpretOpcPeerXfer10(LocoNetMessage l) {
        String stat;
        int tcntrl = l.getElement(2);
        switch (tcntrl) {
            case 64: {
                stat = Bundle.getMessage("LN_MSG_THROTTLE_STATUS_HELPER_OK");
                break;
            }
            case 127: {
                stat = Bundle.getMessage("LN_MSG_THROTTLE_STATUS_HELPER_NO_KEYPRESS");
                break;
            }
            case 67: {
                stat = Bundle.getMessage("LN_MSG_THROTTLE_STATUS_HELPER_PLUS_KEY");
                break;
            }
            case 66: {
                stat = Bundle.getMessage("LN_MSG_THROTTLE_STATUS_HELPER_MINUS_KEY");
                break;
            }
            case 65: {
                stat = Bundle.getMessage("LN_MSG_THROTTLE_STATUS_HELPER_RUNSTOP_KEY");
                break;
            }
            case 78: {
                stat = Bundle.getMessage("LN_MSG_THROTTLE_STATUS_HELPER_RESP_SEM_DISP_CMD");
                break;
            }
            default: {
                stat = Bundle.getMessage("LN_MSG_THROTTLE_STATUS_HELPER_UNKONWN");
            }
        }
        return Bundle.getMessage("LN_MSG_THROTTLE_STATUS", StringUtil.twoHexFromInt(tcntrl), stat, LocoNetMessageInterpret.idString(l.getElement(3), l.getElement(4)), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(l.getElement(7))), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(l.getElement(8))));
    }

    private static String interpretOpcPeerXfer9(LocoNetMessage l, String reporterPrefix) {
        switch (l.getElement(2)) {
            case 64: {
                String locoAddr = LocoNetMessageInterpret.convertToMixed(l.getElement(4), l.getElement(3));
                return Bundle.getMessage("LN_MSG_TRANSP_FIND_QUERY", locoAddr);
            }
            case 0: {
                String zone;
                int section = ((l.getElement(5) & 0x1F) << 3) + ((l.getElement(6) & 0x70) >> 4) + 1;
                String locoAddr = LocoNetMessageInterpret.convertToMixed(l.getElement(4), l.getElement(3));
                switch (l.getElement(6) & 0xF) {
                    case 0: {
                        zone = "A";
                        break;
                    }
                    case 2: {
                        zone = "B";
                        break;
                    }
                    case 4: {
                        zone = "C";
                        break;
                    }
                    case 6: {
                        zone = "D";
                        break;
                    }
                    case 8: {
                        zone = "E";
                        break;
                    }
                    case 10: {
                        zone = "F";
                        break;
                    }
                    case 12: {
                        zone = "G";
                        break;
                    }
                    case 14: {
                        zone = "H";
                        break;
                    }
                    default: {
                        zone = Bundle.getMessage("LN_MSG_TRANSP_HELPER_UNKNOWN_ZONE", l.getElement(6) & 0xF);
                    }
                }
                String reporterSystemName = String.valueOf(reporterPrefix) + ((l.getElement(5) & 0x1F) * 128 + l.getElement(6) + 1);
                Reporter reporter = InstanceManager.getDefault(ReporterManager.class).getReporter(reporterSystemName);
                String uname = "";
                if (reporter != null) {
                    uname = reporter.getUserName();
                }
                if (uname != null && !uname.isEmpty()) {
                    return Bundle.getMessage("LN_MSG_TRANSP_REPORT_KNOWN_REPORTER_USERNAME", locoAddr, reporterSystemName, uname, section, zone);
                }
                return Bundle.getMessage("LN_MSG_TRANSP_REPORT_KNOWN_REPORTER_UNKNOWN_USERNAME", locoAddr, reporterSystemName, section, zone);
            }
        }
        return "";
    }

    private static String interpretOpcPeerXfer7(LocoNetMessage l) {
        if (l.getElement(2) == 1 && l.getElement(3) == 73 && l.getElement(4) == 66) {
            switch (l.getElement(5)) {
                case 64: {
                    return Bundle.getMessage("LN_MSG_UHLENBROCK_STOP_PROGRAMMING_TRACK");
                }
                case 65: {
                    return Bundle.getMessage("LN_MSG_UHLENBROCK_START_PROGRAMMING_TRACK");
                }
            }
        }
        return "";
    }

    private static String interpretOpcPeerXfer(LocoNetMessage l, String reporterPrefix) {
        String result = "";
        switch (l.getElement(1)) {
            case 16: {
                result = LocoNetMessageInterpret.interpretOpcPeerXfer16(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 15: {
                result = LocoNetMessageInterpret.interpretOpcPeerXfer15(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 10: {
                result = LocoNetMessageInterpret.interpretOpcPeerXfer10(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 20: {
                result = LocoNetMessageInterpret.interpretOpcPeerXfer20(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 9: {
                result = LocoNetMessageInterpret.interpretOpcPeerXfer9(l, reporterPrefix);
                if (result.length() <= 0) break;
                return result;
            }
            case 7: {
                result = LocoNetMessageInterpret.interpretOpcPeerXfer7(l);
                if (result.length() <= 0) break;
                return result;
            }
        }
        return "";
    }

    private static String interpretLongAck(LocoNetMessage l) {
        int opcode = l.getElement(1);
        int ack1 = l.getElement(2);
        switch (opcode | 0x80) {
            case 191: {
                return Bundle.getMessage("LN_MSG_LONG_ACK_LOCO_ADR");
            }
            case 185: {
                return Bundle.getMessage("LN_MSG_LONG_ACK_LINK_SLOTS");
            }
            case 189: {
                switch (ack1) {
                    case 0: {
                        return Bundle.getMessage("LN_MSG_LONG_ACK_SW_ACK_FULL");
                    }
                    case 127: {
                        return Bundle.getMessage("LN_MSG_LONG_ACK_SW_ACK_ACCEPT");
                    }
                }
                return String.valueOf(Bundle.getMessage("LN_MSG_LONG_ACK_SW_ACK_UNKNOWN", Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(ack1)))) + Bundle.getMessage("LN_MONITOR_MESSAGE_RAW_HEX_INFO", l.toString());
            }
            case 176: {
                return Bundle.getMessage("LN_MSG_LONG_ACK_SW_REQ_FAIL");
            }
            case 239: {
                switch (ack1) {
                    case 0: {
                        return Bundle.getMessage("LN_MSG_LONG_ACK_WR_SL_FAIL");
                    }
                    case 1: {
                        return Bundle.getMessage("LN_MSG_LONG_ACK_WR_SL_OK");
                    }
                    case 35: 
                    case 43: 
                    case 107: {
                        return Bundle.getMessage("LN_MSG_LONG_ACK_WR_SL_PROG_DCS51_OK");
                    }
                    case 64: {
                        return Bundle.getMessage("LN_MSG_LONG_ACK_WR_SL_BLIND");
                    }
                    case 127: {
                        return Bundle.getMessage("LN_MSG_LONG_ACK_WR_SL_NOT_IMPL");
                    }
                }
                return String.valueOf(Bundle.getMessage("LN_MSG_LONG_ACK_WR_SL_UNKNOWN", Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(ack1)))) + Bundle.getMessage("LN_MONITOR_MESSAGE_RAW_HEX_INFO", l.toString());
            }
            case 188: {
                return Bundle.getMessage("LN_MSG_LONG_ACK_SW_STATE", Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(ack1)), Bundle.getMessage((ack1 & 0x20) != 0 ? "LN_MSG_SWITCH_STATE_CLOSED" : "LN_MSG_SWITCH_STATE_THROWN"));
            }
            case 186: {
                switch (ack1) {
                    case 0: {
                        return Bundle.getMessage("LN_MSG_LONG_ACK_MOVE_SL_REJECT");
                    }
                    case 127: {
                        return Bundle.getMessage("LN_MSG_LONG_ACK_MOVE_SL_ACCEPT");
                    }
                }
                return String.valueOf(Bundle.getMessage("LN_MSG_LONG_ACK_MOVE_SL_UNKNOWN", Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(ack1)))) + Bundle.getMessage("LN_MONITOR_MESSAGE_RAW_HEX_INFO", l.toString());
            }
            case 237: {
                if (ack1 == 0) {
                    return Bundle.getMessage("LN_MSG_LONG_ACK_OPC_IMM_REJECT");
                }
                if (ack1 == 127) {
                    return Bundle.getMessage("LN_MSG_LONG_ACK_OPC_IMM_ACCEPT");
                }
                if (ack1 == 1) {
                    return Bundle.getMessage("LN_MSG_LONG_ACK_OPC_IMM_UHL_PROG");
                }
                if (ack1 == 2) {
                    return Bundle.getMessage("LN_MSG_LONG_ACK_OPC_IMM_LNCV_READONLY");
                }
                if (ack1 == 3) {
                    return Bundle.getMessage("LN_MSG_LONG_ACK_OPC_IMM_LNCV_ILLEGALVAL");
                }
                return String.valueOf(Bundle.getMessage("LN_MSG_LONG_ACK_OPC_IMM_UNKNOWN", Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(ack1)))) + Bundle.getMessage("LN_MONITOR_MESSAGE_RAW_HEX_INFO", l.toString());
            }
            case 238: {
                return Bundle.getMessage("LN_MSG_LONG_ACK_OPC_IMM_LIM_MASTER", ack1, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(ack1)));
            }
            case 128: 
            case 208: {
                int responseValue = l.getElement(2);
                if (responseValue == 127) {
                    return Bundle.getMessage("LN_MSG_LONG_ACK_SPEC_CASE1_2_ACCEPTED");
                }
                return Bundle.getMessage("LN_MSG_LONG_ACK_SPEC_CASE1_2_REPORT", (responseValue & 0x20) == 32 ? 1 : 0, (responseValue & 0x20) == 32 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_OPSW_HELPER_CLOSED") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_OPSW_HELPER_THROWN"));
            }
            case 230: {
                if (l.getElement(2) != 0) break;
                return Bundle.getMessage("LN_MSG_LONG_ACK_SLOT_NOT_SUPPORTED", Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(opcode)));
            }
        }
        return "";
    }

    private static String interpretPm4xPowerEvent(LocoNetMessage l) {
        int pCMD = l.getElement(3) & 0xF0;
        if (pCMD == 48 || pCMD == 16) {
            String sect4State;
            String sect4Mode;
            String sect3State;
            String sect3Mode;
            String sect2State;
            String sect2Mode;
            String sect1State;
            String sect1Mode;
            int cm1 = l.getElement(3);
            int cm2 = l.getElement(4);
            if ((cm1 & 1) != 0) {
                sect1Mode = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_AUTOREV");
                sect1State = (cm2 & 1) != 0 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_REV") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_NORM");
            } else {
                sect1Mode = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_PROTECT");
                String string = sect1State = (cm2 & 1) != 0 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_SHORT") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_NONSHORT");
            }
            if ((cm1 & 2) != 0) {
                sect2Mode = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_AUTOREV");
                sect2State = (cm2 & 2) != 0 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_REV") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_NORM");
            } else {
                sect2Mode = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_PROTECT");
                String string = sect2State = (cm2 & 2) != 0 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_SHORT") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_NONSHORT");
            }
            if ((cm1 & 4) != 0) {
                sect3Mode = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_AUTOREV");
                sect3State = (cm2 & 4) != 0 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_REV") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_NORM");
            } else {
                sect3Mode = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_PROTECT");
                String string = sect3State = (cm2 & 4) != 0 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_SHORT") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_NONSHORT");
            }
            if ((cm1 & 8) != 0) {
                sect4Mode = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_AUTOREV");
                sect4State = (cm2 & 8) != 0 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_REV") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_NORM");
            } else {
                sect4Mode = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_PROTECT");
                sect4State = (cm2 & 8) != 0 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_SHORT") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X_HELPER_MODE_NONSHORT");
            }
            return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_PM4X", l.getElement(2) + 1 + ((l.getElement(1) & 1) << 7), sect1Mode, sect1State, sect2Mode, sect2State, sect3Mode, sect3State, sect4Mode, sect4State);
        }
        if (pCMD == 32) {
            int cm1 = l.getElement(3);
            int cm2 = l.getElement(4);
            ArrayList<Integer> sectsShorted = new ArrayList<Integer>();
            ArrayList<Integer> sectsUnshorted = new ArrayList<Integer>();
            if ((cm2 & 1) != 0) {
                sectsShorted.add(1);
            } else {
                sectsUnshorted.add(1);
            }
            if ((cm2 & 2) != 0) {
                sectsShorted.add(2);
            } else {
                sectsUnshorted.add(2);
            }
            if ((cm2 & 4) != 0) {
                sectsShorted.add(3);
            } else {
                sectsUnshorted.add(3);
            }
            if ((cm2 & 8) != 0) {
                sectsShorted.add(4);
            } else {
                sectsUnshorted.add(4);
            }
            if ((cm1 & 1) != 0) {
                sectsShorted.add(5);
            } else {
                sectsUnshorted.add(5);
            }
            if ((cm1 & 2) != 0) {
                sectsShorted.add(6);
            } else {
                sectsUnshorted.add(6);
            }
            if ((cm1 & 4) != 0) {
                sectsShorted.add(7);
            } else {
                sectsUnshorted.add(7);
            }
            if ((cm1 & 8) != 0) {
                sectsShorted.add(8);
            } else {
                sectsUnshorted.add(8);
            }
            return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_BXP88", l.getElement(2) + 1 + ((l.getElement(1) & 1) << 7), StringUtils.join(sectsShorted, (char)','), StringUtils.join(sectsUnshorted, (char)','));
        }
        if (pCMD == 80 || pCMD == 64) {
            int cm1 = l.getElement(3);
            String RevState = "";
            String BreakState = "";
            if ((cm1 & 0x10) != 0) {
                RevState = (cm1 & 8) != 0 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_BXPA1_HELPER_MODE_REV") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_BXPA1_HELPER_MODE_NORM");
            } else {
                BreakState = (cm1 & 8) != 0 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_BXPA1_HELPER_MODE_SHORT") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_BXPA1_HELPER_MODE_NONSHORT");
            }
            int bxpa1_Id = (l.getElement(2) << 3) + (l.getElement(3) & 7) + 1;
            return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_POWER_BXPA1", bxpa1_Id, bxpa1_Id + 4, RevState, BreakState);
        }
        return "";
    }

    private static String interpretOpSws(LocoNetMessage l) {
        int pCMD = l.getElement(3) & 0xF0;
        if (pCMD == 112) {
            String device;
            int deviceType = l.getElement(3) & 7;
            switch (deviceType) {
                case 0: {
                    device = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_DEV_RPT_HELPER_PM4X");
                    break;
                }
                case 1: {
                    device = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_DEV_RPT_HELPER_BDL16X");
                    break;
                }
                case 2: {
                    device = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_DEV_RPT_HELPER_SE8C");
                    break;
                }
                case 3: {
                    device = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_DEV_RPT_HELPER_DS64");
                    break;
                }
                default: {
                    return "";
                }
            }
            int val = l.getElement(4) & 1;
            int opsw = (l.getElement(4) & 0x7E) / 2 + 1;
            int bdaddr = l.getElement(2) + 1;
            if ((l.getElement(1) & 1) != 0) {
                bdaddr += 128;
            }
            if (deviceType == 0 && bdaddr == 1 && l.getElement(4) == 0) {
                return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_OPSW_ACCESS_QUERY_ALL");
            }
            if ((l.getElement(1) & 0x10) != 0) {
                String valType = val == 1 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_OPSW_HELPER_CLOSED") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_OPSW_HELPER_THROWN");
                return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_OPSW_WRITE_ACCESS", device, bdaddr, opsw, val, valType);
            }
            return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_OPSW_QUERY_ACCESS", device, bdaddr, opsw);
        }
        return "";
    }

    private static String interpretDeviceType(LocoNetMessage l) {
        int pCMD = l.getElement(3) & 0xF0;
        if (pCMD == 0) {
            int deviceType = l.getElement(3) & 7;
            String device = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_DEV_RPT_HELPER_UNKNOWN");
            switch (deviceType) {
                case 0: {
                    device = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_DEV_RPT_HELPER_PM4X");
                    break;
                }
                case 1: {
                    device = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_DEV_RPT_HELPER_BDL16X");
                    break;
                }
                case 2: {
                    device = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_DEV_RPT_HELPER_SE8C");
                    break;
                }
                case 3: {
                    device = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_DEV_RPT_HELPER_DS64");
                    break;
                }
                default: {
                    log.warn("Unhandled device type: {}", (Object)deviceType);
                }
            }
            int bdaddr = l.getElement(2) + 1;
            if ((l.getElement(1) & 1) != 0) {
                bdaddr += 128;
            }
            String versionNumber = Integer.toString(l.getElement(4));
            if (l.getElement(4) == 0) {
                versionNumber = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_DEV_RPT_HELPER_VER_UNKNOWN");
            }
            return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_OPSW_DEV_TYPE_RPT", device, bdaddr, versionNumber);
        }
        return "";
    }

    private static String interpretOpcMultiSense(LocoNetMessage l, String reporterPrefix) {
        int type = l.getElement(1) & 0x60;
        switch (type) {
            case 96: {
                String result = LocoNetMessageInterpret.interpretPm4xPowerEvent(l);
                if (result.length() > 0) {
                    return result;
                }
                result = LocoNetMessageInterpret.interpretOpSws(l);
                if (result.length() > 0) {
                    return result;
                }
                result = LocoNetMessageInterpret.interpretDeviceType(l);
                if (result.length() <= 0) break;
                return result;
            }
            case 0: 
            case 32: {
                String result = LocoNetMessageInterpret.interpretOpcMultiSenseTranspPresence(l, reporterPrefix);
                if (result.length() <= 0) break;
                return result;
            }
            case 64: {
                String result = LocoNetMessageInterpret.interpretOpcMultiSenseRailcomAD(l, reporterPrefix);
                if (result.length() <= 0) break;
                return result;
            }
        }
        return "";
    }

    private static String interpretOpcMultiSenseTranspPresence(LocoNetMessage l, String reporterPrefix) {
        String transpActivity;
        String uname;
        String zone;
        int bxp88Zone = 1 + (l.getElement(2) & 7);
        switch (l.getElement(2) & 0xF) {
            case 0: {
                zone = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_ZONEA");
                break;
            }
            case 2: {
                zone = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_ZONEB");
                break;
            }
            case 4: {
                zone = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_ZONEC");
                break;
            }
            case 6: {
                zone = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_ZONED");
                break;
            }
            case 8: {
                zone = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_ZONEE");
                break;
            }
            case 10: {
                zone = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_ZONEF");
                break;
            }
            case 12: {
                zone = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_ZONEG");
                break;
            }
            case 14: {
                zone = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_ZONEH");
                break;
            }
            default: {
                zone = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_ZONE_UNKNOWN", l.getElement(2) & 0xF);
            }
        }
        int type = l.getElement(1) & 0x60;
        String reporterSystemName = String.valueOf(reporterPrefix) + ((l.getElement(1) & 0x1F) * 128 + l.getElement(2) + 1);
        Reporter reporter = InstanceManager.getDefault(ReporterManager.class).getReporter(reporterSystemName);
        String reporterUserName = "";
        if (reporter != null && (uname = reporter.getUserName()) != null && !uname.isEmpty()) {
            reporterUserName = uname;
        }
        int bxpa1Number = 1 + l.getElement(2) + (l.getElement(1) & 0x1F) * 128;
        int bxp88Number = 1 + l.getElement(2) / 8 + (l.getElement(1) & 0x1F) * 16;
        int section = 1 + l.getElement(2) / 16 + (l.getElement(1) & 0x1F) * 8;
        String locoAddr = LocoNetMessageInterpret.convertToMixed(l.getElement(4), l.getElement(3));
        String string = transpActivity = type == 32 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_HELPER_IS_PRESENT") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_HELPER_IS_ABSENT");
        if ((l.getElement(2) & 1) == 0) {
            return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_REPORT_WITH_BXP88", locoAddr, transpActivity, reporterSystemName, reporterUserName, section, zone, bxp88Number, bxp88Zone, bxpa1Number);
        }
        return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_REPORT_NOT_BDL16X", locoAddr, transpActivity, reporterSystemName, reporterUserName, bxp88Number, bxp88Zone, bxpa1Number);
    }

    private static String convertRailComAD(int indexValue, int dynamicValue) {
        String indexString = "";
        switch (indexValue) {
            case 0: {
                indexString = Bundle.getMessage("LN_MSG_RAILCOM_HELPER_INDEX_VALUE_0");
                break;
            }
            case 7: {
                indexString = Bundle.getMessage("LN_MSG_RAILCOM_HELPER_INDEX_VALUE_7");
                break;
            }
            default: {
                indexString = Bundle.getMessage("LN_MSG_RAILCOM_HELPER_INDEX_VALUE_UNKNOWN");
            }
        }
        return Bundle.getMessage("LN_MSG_RAILCOM_REPORT", indexValue, indexString, dynamicValue);
    }

    private static String interpretOpcMultiSenseRailcomAD(LocoNetMessage l, String reporterPrefix) {
        String locoAddr = LocoNetMessageInterpret.convertToMixed(l.getElement(4), l.getElement(3));
        int indexValue = (l.getElement(1) & 0x1E) / 2;
        int dynamicValue = l.getElement(2) + (l.getElement(1) & 1) * 128;
        String railcomAdString = LocoNetMessageInterpret.convertRailComAD(indexValue, dynamicValue);
        return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_RAILCOM_REPORT", locoAddr, railcomAdString);
    }

    private static String interpretOpcMultiSenseLong(LocoNetMessage l, String reporterPrefix) {
        if (l.getElement(1) == 9) {
            String uname;
            int type = l.getElement(2) & 0x60;
            if (type == 96) {
                return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_LONG_UNKNOWN_MESSAGE");
            }
            String reporterSystemName = String.valueOf(reporterPrefix) + ((l.getElement(2) & 0x1F) * 128 + l.getElement(3) + 1);
            Reporter reporter = InstanceManager.getDefault(ReporterManager.class).getReporter(reporterSystemName);
            String reporterUserName = "";
            if (reporter != null && (uname = reporter.getUserName()) != null && !uname.isEmpty()) {
                reporterUserName = uname;
            }
            String locoAddr = LocoNetMessageInterpret.convertToMixed(l.getElement(5), l.getElement(4));
            String transpActivity = "";
            String direction = (l.getElement(6) & 0x40) == 0 ? Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_LONG_LOCO_DIRECTION_HELPER_EAST") : Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_LONG_LOCO_DIRECTION_HELPER_WEST");
            switch (type) {
                case 64: {
                    int indexValue = (l.getElement(6) & 0x3E) / 2;
                    int dynamicValue = l.getElement(7) + (l.getElement(6) & 1) * 128;
                    transpActivity = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_HELPER_IS_PRESENT");
                    String railcomAdString = LocoNetMessageInterpret.convertRailComAD(indexValue, dynamicValue);
                    String multiSenseLongString = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_LONG_TRANSP_REPORT", locoAddr, direction, transpActivity, reporterSystemName, reporterUserName);
                    return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_LONG_TRANSP_RAILCOM_REPORT", multiSenseLongString, railcomAdString);
                }
                case 32: {
                    if ((l.getElement(6) & 0x3F) != 0 || l.getElement(7) != 0) {
                        return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_LONG_UNKNOWN_MESSAGE");
                    }
                    transpActivity = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_HELPER_IS_PRESENT");
                    return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_LONG_TRANSP_REPORT", locoAddr, direction, transpActivity, reporterSystemName, reporterUserName);
                }
                case 0: {
                    if ((l.getElement(6) & 0x3F) != 0 || l.getElement(7) != 0) {
                        return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_LONG_UNKNOWN_MESSAGE");
                    }
                    transpActivity = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_TRANSP_HELPER_IS_ABSENT");
                    return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_LONG_TRANSP_REPORT", locoAddr, direction, transpActivity, reporterSystemName, reporterUserName);
                }
            }
            return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_LONG_UNKNOWN_MESSAGE");
        }
        return Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_LONG_UNKNOWN_MESSAGE");
    }

    private static String interpretOpcWrSlDataOpcSlRdData(LocoNetMessage l) {
        int slot = l.getElement(2);
        int command = l.getOpCode();
        int id1 = l.getElement(11);
        int id2 = l.getElement(12);
        String mode = command == 239 ? Bundle.getMessage("LN_MSG_SLOT_HELPER_ACCESS_TYPE_REQUEST") : Bundle.getMessage("LN_MSG_SLOT_HELPER_ACCESS_TYPE_RESPONSE");
        switch (slot) {
            case 123: {
                String result = LocoNetMessageInterpret.interpretFastClockSlot(l, mode, id1, id2);
                if (result.length() <= 0) break;
                return result;
            }
            case 124: {
                String result = LocoNetMessageInterpret.interpretProgSlot(l, mode, id1, id2, command);
                if (result.length() <= 0) break;
                return result;
            }
            case 121: 
            case 122: 
            case 125: {
                return "";
            }
            case 126: {
                String result = LocoNetMessageInterpret.interpretCmdStnExtCfgSlotRdWr(l, command);
                if (result.length() <= 0) break;
                return result;
            }
            case 127: {
                String result = LocoNetMessageInterpret.interpretCmdStnCfgSlotRdWr(l, command);
                if (result.length() <= 0) break;
                return result;
            }
            default: {
                String result = LocoNetMessageInterpret.interpretStandardSlotRdWr(l, id1, id2, command, slot);
                if (result.length() <= 0) break;
                return result;
            }
        }
        return "";
    }

    private static String interpretOpcInputRep(LocoNetMessage l, String sensorPrefix) {
        String otherBoardsInputs;
        String otherBoardsNames;
        String uname;
        int in1 = l.getElement(1);
        int in2 = l.getElement(2);
        int contactNum = (LocoNetMessageInterpret.SENSOR_ADR(in1, in2) - 1) * 2 + ((in2 & 0x20) != 0 ? 2 : 1);
        String sensorSystemName = String.valueOf(sensorPrefix) + contactNum;
        String sensorUserName = "";
        Sensor sensor = InstanceManager.getDefault(SensorManager.class).getSensor(sensorSystemName);
        sensorUserName = "";
        if (sensor != null && (uname = sensor.getUserName()) != null && !uname.isEmpty()) {
            sensorUserName = uname;
        }
        int sensorid = (LocoNetMessageInterpret.SENSOR_ADR(in1, in2) - 1) * 2 + ((in2 & 0x20) != 0 ? 2 : 1);
        int bdlid = (sensorid - 1) / 16 + 1;
        int bdlin = (sensorid - 1) % 16 + 1;
        String bdl = Bundle.getMessage("LN_MSG_OPC_INPUT_REP_BDL_INFO", bdlid, bdlin);
        int boardid = (sensorid - 1) / 8 + 1;
        int boardindex = (sensorid - 1) % 8;
        if (sensorid < 289) {
            otherBoardsNames = Bundle.getMessage("LN_MSG_OPC_INPUT_REP_ALL_EQUIV_BOARDS", boardid);
            otherBoardsInputs = Bundle.getMessage("LN_MSG_OPC_INPUT_REPORT_INPUT_NAMES_ALL_EQUIV_BOARDS", ds54sensors[boardindex], ds64sensors[boardindex], se8csensors[boardindex]);
        } else {
            otherBoardsNames = Bundle.getMessage("LN_MSG_OPC_INPUT_REP_NO_SE8C", boardid);
            otherBoardsInputs = Bundle.getMessage("LN_MSG_OPC_INPUT_REPORT_INPUT_NAMES_NO_SE8C", ds54sensors[boardindex], ds64sensors[boardindex]);
        }
        return Bundle.getMessage("LN_MSG_OPC_INPUT_REP", sensorSystemName, sensorUserName, Bundle.getMessage((in2 & 0x10) != 0 ? "LN_MSG_SENSOR_STATE_HIGH" : "LN_MSG_SENSOR_STATE_LOW"), bdl, otherBoardsNames, otherBoardsInputs);
    }

    private static String interpretOpcSwRep(LocoNetMessage l, String turnoutPrefix) {
        int sn1 = l.getElement(1);
        int sn2 = l.getElement(2);
        String turnoutUserName = "";
        String turnoutSystemName = String.valueOf(turnoutPrefix) + LocoNetMessageInterpret.SENSOR_ADR(sn1, sn2);
        Turnout turnout = InstanceManager.getDefault(TurnoutManager.class).getTurnout(turnoutSystemName);
        String uname = "";
        if (turnout != null) {
            uname = turnout.getUserName();
            turnoutUserName = uname != null && !uname.isEmpty() ? uname : "";
        }
        if ((sn2 & 0x40) != 0) {
            return Bundle.getMessage("LN_MSG_OPC_SW_REP_INPUTS_STATE", turnoutSystemName, turnoutUserName, Bundle.getMessage((sn2 & 0x20) != 0 ? "LN_MSG_SENSOR_SW_INPUT_TYPE_HI" : "LN_MSG_SENSOR_SW_INPUT_TYPE_LO"), Bundle.getMessage((sn2 & 0x10) != 0 ? "LN_MSG_SENSOR_SW_INPUT_STATE_HI" : "LN_MSG_SENSOR_SW_INPUT_STATE_LO"));
        }
        return Bundle.getMessage("LN_MSG_OPC_SW_REP_OUTPUT_STATE", turnoutSystemName, turnoutUserName, Bundle.getMessage((sn2 & 0x20) != 0 ? "LN_MSG_SENSOR_SW_OUTPUT_STATE_ON" : "LN_MSG_SENSOR_SW_OUTPUT_STATE_OFF"), Bundle.getMessage((sn2 & 0x10) != 0 ? "LN_MSG_SENSOR_SW_OUTPUT_STATE_ON" : "LN_MSG_SENSOR_SW_OUTPUT_STATE_OFF"));
    }

    private static String interpretOpcSwAck(LocoNetMessage l, String turnoutPrefix) {
        int sw2 = l.getElement(2);
        if ((sw2 & 0x40) == 64) {
            return "";
        }
        String turnoutUserName = "";
        String turnoutSystemName = String.valueOf(turnoutPrefix) + LocoNetMessageInterpret.SENSOR_ADR(l.getElement(1), l.getElement(2));
        Turnout turnout = InstanceManager.getDefault(TurnoutManager.class).getTurnout(turnoutSystemName);
        String uname = "";
        if (turnout != null) {
            uname = turnout.getUserName();
            turnoutUserName = uname != null && !uname.isEmpty() ? uname : "";
        }
        String pointsDirection = (sw2 & 0x20) != 0 ? Bundle.getMessage("LN_MSG_SW_POS_CLOSED") : Bundle.getMessage("LN_MSG_SW_POS_THROWN");
        String outputState = (sw2 & 0x10) != 0 ? Bundle.getMessage("LN_MSG_SENSOR_SW_OUTPUT_STATE_ON") : Bundle.getMessage("LN_MSG_SENSOR_SW_OUTPUT_STATE_OFF");
        return Bundle.getMessage("LN_MSG_REQ_SWITCH", turnoutSystemName, turnoutUserName, pointsDirection, outputState);
    }

    private static String interpretOpcSwState(LocoNetMessage l, String turnoutPrefix) {
        if ((l.getElement(2) & 0x40) != 0) {
            return "";
        }
        String turnoutUserName = "";
        String turnoutSystemName = String.valueOf(turnoutPrefix) + LocoNetMessageInterpret.SENSOR_ADR(l.getElement(1), l.getElement(2));
        Turnout turnout = InstanceManager.getDefault(TurnoutManager.class).getTurnout(turnoutSystemName);
        String uname = "";
        if (turnout != null) {
            uname = turnout.getUserName();
            turnoutUserName = uname != null && !uname.isEmpty() ? uname : "";
        }
        return Bundle.getMessage("LN_MSG_SW_STATE", turnoutSystemName, turnoutUserName);
    }

    private static String interpretOpcRqSlData(LocoNetMessage l) {
        int slot = l.getElement(1) + 128 * (l.getElement(2) & 7);
        boolean expSlotRequ = (l.getElement(2) & 0x40) == 64;
        switch (slot) {
            case 123: {
                return Bundle.getMessage("LN_MSG_SLOT_REQ_SLOT_FC_SLOT");
            }
            case 127: {
                return Bundle.getMessage("LN_MSG_SLOT_REQ_SLOT_CFG_SLOT");
            }
            case 126: {
                return Bundle.getMessage("LN_MSG_SLOT_REQ_SLOT_EXT_CFG_SLOT");
            }
            case 124: {
                return Bundle.getMessage("LN_MSG_SLOT_REQ_SLOT_PRG_SLOT");
            }
            case 121: 
            case 122: 
            case 125: {
                break;
            }
            default: {
                if (expSlotRequ) {
                    return Bundle.getMessage("LN_MSG_SLOT_REQ_SLOT_LOCO_EXP_SLOT", slot);
                }
                return Bundle.getMessage("LN_MSG_SLOT_REQ_SLOT_LOCO_SLOT", slot);
            }
        }
        return "";
    }

    private static String interpretOpcMoveSlots(LocoNetMessage l) {
        int src = l.getElement(1);
        int dest = l.getElement(2);
        if (src >= 121 && src <= 127) {
            return "";
        }
        if (dest >= 121 && dest <= 127) {
            return "";
        }
        if (src == 0) {
            return Bundle.getMessage("LN_MSG_MOVE_SL_GET_DISP");
        }
        if (src == dest) {
            return Bundle.getMessage("LN_MSG_MOVE_SL_NULL_MOVE", src);
        }
        if (dest == 0) {
            return Bundle.getMessage("LN_MSG_MOVE_SL_DISPATCH_PUT", src);
        }
        return Bundle.getMessage("LN_MSG_MOVE_SL_MOVE", src, dest);
    }

    private static String interpretOpcConsistFunc(LocoNetMessage l) {
        int slot = l.getElement(1);
        int dirf = l.getElement(2);
        if ((dirf & 0x40) == 64) {
            return "";
        }
        return Bundle.getMessage("LN_MSG_CONSIST_FUNC", slot, LocoNetMessageInterpret.interpretDIRF(dirf));
    }

    private static String interpretOpcLocoSnd(LocoNetMessage l) {
        int slot = l.getElement(1);
        int snd = l.getElement(2);
        return Bundle.getMessage("LN_MSG_OPC_LOCO_SND", slot, Bundle.getMessage((snd & 1) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((snd & 2) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((snd & 4) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((snd & 8) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"));
    }

    protected static String interpretDIRF(int dirf) {
        if ((dirf & 0x40) == 64) {
            return "";
        }
        String[] dirf0_4 = LocoNetMessageInterpret.interpretF0_F4toStrings(dirf);
        return Bundle.getMessage("LN_MSG_HELPER_DIRF", Bundle.getMessage((dirf & 0x20) != 0 ? "LN_MSG_DIRECTION_REV" : "LN_MSG_DIRECTION_FWD"), dirf0_4[0], dirf0_4[1], dirf0_4[2], dirf0_4[3], dirf0_4[4]);
    }

    private static String interpretOpcLocoDirf(LocoNetMessage l) {
        int slot = l.getElement(1);
        int dirf = l.getElement(2);
        String dirFinfo = LocoNetMessageInterpret.interpretDIRF(dirf);
        if (dirFinfo.length() == 0) {
            return "";
        }
        return Bundle.getMessage("LN_MSG_OPC_LOCO_DIRF", slot, dirFinfo);
    }

    private static String interpretOpcLocoSpd(LocoNetMessage l) {
        int slot = l.getElement(1);
        int spd = l.getElement(2);
        if (spd == 1) {
            return Bundle.getMessage("LN_MSG_OPC_LOCO_SPD_ESTOP", slot);
        }
        return Bundle.getMessage("LN_MSG_OPC_LOCO_SPD_NORMAL", slot, spd);
    }

    private static String interpretOpcPanelQuery(LocoNetMessage l) {
        switch (l.getElement(1)) {
            case 0: {
                return Bundle.getMessage("LN_MSG_OPC_DF_TETHERLESS_QUERY");
            }
            case 64: {
                if (l.getElement(2) != 31) break;
                return Bundle.getMessage("LN_MSG_OPC_DF_SET_LOCONETID", l.getElement(3));
            }
        }
        return "";
    }

    private static String interpretOpcSwReq(LocoNetMessage l, String turnoutPrefix) {
        int sw1 = l.getElement(1);
        int sw2 = l.getElement(2);
        if ((sw2 & 0x40) == 64) {
            return "";
        }
        if (!((sw2 & 0xCF) == 15 && (sw1 & 0xFC) == 120 || (sw2 & 0xCF) == 7 && (sw1 & 0xFC) == 120)) {
            String outputState;
            String turnoutUserName = "";
            String turnoutSystemName = String.valueOf(turnoutPrefix) + LocoNetMessageInterpret.SENSOR_ADR(l.getElement(1), l.getElement(2));
            Turnout turnout = InstanceManager.getDefault(TurnoutManager.class).getTurnout(turnoutSystemName);
            String uname = "";
            if (turnout != null) {
                uname = turnout.getUserName();
                turnoutUserName = uname != null && !uname.isEmpty() ? uname : "";
            }
            String pointsDirection = (sw2 & 0x20) != 0 ? Bundle.getMessage("LN_MSG_SW_POS_CLOSED") : Bundle.getMessage("LN_MSG_SW_POS_THROWN");
            String string = outputState = (sw2 & 0x10) != 0 ? Bundle.getMessage("LN_MSG_SW_OUTPUT_STATE_ON") : Bundle.getMessage("LN_MSG_SW_OUTPUT_STATE_OFF");
            if (turnoutUserName.length() == 0) {
                return Bundle.getMessage("LN_MSG_OPC_SW_REQ_NORMAL_WITHOUT_USERNAME", turnoutSystemName, pointsDirection, outputState);
            }
            return Bundle.getMessage("LN_MSG_OPC_SW_REQ_NORMAL_WITH_USERNAME", turnoutSystemName, turnoutUserName, pointsDirection, outputState);
        }
        int a = (sw2 & 0x20) >> 5;
        int c = (sw1 & 2) >> 1;
        int b = sw1 & 1;
        int topbits = 0;
        int midbits = (a << 2) + (c << 1) + b;
        int count = 0;
        StringBuilder addrListB = new StringBuilder();
        topbits = 0;
        while (topbits < 32) {
            int lval = (topbits << 6) + (midbits << 3) + 1;
            int hval = lval + 7;
            if (count % 8 != 0) {
                addrListB.append(", ");
            } else if (count == 0) {
                addrListB.append("\t");
            } else {
                addrListB.append(",\n\t");
            }
            addrListB.append("").append(lval);
            addrListB.append("-").append(hval);
            ++count;
            ++topbits;
        }
        String addrList = addrListB.toString();
        if ((sw2 & 0xCF) == 15 && (sw1 & 0xFC) == 120) {
            return Bundle.getMessage("LN_MSG_OPC_SW_REQ_INTERROGATE_TURNOUTS", a, c, b, addrList);
        }
        return Bundle.getMessage("LN_MSG_OPC_SW_REQ_INTERROGATE_SENSORS_TURNOUTS", a, c, b, addrList);
    }

    private static String interpretFastClockSlot(LocoNetMessage l, String mode, int id1, int id2) {
        int clk_rate = l.getElement(3);
        int mins_60 = l.getElement(6);
        int track_stat = l.getElement(7);
        int hours_24 = l.getElement(8);
        int days = l.getElement(9);
        int clk_cntrl = l.getElement(10);
        int minutes = (255 - mins_60 & 0x7F) % 60;
        int hours = (256 - hours_24 & 0x7F) % 24;
        hours = (24 - hours) % 24;
        minutes = (60 - minutes) % 60;
        return Bundle.getMessage("LN_MSG_SLOT_ACCESS_FAST_CLOCK", mode, (clk_cntrl & 0x20) != 0 ? "" : Bundle.getMessage("LN_MSG_SLOT_HELPER_FC_SYNC"), clk_rate != 0 ? Bundle.getMessage("LN_MSG_SLOT_HELPER_FC_RUNNING") : Bundle.getMessage("LN_MSG_SLOT_HELPER_FC_FROZEN"), clk_rate, days, LocoNetMessageInterpret.fcTimeToString(hours, minutes), LocoNetMessageInterpret.idString(id1, id2), LocoNetMessageInterpret.trackStatusByteToString(track_stat));
    }

    private static String interpretProgSlot(LocoNetMessage l, String mode, int id1, int id2, int command) {
        int pcmd = l.getElement(3);
        int pstat = l.getElement(4);
        int hopsa = l.getElement(5);
        int lopsa = l.getElement(6);
        int cvh = l.getElement(8);
        int cvl = l.getElement(9);
        int data7 = l.getElement(10);
        int cvData = (cvh & 2) << 6 | data7 & 0x7F;
        int cvNumber = ((cvh & 0x30) >> 3 | cvh & 1) * 128 + (cvl & 0x7F) + 1;
        if (command == 239) {
            switch (pcmd & 0x7C) {
                case 32: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_SRVC_TRK_PAGED_RD", Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_READ_REQ", cvNumber));
                }
                case 96: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_SRVC_TRK_PAGED_WR", Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_WRITE_REQ", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)));
                }
                case 40: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_SRVC_TRK_DIR_BYTE_RD", Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_READ_REQ", cvNumber));
                }
                case 104: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_SRVC_TRK_DIR_BYTE_WR", Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_WRITE_REQ", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)));
                }
                case 8: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_SRVC_TRK_DIR_BIT_RD", Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_READ_REQ", cvNumber), cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true));
                }
                case 72: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_SRVC_TRK_DIR_BIT_WR", Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_WRITE_REQ", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)));
                }
                case 16: 
                case 48: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_SRVC_TRK_REG_BYTE_RD", Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_READ_REQ", cvNumber));
                }
                case 80: 
                case 112: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_SRVC_TRK_REG_BYTE_WR", Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_WRITE_REQ", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)));
                }
                case 24: 
                case 56: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_SRVC_TRK_RD_RESERVED", Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_READ_REQ", cvNumber));
                }
                case 88: 
                case 120: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_SRVC_TRK_WR_RESERVED", Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_WRITE_REQ", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)));
                }
                case 36: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_OPS_BYTE_RD_NO_FEEDBACK", LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_READ_REQ", cvNumber));
                }
                case 100: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_OPS_BYTE_WR_NO_FEEDBACK", LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_WRITE_REQ", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)));
                }
                case 44: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_OPS_BYTE_RD_FEEDBACK", LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_READ_REQ", cvNumber));
                }
                case 108: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_OPS_BYTE_WR_FEEDBACK", LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_WRITE_REQ", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)));
                }
                case 4: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_OPS_BIT_RD_NO_FEEDBACK", LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_READ_REQ", cvNumber));
                }
                case 68: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_OPS_BIT_WR_NO_FEEDBACK", LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_WRITE_REQ", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)));
                }
                case 12: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_OPS_BIT_RD_FEEDBACK", LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_READ_REQ", cvNumber));
                }
                case 76: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_OPS_BIT_WR_FEEDBACK", LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_WRITE_REQ", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)));
                }
                case 0: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_UHLENBROCK_RD", Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_READ_REQ", cvNumber));
                }
                case 64: {
                    return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_UHLENBROCK_WR", Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_WRITE_REQ", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)));
                }
            }
            return Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_REQUEST_UNKNOWN", pcmd, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(pcmd)), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_WRITE_REQ", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)));
        }
        String responseMessage = "(ODD BEHAVIOR - Default value not overwritten - report to developers!";
        String hexMessage = "";
        if (pstat != 0) {
            if ((pstat & 8) != 0) {
                responseMessage = Bundle.getMessage("LN_MSG_SLOT_PROG_HELPER_RESPONSE_USER_ABORT");
            } else if ((pstat & 4) != 0) {
                responseMessage = Bundle.getMessage("LN_MSG_SLOT_PROG_HELPER_RESPONSE_NO_READ_COMPARE_ACK_DETECT");
            } else if ((pstat & 2) != 0) {
                responseMessage = Bundle.getMessage("LN_MSG_SLOT_PROG_HELPER_RESPONSE_NO_WRITE_ACK_DETECT");
            } else if ((pstat & 1) != 0) {
                responseMessage = Bundle.getMessage("LN_MSG_SLOT_PROG_HELPER_RESPONSE_NO_LOCO_ON_PROGRAMMING_TRACK");
            } else if ((pstat & 0xF0) != 0) {
                if ((pstat & 0xF0) == 16) {
                    responseMessage = Bundle.getMessage("LN_MSG_SLOT_PROG_HELPER_RESPONSE_SUCCESS_VIA_RX4_BDL16X");
                } else {
                    responseMessage = Bundle.getMessage("LN_MSG_SLOT_PROG_HELPER_RESPONSE_UNDECODED", Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(pstat)));
                    hexMessage = Bundle.getMessage("LN_MONITOR_MESSAGE_RAW_HEX_INFO", l.toString());
                }
            }
        } else {
            responseMessage = Bundle.getMessage("LN_MSG_SLOT_PROG_HELPER_RESPONSE_SUCCEEDED");
        }
        switch (pcmd & 0x7C) {
            case 32: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_SRVC_TRK_PAGED_RD", responseMessage, Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 96: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_SRVC_TRK_PAGED_WR", responseMessage, Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 40: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_SRVC_TRK_DIR_BYTE_RD", responseMessage, Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 104: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_SRVC_TRK_DIR_BYTE_WR", responseMessage, Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 8: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_SRVC_TRK_DIR_BIT_RD", responseMessage, Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 72: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_SRVC_TRK_DIR_BIT_WR", responseMessage, Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 16: 
            case 48: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_SRVC_TRK_REG_BYTE_RD", responseMessage, Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 80: 
            case 112: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_SRVC_TRK_REG_BYTE_WR", responseMessage, Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 24: 
            case 56: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_SRVC_TRK_RD_RESERVED", responseMessage, Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 88: 
            case 120: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_SRVC_TRK_WR_RESERVED", responseMessage, Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 36: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_OPS_BYTE_RD_NO_FEEDBACK", responseMessage, LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 100: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_OPS_BYTE_WR_NO_FEEDBACK", responseMessage, LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 44: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_OPS_BYTE_RD_FEEDBACK", responseMessage, LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 108: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_OPS_BYTE_WR_FEEDBACK", responseMessage, LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 4: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_OPS_BIT_RD_NO_FEEDBACK", responseMessage, LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 68: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_OPS_BIT_WR_NO_FEEDBACK", responseMessage, LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 12: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_OPS_BIT_RD_FEEDBACK", responseMessage, LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 76: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_OPS_BIT_WR_FEEDBACK", responseMessage, LocoNetMessageInterpret.convertToMixed(lopsa, hopsa), Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 0: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_UHLENBROCK_RD", responseMessage, Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
            case 64: {
                return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_UHLENBROCK_WR", responseMessage, Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
            }
        }
        return String.valueOf(Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_RESPONSE_UNKNOWN", pcmd, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(pcmd)), responseMessage, Bundle.getMessage("LN_MSG_SLOT_PROG_MODE_CV_INFO_HELPER_REPLY", cvNumber, cvData, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(cvData)), StringUtil.to8Bits(cvData, true)))) + hexMessage;
    }

    private static String interpretCmdStnCfgSlotRdWr(LocoNetMessage l, int command) {
        String thrown = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_OPSW_HELPER_THROWN");
        String closed = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_OPSW_HELPER_CLOSED");
        String opswGroup1 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 1, (l.getElement(3) & 1) != 0 ? closed : thrown, 2, (l.getElement(3) & 2) != 0 ? closed : thrown, 3, (l.getElement(3) & 4) != 0 ? closed : thrown, 4, (l.getElement(3) & 8) != 0 ? closed : thrown, 5, (l.getElement(3) & 0x10) != 0 ? closed : thrown, 6, (l.getElement(3) & 0x20) != 0 ? closed : thrown, 7, (l.getElement(3) & 0x40) != 0 ? closed : thrown, 8, thrown);
        String opswGroup2 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 9, (l.getElement(4) & 1) != 0 ? closed : thrown, 10, (l.getElement(4) & 2) != 0 ? closed : thrown, 11, (l.getElement(4) & 4) != 0 ? closed : thrown, 12, (l.getElement(4) & 8) != 0 ? closed : thrown, 13, (l.getElement(4) & 0x10) != 0 ? closed : thrown, 14, (l.getElement(4) & 0x20) != 0 ? closed : thrown, 15, (l.getElement(4) & 0x40) != 0 ? closed : thrown, 16, thrown);
        String opswGroup3 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 17, (l.getElement(5) & 1) != 0 ? closed : thrown, 18, (l.getElement(5) & 2) != 0 ? closed : thrown, 19, (l.getElement(5) & 4) != 0 ? closed : thrown, 20, (l.getElement(5) & 8) != 0 ? closed : thrown, 21, (l.getElement(5) & 0x10) != 0 ? closed : thrown, 22, (l.getElement(5) & 0x20) != 0 ? closed : thrown, 23, (l.getElement(5) & 0x40) != 0 ? closed : thrown, 24, thrown);
        String opswGroup4 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 25, (l.getElement(6) & 1) != 0 ? closed : thrown, 26, (l.getElement(6) & 2) != 0 ? closed : thrown, 27, (l.getElement(6) & 4) != 0 ? closed : thrown, 28, (l.getElement(6) & 8) != 0 ? closed : thrown, 29, (l.getElement(6) & 0x10) != 0 ? closed : thrown, 30, (l.getElement(6) & 0x20) != 0 ? closed : thrown, 31, (l.getElement(6) & 0x40) != 0 ? closed : thrown, 32, thrown);
        String opswGroup5 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 33, (l.getElement(8) & 1) != 0 ? closed : thrown, 34, (l.getElement(8) & 2) != 0 ? closed : thrown, 35, (l.getElement(8) & 4) != 0 ? closed : thrown, 36, (l.getElement(8) & 8) != 0 ? closed : thrown, 37, (l.getElement(8) & 0x10) != 0 ? closed : thrown, 38, (l.getElement(8) & 0x20) != 0 ? closed : thrown, 39, (l.getElement(8) & 0x40) != 0 ? closed : thrown, 40, thrown);
        String opswGroup6 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 41, (l.getElement(9) & 1) != 0 ? closed : thrown, 42, (l.getElement(9) & 2) != 0 ? closed : thrown, 43, (l.getElement(9) & 4) != 0 ? closed : thrown, 44, (l.getElement(9) & 8) != 0 ? closed : thrown, 45, (l.getElement(9) & 0x10) != 0 ? closed : thrown, 46, (l.getElement(9) & 0x20) != 0 ? closed : thrown, 47, (l.getElement(9) & 0x40) != 0 ? closed : thrown, 48, thrown);
        String opswGroup7 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 49, (l.getElement(10) & 1) != 0 ? closed : thrown, 50, (l.getElement(10) & 2) != 0 ? closed : thrown, 51, (l.getElement(10) & 4) != 0 ? closed : thrown, 52, (l.getElement(10) & 8) != 0 ? closed : thrown, 53, (l.getElement(10) & 0x10) != 0 ? closed : thrown, 54, (l.getElement(10) & 0x20) != 0 ? closed : thrown, 55, (l.getElement(10) & 0x40) != 0 ? closed : thrown, 56, thrown);
        String opswGroup8 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 57, (l.getElement(11) & 1) != 0 ? closed : thrown, 58, (l.getElement(11) & 2) != 0 ? closed : thrown, 59, (l.getElement(11) & 4) != 0 ? closed : thrown, 60, (l.getElement(11) & 8) != 0 ? closed : thrown, 61, (l.getElement(11) & 0x10) != 0 ? closed : thrown, 62, (l.getElement(11) & 0x20) != 0 ? closed : thrown, 63, (l.getElement(11) & 0x40) != 0 ? closed : thrown, 64, thrown);
        return Bundle.getMessage(command == 239 ? "LN_MSG_SLOT_CMD_STN_CFG_WRITE_REQ" : "LN_MSG_SLOT_CMD_STN_CFG_READ_REPORT", opswGroup1, opswGroup2, opswGroup3, opswGroup4, opswGroup5, opswGroup6, opswGroup7, opswGroup8);
    }

    private static String interpretCmdStnExtCfgSlotRdWr(LocoNetMessage l, int command) {
        String thrown = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_OPSW_HELPER_THROWN");
        String closed = Bundle.getMessage("LN_MSG_OPC_MULTI_SENSE_OPSW_HELPER_CLOSED");
        String opswGroup1 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 65, (l.getElement(3) & 1) != 0 ? closed : thrown, 66, (l.getElement(3) & 2) != 0 ? closed : thrown, 67, (l.getElement(3) & 4) != 0 ? closed : thrown, 68, (l.getElement(3) & 8) != 0 ? closed : thrown, 69, (l.getElement(3) & 0x10) != 0 ? closed : thrown, 70, (l.getElement(3) & 0x20) != 0 ? closed : thrown, 71, (l.getElement(3) & 0x40) != 0 ? closed : thrown, 72, thrown);
        String opswGroup2 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 73, (l.getElement(4) & 1) != 0 ? closed : thrown, 74, (l.getElement(4) & 2) != 0 ? closed : thrown, 75, (l.getElement(4) & 4) != 0 ? closed : thrown, 76, (l.getElement(4) & 8) != 0 ? closed : thrown, 77, (l.getElement(4) & 0x10) != 0 ? closed : thrown, 78, (l.getElement(4) & 0x20) != 0 ? closed : thrown, 79, (l.getElement(4) & 0x40) != 0 ? closed : thrown, 80, thrown);
        String opswGroup3 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 81, (l.getElement(5) & 1) != 0 ? closed : thrown, 82, (l.getElement(5) & 2) != 0 ? closed : thrown, 83, (l.getElement(5) & 4) != 0 ? closed : thrown, 84, (l.getElement(5) & 8) != 0 ? closed : thrown, 85, (l.getElement(5) & 0x10) != 0 ? closed : thrown, 86, (l.getElement(5) & 0x20) != 0 ? closed : thrown, 87, (l.getElement(5) & 0x40) != 0 ? closed : thrown, 88, thrown);
        String opswGroup4 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 89, (l.getElement(6) & 1) != 0 ? closed : thrown, 90, (l.getElement(6) & 2) != 0 ? closed : thrown, 91, (l.getElement(6) & 4) != 0 ? closed : thrown, 92, (l.getElement(6) & 8) != 0 ? closed : thrown, 93, (l.getElement(6) & 0x10) != 0 ? closed : thrown, 94, (l.getElement(6) & 0x20) != 0 ? closed : thrown, 95, (l.getElement(6) & 0x40) != 0 ? closed : thrown, 96, thrown);
        String opswGroup5 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 97, (l.getElement(8) & 1) != 0 ? closed : thrown, 98, (l.getElement(8) & 2) != 0 ? closed : thrown, 99, (l.getElement(8) & 4) != 0 ? closed : thrown, 100, (l.getElement(8) & 8) != 0 ? closed : thrown, 101, (l.getElement(8) & 0x10) != 0 ? closed : thrown, 102, (l.getElement(8) & 0x20) != 0 ? closed : thrown, 103, (l.getElement(8) & 0x40) != 0 ? closed : thrown, 104, thrown);
        String opswGroup6 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 105, (l.getElement(9) & 1) != 0 ? closed : thrown, 106, (l.getElement(9) & 2) != 0 ? closed : thrown, 107, (l.getElement(9) & 4) != 0 ? closed : thrown, 108, (l.getElement(9) & 8) != 0 ? closed : thrown, 109, (l.getElement(9) & 0x10) != 0 ? closed : thrown, 110, (l.getElement(9) & 0x20) != 0 ? closed : thrown, 111, (l.getElement(9) & 0x40) != 0 ? closed : thrown, 112, thrown);
        String opswGroup7 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 113, (l.getElement(10) & 1) != 0 ? closed : thrown, 114, (l.getElement(10) & 2) != 0 ? closed : thrown, 115, (l.getElement(10) & 4) != 0 ? closed : thrown, 116, (l.getElement(10) & 8) != 0 ? closed : thrown, 117, (l.getElement(10) & 0x10) != 0 ? closed : thrown, 118, (l.getElement(10) & 0x20) != 0 ? closed : thrown, 119, (l.getElement(10) & 0x40) != 0 ? closed : thrown, 120, thrown);
        String opswGroup8 = Bundle.getMessage("LN_MSG_SLOT_CMD_STN_CFG_HELPER_EIGHT_OPSWS", 121, (l.getElement(11) & 1) != 0 ? closed : thrown, 122, (l.getElement(11) & 2) != 0 ? closed : thrown, 123, (l.getElement(11) & 4) != 0 ? closed : thrown, 124, (l.getElement(11) & 8) != 0 ? closed : thrown, 125, (l.getElement(11) & 0x10) != 0 ? closed : thrown, 126, (l.getElement(11) & 0x20) != 0 ? closed : thrown, 127, (l.getElement(11) & 0x40) != 0 ? closed : thrown, 128, thrown);
        return Bundle.getMessage(command == 239 ? "LN_MSG_SLOT_CMD_STN_EXT_CFG_WRITE_REQ" : "LN_MSG_SLOT_CMD_STN_EXT_CFG_READ_REPORT", opswGroup1, opswGroup2, opswGroup3, opswGroup4, opswGroup5, opswGroup6, opswGroup7, opswGroup8);
    }

    private static String interpretStandardSlotRdWr(LocoNetMessage l, int id1, int id2, int command, int slot) {
        int trackStatus = l.getElement(7);
        int stat = l.getElement(3);
        int adr = l.getElement(4);
        int spd = l.getElement(5);
        int dirf = l.getElement(6);
        String[] dirf0_4 = LocoNetMessageInterpret.interpretF0_F4toStrings(dirf);
        int ss2 = l.getElement(8);
        int adr2 = l.getElement(9);
        int snd = l.getElement(10);
        String[] sndf5_8 = LocoNetMessageInterpret.interpretF5_F8toStrings(snd);
        String locoAdrStr = LocoNetMessageInterpret.figureAddressIncludingAliasing(adr, adr2, ss2, id1, id2);
        return Bundle.getMessage(command == 239 ? "LN_MSG_SLOT_LOCO_INFO_WRITE" : "LN_MSG_SLOT_LOCO_INFO_READ", slot, locoAdrStr, LnConstants.CONSIST_STAT(stat), LnConstants.LOCO_STAT(stat), LnConstants.DEC_MODE(stat), LocoNetMessageInterpret.directionOfTravelString((dirf & 0x20) == 0), spd, dirf0_4[0], dirf0_4[1], dirf0_4[2], dirf0_4[3], dirf0_4[4], sndf5_8[0], sndf5_8[1], sndf5_8[2], sndf5_8[3], LocoNetMessageInterpret.trackStatusByteToString(trackStatus), Bundle.getMessage("LN_MSG_SLOT_HELPER_SS2_SIMPLE", Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(ss2))), Bundle.getMessage("LN_MSG_SLOT_HELPER_ID1_ID2_AS_THROTTLE_ID", LocoNetMessageInterpret.idString(id1, id2)));
    }

    private static String interpretOpcPanelResponse(LocoNetMessage l) {
        switch (l.getElement(1)) {
            case 18: {
                return Bundle.getMessage("LN_MSG_OPC_D7_TETHERLESS_REPORT_UR92", l.getElement(3) & 7, (l.getElement(3) & 8) == 8 ? Bundle.getMessage("LN_MSG_HELPER_D7_UR92_DUPLEX") : "");
            }
            case 23: {
                return Bundle.getMessage("LN_MSG_OPC_D7_TETHERLESS_REPORT_UR90", l.getElement(3) & 7);
            }
            case 31: {
                return Bundle.getMessage("LN_MSG_OPC_D7_TETHERLESS_REPORT_UR91", l.getElement(3) & 7);
            }
        }
        return "";
    }

    private static String interpretOpcLissyUpdate(LocoNetMessage l) {
        switch (l.getElement(1)) {
            case 8: {
                int unit = l.getElement(4) & 0x7F;
                int address = (l.getElement(6) & 0x7F) + 128 * (l.getElement(5) & 0x7F);
                switch (l.getElement(2)) {
                    case 0: {
                        return Bundle.getMessage("LN_MSG_LISSY_IR_REPORT_LOCO_MOVEMENT", unit, Integer.toString(address), (l.getElement(3) & 0x20) == 0 ? Bundle.getMessage("LN_MSG_LISSY_IR_REPORT_HELPER_DIRECTION_NORTH") : Bundle.getMessage("LN_MSG_LISSY_IR_REPORT_HELPER_DIRECTION_SOUTH"));
                    }
                    case 1: {
                        int wheelCount = (l.getElement(6) & 0x7F) + 128 * (l.getElement(5) & 0x7F);
                        return Bundle.getMessage("LN_MSG_LISSY_WHEEL_REPORT_LOCO_MOVEMENT", unit, Integer.toString(wheelCount), (l.getElement(3) & 0x20) == 0 ? Bundle.getMessage("LN_MSG_LISSY_IR_REPORT_HELPER_DIRECTION_NORTH") : Bundle.getMessage("LN_MSG_LISSY_IR_REPORT_HELPER_DIRECTION_SOUTH"));
                    }
                }
                break;
            }
            case 10: {
                String status;
                int element = l.getElement(2) * 128 + l.getElement(3);
                int stat1 = l.getElement(5);
                int stat2 = l.getElement(6);
                switch (stat1 & 0x30) {
                    case 48: {
                        status = Bundle.getMessage("LN_MSG_SE_REPORT_HELPER_BOTH_RES");
                        break;
                    }
                    case 16: {
                        status = Bundle.getMessage("LN_MSG_SE_REPORT_HELPER_AX_RES");
                        break;
                    }
                    case 32: {
                        status = Bundle.getMessage("LN_MSG_SE_REPORT_HELPER_XA_RES");
                        break;
                    }
                    default: {
                        status = Bundle.getMessage("LN_MSG_SE_REPORT_HELPER_NO_RES");
                    }
                }
                return Bundle.getMessage("LN_MSG_SE_REPORT", element + 1, element, l.getElement(7), l.getElement(8), status, Bundle.getMessage((stat2 & 1) != 0 ? "LN_MSG_SWITCH_STATE_THROWN" : "LN_MSG_SWITCH_STATE_CLOSED"), Bundle.getMessage((stat1 & 1) != 0 ? "LN_MSG_SE_REPORT_HELPER_OCCUPIED" : "LN_MSG_SE_REPORT_HELPER_UNOCCUPIED"));
            }
            case 9: {
                if (l.getElement(4) != 0) break;
                return String.valueOf(Bundle.getMessage("LN_MSG_UNRECOGNIZED_SIG_STATE_REPORT_MAY_BE_FROM_CML_HW")) + Bundle.getMessage("LN_MONITOR_MESSAGE_RAW_HEX_INFO", l.toString());
            }
        }
        return "";
    }

    private static String interpretOpcImmPacket(LocoNetMessage l) {
        if (l.getElement(1) == 15) {
            String result = LocoNetMessageInterpret.interpretLncvMessage(l);
            if (result.length() > 0) {
                return result;
            }
            return "";
        }
        int val7f = l.getElement(2);
        int reps = l.getElement(3);
        int dhi = l.getElement(4);
        int im1 = l.getElement(5);
        int im2 = l.getElement(6);
        int im3 = l.getElement(7);
        int im4 = l.getElement(8);
        int im5 = l.getElement(9);
        int mobileDecoderAddress = -999;
        int nmraInstructionType = -999;
        int nmraSubInstructionType = -999;
        int playableWhistleLevel = -999;
        if (val7f == 127 && l.getElement(1) == 11) {
            int len = (reps & 0x70) >> 4;
            if (len < 2) {
                return "";
            }
            byte[] packet = new byte[len];
            int[] packetInt = new int[len];
            packet[0] = (byte)(im1 + ((dhi & 1) != 0 ? 128 : 0));
            packetInt[0] = im1 + ((dhi & 1) != 0 ? 128 : 0);
            packet[1] = (byte)(im2 + ((dhi & 2) != 0 ? 128 : 0));
            packetInt[1] = im2 + ((dhi & 2) != 0 ? 128 : 0);
            if (len >= 3) {
                packet[2] = (byte)(im3 + ((dhi & 4) != 0 ? 128 : 0));
                packetInt[2] = im3 + ((dhi & 4) != 0 ? 128 : 0);
            }
            if (len >= 4) {
                packet[3] = (byte)(im4 + ((dhi & 8) != 0 ? 128 : 0));
                packetInt[3] = im4 + ((dhi & 8) != 0 ? 128 : 0);
            }
            if (len >= 5) {
                packet[4] = (byte)(im5 + ((dhi & 0x10) != 0 ? 128 : 0));
                packetInt[4] = im5 + ((dhi & 0x10) != 0 ? 128 : 0);
            }
            if ((packetInt[0] & 0x80) == 0) {
                mobileDecoderAddress = packetInt[0];
                nmraInstructionType = (packetInt[1] & 0xE) >> 5;
                nmraSubInstructionType = packetInt[1] & 0x1F;
                if (nmraSubInstructionType == 29 && packetInt[2] == 127) {
                    playableWhistleLevel = packetInt[3];
                }
            } else if ((packetInt[0] & 0xC0) == 192) {
                mobileDecoderAddress = ((packetInt[0] & 0x3F) << 8) + packetInt[1];
                nmraInstructionType = (packetInt[2] & 0xE0) >> 5;
                nmraSubInstructionType = packetInt[2] & 0x1F;
                if (nmraSubInstructionType == 29 && packetInt[3] == 127) {
                    playableWhistleLevel = packetInt[4];
                }
            } else {
                log.debug("got Here 1.");
            }
            if (mobileDecoderAddress >= 0 && nmraInstructionType == 1 && nmraSubInstructionType == 29) {
                return Bundle.getMessage("LN_MSG_PLAYABLE_WHISTLE_CONTROL", Integer.toString(mobileDecoderAddress), playableWhistleLevel, reps & 7);
            }
            if ((packetInt[0] & 0xC0) == 192) {
                int address = ((packetInt[0] & 0x3F) << 8) + packetInt[1];
                if ((packetInt[2] & 0xFF) == 223) {
                    return Bundle.getMessage("LN_MSG_SEND_PACKET_IMM_SET_F21_TO_F28", Integer.toString(address), Bundle.getMessage((packetInt[3] & 1) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 2) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 4) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 8) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 0x10) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 0x20) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 0x40) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 0x80) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"));
                }
                if ((packetInt[2] & 0xFF) == 222) {
                    return Bundle.getMessage("LN_MSG_SEND_PACKET_IMM_SET_F13_TO_F20", Integer.toString(address), Bundle.getMessage((packetInt[3] & 1) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 2) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 4) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 8) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 0x10) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 0x20) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 0x40) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[3] & 0x80) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"));
                }
                if ((packetInt[2] & 0xF0) == 160) {
                    return Bundle.getMessage("LN_MSG_SEND_PACKET_IMM_SET_F9_TO_F12", Integer.toString(address), Bundle.getMessage((packetInt[2] & 1) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 2) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 4) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 8) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"));
                }
                return Bundle.getMessage("LN_MSG_OPC_IMM_PKT_GENERIC", (reps & 0x70) >> 4, reps & 7, reps, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(dhi)), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(im1)), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(im2)), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(im3)), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(im4)), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(im5)), NmraPacket.format(packet));
            }
            int address = packetInt[0];
            if ((packetInt[1] & 0xFF) == 223) {
                return Bundle.getMessage("LN_MSG_SEND_PACKET_IMM_SET_F21_TO_F28", address, Bundle.getMessage((packetInt[2] & 1) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 2) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 4) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 8) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 0x10) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 0x20) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 0x40) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 0x80) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"));
            }
            if ((packetInt[1] & 0xFF) == 222) {
                return Bundle.getMessage("LN_MSG_SEND_PACKET_IMM_SET_F13_TO_F20", address, Bundle.getMessage((packetInt[2] & 1) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 2) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 4) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 8) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 0x10) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 0x20) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 0x40) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[2] & 0x80) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"));
            }
            if ((packetInt[1] & 0xF0) == 160) {
                return Bundle.getMessage("LN_MSG_SEND_PACKET_IMM_SET_F9_TO_F12", address, Bundle.getMessage((packetInt[1] & 1) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[1] & 2) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[1] & 4) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((packetInt[1] & 8) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"));
            }
            return Bundle.getMessage("LN_MSG_OPC_IMM_PKT_GENERIC", (reps & 0x70) >> 4, reps & 7, reps, Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(dhi)), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(im1)), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(im2)), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(im3)), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(im4)), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(im5)), NmraPacket.format(packet));
        }
        if (l.getElement(1) == 31) {
            if (l.getElement(2) == 1 && l.getElement(3) == 73 && l.getElement(4) == 66 && l.getElement(6) != 94 && l.getElement(10) == 112 && l.getElement(11) == 0 && l.getElement(15) == 16) {
                String cv = Integer.toString(l.getElement(8) * 256 + (l.getElement(5) & 2) * 64 + l.getElement(7));
                int val = l.getElement(9) + 16 * (l.getElement(5) & 8);
                switch (l.getElement(6)) {
                    case 108: {
                        return Bundle.getMessage("LN_MSG_UHLEN_READ_CV_REG_MODE_FROM_PT", cv);
                    }
                    case 109: {
                        return Bundle.getMessage("LN_MSG_UHLEN_WRITE_CV_REG_MODE_FROM_PT", cv);
                    }
                    case 110: {
                        return Bundle.getMessage("LN_MSG_UHLEN_READ_CV_PAGED_MODE_FROM_PT", cv);
                    }
                    case 111: {
                        return Bundle.getMessage("LN_MSG_UHLEN_WRITE_CV_PAGED_MODE_FROM_PT", cv);
                    }
                    case 113: {
                        return Bundle.getMessage("LN_MSG_UHLEN_WRITE_CV_DIRECT_BYTE_MODE_FROM_PT", cv, val);
                    }
                    case 112: 
                    case 114: {
                        return Bundle.getMessage("LN_MSG_UHLEN_READ_CV_DIRECT_BYTE_MODE_FROM_PT", cv);
                    }
                }
                return "";
            }
            if (l.getElement(2) == 1 && l.getElement(3) == 73 && l.getElement(4) == 66 && l.getElement(6) == 94) {
                int addr = l.getElement(8) * 256 + (l.getElement(5) & 2) * 64 + l.getElement(7);
                String cv = Integer.toString(l.getElement(11) * 256 + ((l.getElement(5) & 8) << 4) + l.getElement(9));
                int val = ((l.getElement(10) & 2) << 6) + l.getElement(12);
                return Bundle.getMessage("LN_MSG_UHLEN_CV_OPS_MODE_WRITE", addr, cv, val);
            }
        }
        return "";
    }

    private static String interpretOpcPr3Mode(LocoNetMessage l) {
        if (l.getElement(1) == 16 && (l.getElement(2) & 0x7C) == 0 && l.getElement(3) == 0 && l.getElement(4) == 0) {
            switch (l.getElement(2) & 3) {
                case 0: {
                    return Bundle.getMessage("LN_MSG_SET_PR3_MODE_LOCONET_IF_WITHOUT_TERM");
                }
                case 2: {
                    return Bundle.getMessage("LN_MSG_SET_PR3_MODE_PR3_PROGRAMMING_TRACK_ONLY");
                }
                case 3: {
                    return Bundle.getMessage("LN_MSG_SET_PR3_MODE_LN_MSG_SET_PR3_MODE_LOCONET_IF_WITH_TERM");
                }
            }
        }
        return "";
    }

    private static String interpretIb2Special(LocoNetMessage l) {
        if (l.getElement(1) == 32 && (l.getElement(3) == 7 || l.getElement(3) == 8 || l.getElement(3) == 9)) {
            int funcOffset = 5 + 8 * (l.getElement(3) - 7);
            String encodingType = l.getElement(3) == 7 ? Bundle.getMessage("LN_MSG_INTELLIBOX_FUNC_CTL_HELPER_IB1") : Bundle.getMessage("LN_MSG_INTELLIBOX_FUNC_CTL_HELPER_IB2");
            String[] funcInfo = new String[7];
            int mask = 1;
            int i = 0;
            while (i < 7) {
                funcInfo[i] = Bundle.getMessage("LN_MSG_INTELLIBOX_FUNC_CTL_HELPER_INDIV_FUNC", funcOffset + i, Bundle.getMessage((l.getElement(4) & mask) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"));
                mask *= 2;
                ++i;
            }
            return Bundle.getMessage("LN_MSG_INTELLIBOX_FUNC_CTL", encodingType, l.getElement(2), funcInfo[0], funcInfo[1], funcInfo[2], funcInfo[3], funcInfo[4], funcInfo[5], funcInfo[6]);
        }
        if (l.getElement(1) == 32 && l.getElement(3) == 5) {
            return Bundle.getMessage("LN_MSG_INTELLIBOX_SPECIAL_FUNC_CTL", l.getElement(2), Bundle.getMessage((l.getElement(4) & 0x10) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((l.getElement(4) & 0x20) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((l.getElement(4) & 0x40) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"));
        }
        if (l.getElement(1) == 32 && l.getElement(3) == 6) {
            String[] funcInfo = new String[7];
            funcInfo[0] = Bundle.getMessage("LN_MSG_INTELLIBOX_FUNC_CTL_HELPER_INDIV_FUNC", 0, (l.getElement(4) & 0x10) == 0 ? Bundle.getMessage("LN_MSG_FUNC_ON") : Bundle.getMessage("LN_MSG_FUNC_OFF"));
            int mask = 1;
            int i = 0;
            while (i < 4) {
                funcInfo[i + 1] = Bundle.getMessage("LN_MSG_INTELLIBOX_FUNC_CTL_HELPER_INDIV_FUNC", i + 1, Bundle.getMessage((l.getElement(4) & mask) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"));
                mask *= 2;
                ++i;
            }
            return Bundle.getMessage("LN_MSG_INTELLIBOX_FUNC_CTL_F0_TO_F4", l.getElement(2), funcInfo[0], funcInfo[1], funcInfo[2], funcInfo[3], funcInfo[4]);
        }
        return "";
    }

    private static String interpretIb2F9_to_F12(LocoNetMessage l) {
        int slot = l.getElement(1);
        int funcs = l.getElement(2);
        return Bundle.getMessage("LN_MSG_INTELLIBOX_SLOT_SET_F9_TO_F12", slot, Bundle.getMessage((funcs & 1) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((funcs & 2) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((funcs & 4) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"), Bundle.getMessage((funcs & 8) != 0 ? "LN_MSG_FUNC_ON" : "LN_MSG_FUNC_OFF"));
    }

    private static int LOCO_ADR(int a1, int a2) {
        return (a1 & 0x7F) * 128 + (a2 & 0x7F);
    }

    private static int SENSOR_ADR(int a1, int a2) {
        return (a2 & 0xF) * 128 + (a1 & 0x7F) + 1;
    }

    public static String dotme(int val) {
        if (val >= 0 && val < 10) {
            return Bundle.getMessage("LN_MSG_LOCOIO_HELPER_FIRMWARE_REV_DOTTED_ONE_DIGIT", val);
        }
        if (val >= 10 && val < 100) {
            return Bundle.getMessage("LN_MSG_LOCOIO_HELPER_FIRMWARE_REV_DOTTED_TWO_DIGITS", val / 10, val % 10);
        }
        if (val >= 100 && val < 1000) {
            int hundreds = val / 100;
            int tens = (val - hundreds * 100) / 10;
            int ones = val % 10;
            return Bundle.getMessage("LN_MSG_LOCOIO_HELPER_FIRMWARE_REV_DOTTED_THREE_DIGITS", hundreds, tens, ones);
        }
        return Bundle.getMessage("LN_MSG_LOCOIO_HELPER_FIRMWARE_REV_OUT_OF_RANGE", val);
    }

    private static String idString(int id1, int id2) {
        String decimalIdValueWithoutLocale_SpecificFormatting = Integer.toString((id2 & 0x7F) * 128 + (id1 & 0x7F));
        String s = Bundle.getMessage("LN_MSG_THROTTLE_ID", Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(id2 & 0x7F)), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(id1 & 0x7F)), decimalIdValueWithoutLocale_SpecificFormatting);
        return s;
    }

    private static String convertToMixed(int addressLow, int addressHigh) {
        switch (addressHigh) {
            case 125: {
                log.debug("addressLow / 10 = {}", (Object)(addressLow / 10));
                switch (addressLow) {
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: {
                        return Bundle.getMessage("LN_MSG_HELPER_IS_ALTERNATE_SHORT_AND_LONG_ADDRESS_Ax", addressLow, addressLow - 100, String.valueOf(LocoNetMessageInterpret.LOCO_ADR(addressHigh, addressLow)));
                    }
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: {
                        return Bundle.getMessage("LN_MSG_HELPER_IS_ALTERNATE_SHORT_AND_LONG_ADDRESS_Bx", addressLow, addressLow - 110, String.valueOf(LocoNetMessageInterpret.LOCO_ADR(addressHigh, addressLow)));
                    }
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: {
                        return Bundle.getMessage("LN_MSG_HELPER_IS_ALTERNATE_SHORT_AND_LONG_ADDRESS_Cx", addressLow, addressLow - 120, String.valueOf(LocoNetMessageInterpret.LOCO_ADR(addressHigh, addressLow)));
                    }
                }
                return Bundle.getMessage("LN_MSG_HELPER_IS_SHORT_AND_LONG_ADDRESS", addressLow, String.valueOf(LocoNetMessageInterpret.LOCO_ADR(addressHigh, addressLow)));
            }
            case 0: 
            case 127: {
                switch (addressLow) {
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: {
                        return Bundle.getMessage("LN_MSG_HELPER_IS_ALTERNATE_SHORT_ADDRESS_Ax", addressLow, addressLow - 100);
                    }
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: {
                        return Bundle.getMessage("LN_MSG_HELPER_IS_ALTERNATE_SHORT_ADDRESS_Bx", addressLow, addressLow - 110);
                    }
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: {
                        return Bundle.getMessage("LN_MSG_HELPER_IS_ALTERNATE_SHORT_ADDRESS_Cx", addressLow, addressLow - 120);
                    }
                }
                return Bundle.getMessage("LN_MSG_HELPER_IS_SHORT_ADDRESS", addressLow);
            }
        }
        return String.valueOf(LocoNetMessageInterpret.LOCO_ADR(addressHigh, addressLow));
    }

    private static String trackStatusByteToString(int trackStatusByte) {
        return Bundle.getMessage("LN_MSG_SLOT_HELPER_TRK_STAT", (trackStatusByte & 4) != 0 ? Bundle.getMessage("LN_MSG_SLOT_HELPER_TRK_STATUS_LN1_1") : Bundle.getMessage("LN_MSG_SLOT_HELPER_TRK_STATUS_DT200"), (trackStatusByte & 1) != 0 ? Bundle.getMessage("LN_MSG_SLOT_HELPER_TRK_STATUS_TRK_PWR_ON") : Bundle.getMessage("LN_MSG_SLOT_HELPER_TRK_STATUS_TRK_PWR_OFF"), (trackStatusByte & 2) != 0 ? Bundle.getMessage("LN_MSG_SLOT_HELPER_TRK_STATUS_TRK_PWR_RUNNING") : Bundle.getMessage("LN_MSG_SLOT_HELPER_TRK_STATUS_TRK_PWR_PAUSED"), (trackStatusByte & 8) != 0 ? Bundle.getMessage("LN_MSG_SLOT_HELPER_TRK_STATUS_PRG_BUSY") : Bundle.getMessage("LN_MSG_SLOT_HELPER_TRK_STATUS_PRG_AVAILABLE"));
    }

    private static String fcTimeToString(int hour, int minute) {
        return Bundle.getMessage("LN_MSG_SLOT_HELPER_FC_TIME", LocalTime.of(hour, minute).toString());
    }

    protected static String[] interpretF0_F4toStrings(int dirf) {
        String[] s = new String[]{(dirf & 0x10) == 16 ? Bundle.getMessage("LN_MSG_FUNC_ON") : Bundle.getMessage("LN_MSG_FUNC_OFF"), (dirf & 1) == 1 ? Bundle.getMessage("LN_MSG_FUNC_ON") : Bundle.getMessage("LN_MSG_FUNC_OFF"), (dirf & 2) == 2 ? Bundle.getMessage("LN_MSG_FUNC_ON") : Bundle.getMessage("LN_MSG_FUNC_OFF"), (dirf & 4) == 4 ? Bundle.getMessage("LN_MSG_FUNC_ON") : Bundle.getMessage("LN_MSG_FUNC_OFF"), (dirf & 8) == 8 ? Bundle.getMessage("LN_MSG_FUNC_ON") : Bundle.getMessage("LN_MSG_FUNC_OFF")};
        return s;
    }

    protected static String directionOfTravelString(boolean isForward) {
        return Bundle.getMessage(isForward ? "LN_MSG_DIRECTION_FWD" : "LN_MSG_DIRECTION_REV");
    }

    protected static String[] interpretF5_F8toStrings(int snd) {
        String[] s = new String[]{(snd & 1) == 1 ? Bundle.getMessage("LN_MSG_FUNC_ON") : Bundle.getMessage("LN_MSG_FUNC_OFF"), (snd & 2) == 2 ? Bundle.getMessage("LN_MSG_FUNC_ON") : Bundle.getMessage("LN_MSG_FUNC_OFF"), (snd & 4) == 4 ? Bundle.getMessage("LN_MSG_FUNC_ON") : Bundle.getMessage("LN_MSG_FUNC_OFF"), (snd & 8) == 8 ? Bundle.getMessage("LN_MSG_FUNC_ON") : Bundle.getMessage("LN_MSG_FUNC_OFF")};
        return s;
    }

    private static String figureAddressIncludingAliasing(int adr, int adr2, int ss2, int id1, int id2) {
        String mixedAdrStr = LocoNetMessageInterpret.convertToMixed(adr, adr2);
        if (adr2 == 127) {
            if ((ss2 & 0xC) == 4) {
                return Bundle.getMessage("LN_MSG_LOCO_ADDR_HELPER_ALIAS_2_DIGIT_WITH_KNOWN_4_DIGIT", Integer.toString(LocoNetMessageInterpret.LOCO_ADR(id2, id1)), mixedAdrStr);
            }
            return Bundle.getMessage("LN_MSG_LOCO_ADDR_HELPER_ALIAS_2_DIGIT_WITH_UNKNOWN_4_DIGIT", mixedAdrStr);
        }
        return mixedAdrStr;
    }

    private static String getAlmTaskType(int taskTypeByte) {
        if (taskTypeByte == 2) {
            return Bundle.getMessage("LN_MSG_ALM_HELPER_TASK_TYPE_RD");
        }
        if (taskTypeByte == 3) {
            return Bundle.getMessage("LN_MSG_ALM_HELPER_TASK_TYPE_WR");
        }
        if (taskTypeByte == 0) {
            return Bundle.getMessage("LN_MSG_ALM_HELPER_TASK_TYPE_ID");
        }
        return Bundle.getMessage("LN_MSG_ALM_HELPER_TASK_TYPE_UNKONWN", taskTypeByte);
    }

    public static String getDeviceNameFromIPLInfo(int manuf, int type) {
        if (manuf != 0) {
            return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_UNDEFINED_MFG_PROD", manuf, type);
        }
        switch (type) {
            case 0: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_ALLDEVICES");
            }
            case 1: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_LNRP");
            }
            case 4: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_UT4");
            }
            case 12: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_WTL12");
            }
            case 27: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_DCS210");
            }
            case 28: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_DCS240");
            }
            case 35: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_PR3");
            }
            case 42: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_DT402");
            }
            case 50: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_DT500");
            }
            case 51: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_DCS51");
            }
            case 52: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_DCS52");
            }
            case 92: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_UR92");
            }
            case 36: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_PR4");
            }
            case 99: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_LNWI");
            }
            case 88: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_BXP88");
            }
            case 21: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_DB210");
            }
            case 20: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_DB210OPTO");
            }
            case 22: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_DB220");
            }
        }
        return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_HOST_UNKNOWN", type);
    }

    public static String getSlaveNameFromIPLInfo(int manuf, int slaveNum) {
        if (manuf != 0) {
            return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_UNDEFINED_MFG_PROD", manuf, slaveNum);
        }
        switch (slaveNum) {
            case 0: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_SLAVE_ALLDEVICES");
            }
            case 24: {
                return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_SLAVE_RF24");
            }
        }
        return Bundle.getMessage("LN_MSG_IPL_DEVICE_HELPER_DIGITRAX_SLAVE_UNKNOWN", slaveNum);
    }

    public static String interpretAlm(LocoNetMessage l) {
        block25: {
            int slot;
            String result;
            block24: {
                if (l.getOpCode() != 230 && l.getOpCode() != 238) {
                    return "";
                }
                if (l.getElement(1) != 16) break block24;
                switch (l.getElement(2)) {
                    case 0: {
                        if (l.getElement(3) == 0 && l.getElement(6) == 0) {
                            return Bundle.getMessage("LN_MSG_QUERY_ALIAS_INFO");
                        }
                        if (l.getElement(3) == 0 && l.getElement(6) == 11) {
                            return Bundle.getMessage("LN_MSG_ALIAS_INFO_REPORT", l.getElement(4) * 2);
                        }
                        if (l.getElement(6) == 15 && l.getElement(14) == 0) {
                            if (l.getElement(3) == 2) {
                                if (l.getOpCode() == 238) {
                                    return Bundle.getMessage("LN_MSG_QUERY_ALIAS", l.getElement(4));
                                }
                                String message = "LN_MSG_REPORT_ALIAS_2_ALIASES";
                                String longAddr = LocoNetMessageInterpret.convertToMixed(l.getElement(7), l.getElement(8));
                                int shortAddr = l.getElement(9);
                                String longAddr2 = LocoNetMessageInterpret.convertToMixed(l.getElement(11), l.getElement(12));
                                int shortAddr2 = l.getElement(13);
                                int pair = l.getElement(4);
                                return Bundle.getMessage(message, pair, longAddr, shortAddr, longAddr2, shortAddr2);
                            }
                        } else {
                            if (l.getElement(3) == 67) {
                                String longAddr = LocoNetMessageInterpret.convertToMixed(l.getElement(7), l.getElement(8));
                                int shortAddr = l.getElement(9);
                                String longAddr2 = LocoNetMessageInterpret.convertToMixed(l.getElement(11), l.getElement(12));
                                int shortAddr2 = l.getElement(13);
                                int pair = l.getElement(4);
                                return Bundle.getMessage("LN_MSG_SET_ALIAS_2_ALIASES", pair, longAddr, shortAddr, longAddr2, shortAddr2);
                            }
                            if (l.getElement(6) == 0 && l.getElement(14) == 0) {
                                return Bundle.getMessage("LN_MSG_QUERY_ALIAS", l.getElement(4));
                            }
                        }
                        break block25;
                    }
                    case 1: {
                        if (l.getElement(2) == 1 && (l.getElement(3) & 0x7E) == 2) {
                            String statD;
                            String turnD;
                            String statC;
                            String turnC;
                            String statB;
                            String turnB;
                            String statA;
                            String turnA;
                            int routeNum = 1 + ((l.getElement(4) + l.getElement(5) * 128) / 2 & 0x1F);
                            int turnoutGroup = 1 + ((l.getElement(4) & 1) << 2);
                            int altRouteNum = 1 + ((l.getElement(4) + l.getElement(5) * 128) / 4 & 0x3F);
                            int altTurnoutGroup = 1 + ((l.getElement(4) & 3) << 2);
                            if (l.getOpCode() == 238 && (l.getElement(3) & 1) == 0) {
                                return Bundle.getMessage("LN_MSG_CMD_STN_ROUTE_QUERY", routeNum, turnoutGroup, turnoutGroup + 3, altRouteNum, altTurnoutGroup, altTurnoutGroup + 3);
                            }
                            if (l.getElement(7) == 127 && l.getElement(8) == 127) {
                                turnA = "Unused";
                                statA = "";
                            } else {
                                turnA = Integer.toString(1 + l.getElement(7) + ((l.getElement(8) & 0xF) << 7));
                                String string = statA = (l.getElement(8) & 0x20) == 32 ? "c" : "t";
                            }
                            if (l.getElement(9) == 127 && l.getElement(10) == 127) {
                                turnB = "Unused";
                                statB = "";
                            } else {
                                turnB = Integer.toString(1 + l.getElement(9) + ((l.getElement(10) & 0xF) << 7));
                                String string = statB = (l.getElement(10) & 0x20) == 32 ? "c" : "t";
                            }
                            if (l.getElement(11) == 127 && l.getElement(12) == 127) {
                                turnC = "Unused";
                                statC = "";
                            } else {
                                turnC = Integer.toString(1 + l.getElement(11) + ((l.getElement(12) & 0xF) << 7));
                                String string = statC = (l.getElement(12) & 0x20) == 32 ? "c" : "t";
                            }
                            if (l.getElement(13) == 127 && l.getElement(14) == 127) {
                                turnD = "Unused";
                                statD = "";
                            } else {
                                turnD = Integer.toString(1 + l.getElement(13) + ((l.getElement(14) & 0xF) << 7));
                                statD = (l.getElement(14) & 0x20) == 32 ? "c" : "t";
                            }
                            return Bundle.getMessage(l.getOpCode() == 238 ? "LN_MSG_CMD_STN_ROUTE_WRITE" : "LN_MSG_CMD_STN_ROUTE_REPORT", routeNum, turnoutGroup, turnoutGroup + 3, altRouteNum, altTurnoutGroup, altTurnoutGroup + 3, turnA, statA, turnB, statB, turnC, statC, turnD, statD);
                        }
                        return "routes unknown\n";
                    }
                    default: {
                        return Bundle.getMessage(l.getOpCode() == 238 ? "LN_MSG_ALM_WRITE" : "LN_MSG_ALM_WRITE_REPLY", l.getElement(2), l.getElement(3), LocoNetMessageInterpret.getAlmTaskType(l.getElement(3)), l.getElement(4), l.getElement(5), l.getElement(6), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(l.getElement(7))), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(l.getElement(8))), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(l.getElement(9))), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(l.getElement(10))), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(l.getElement(11))), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(l.getElement(12))), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(l.getElement(13))), Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(l.getElement(14))));
                    }
                }
            }
            if (l.getElement(1) == 21 && (result = LocoNetMessageInterpret.interpretExtendedSlotRdWr(l, slot = (l.getElement(2) & 7) * 128 + l.getElement(3))).length() > 0) {
                return result;
            }
        }
        return "";
    }

    private static String interpretOpcExpMoveSlots(LocoNetMessage l) {
        boolean isConsisting;
        boolean isUnconsisting;
        boolean isSettingStatus;
        int src = (l.getElement(1) & 3) * 128 + (l.getElement(2) & 0x7F);
        int dest = (l.getElement(3) & 3) * 128 + (l.getElement(4) & 0x7F);
        if (src >= 121 && src <= 127) {
            return "";
        }
        if (dest >= 121 && dest <= 127) {
            return "";
        }
        boolean bl = isSettingStatus = (l.getElement(3) & 0x70) == 96;
        if (isSettingStatus) {
            int stat = l.getElement(4);
            return Bundle.getMessage("LN_MSG_OPC_EXP_SET_STATUS", src, LnConstants.CONSIST_STAT(stat), LnConstants.LOCO_STAT(stat), LnConstants.DEC_MODE(stat));
        }
        boolean bl2 = isUnconsisting = (l.getElement(3) & 0x70) == 80;
        if (isUnconsisting) {
            return Bundle.getMessage("LN_MSG_OPC_EXP_UNCONSISTING", src);
        }
        boolean bl3 = isConsisting = (l.getElement(3) & 0x70) == 64;
        if (isConsisting) {
            return Bundle.getMessage("LN_MSG_OPC_EXP_CONSISTING", src, dest);
        }
        if (src == 0) {
            return Bundle.getMessage("LN_MSG_MOVE_SL_GET_DISP");
        }
        if (src == dest) {
            return Bundle.getMessage("LN_MSG_MOVE_SL_NULL_MOVE", src);
        }
        if (dest == 0) {
            return Bundle.getMessage("LN_MSG_MOVE_SL_DISPATCH_PUT", src);
        }
        return Bundle.getMessage("LN_MSG_MOVE_SL_MOVE", src, dest);
    }

    private static String interpretPocExpLocoSpdDirFunction(LocoNetMessage l) {
        int slot = (l.getElement(1) & 3) * 128 + (l.getElement(2) & 0x7F);
        if ((l.getElement(1) & 0xF0) == 0) {
            int spd = l.getElement(4);
            String direction = Bundle.getMessage((l.getElement(1) & 8) != 0 ? "LN_MSG_DIRECTION_REV" : "LN_MSG_DIRECTION_FWD");
            String throttleID = Integer.toHexString(l.getElement(3));
            return Bundle.getMessage("LN_MSG_OPC_EXP_SPEED_DIRECTION", slot, spd, direction, throttleID);
        }
        String[] fn = new String[8];
        int bitIndex = 0;
        while (bitIndex < 8) {
            fn[bitIndex] = (l.getElement(4) >> 7 - bitIndex & 1) == 1 ? Bundle.getMessage("LN_MSG_FUNC_ON") : Bundle.getMessage("LN_MSG_FUNC_OFF");
            ++bitIndex;
        }
        if ((l.getElement(1) & 0xF8) == 16) {
            return Bundle.getMessage("LN_MSG_OPC_EXP_FUNCTIONS_F0_F6", slot, fn[3], fn[7], fn[6], fn[5], fn[4], fn[2], fn[1]);
        }
        if ((l.getElement(1) & 0xF8) == 24) {
            return Bundle.getMessage("LN_MSG_OPC_EXP_FUNCTIONS_F7_F13", slot, fn[7], fn[6], fn[5], fn[4], fn[3], fn[2], fn[1]);
        }
        if ((l.getElement(1) & 0xF8) == 32) {
            return Bundle.getMessage("LN_MSG_OPC_EXP_FUNCTIONS_F14_F20", slot, fn[7], fn[6], fn[5], fn[4], fn[3], fn[2], fn[1]);
        }
        if ((l.getElement(1) & 0xF8) == 40) {
            return Bundle.getMessage("LN_MSG_OPC_EXP_FUNCTIONS_F21_F28", slot, fn[7], fn[6], fn[5], fn[4], fn[3], fn[2], fn[1], Bundle.getMessage("LN_MSG_FUNC_OFF"));
        }
        if ((l.getElement(1) & 0xF8) == 48) {
            return Bundle.getMessage("LN_MSG_OPC_EXP_FUNCTIONS_F21_F28", slot, fn[7], fn[6], fn[5], fn[4], fn[3], fn[2], fn[1], Bundle.getMessage("LN_MSG_FUNC_ON"));
        }
        return "";
    }

    private static String interpretExtendedSlotRdWr(LocoNetMessage l, int slot) {
        if (slot > 247 && slot < 252) {
            return LocoNetMessageInterpret.interpretExtendedSlot_StatusData(l, slot);
        }
        int trackStatus = l.getElement(7);
        int id1 = l.getElement(19);
        int id2 = l.getElement(18);
        int command = l.getOpCode();
        int stat = l.getElement(4);
        int adr = l.getElement(5);
        int spd = l.getElement(8);
        int dirf = l.getElement(10) & 0x3F;
        String[] dirf0_4 = LocoNetMessageInterpret.interpretF0_F4toStrings(dirf);
        int ss2 = l.getElement(18);
        int adr2 = l.getElement(6);
        int snd = l.getElement(10);
        String[] sndf5_8 = LocoNetMessageInterpret.interpretF5_F8toStrings(snd);
        String locoAdrStr = LocoNetMessageInterpret.figureAddressIncludingAliasing(adr, adr2, ss2, id1, id2);
        return Bundle.getMessage(command == 238 ? "LN_MSG_SLOT_LOCO_INFO_WRITE" : "LN_MSG_SLOT_LOCO_INFO_READ", slot, locoAdrStr, LnConstants.CONSIST_STAT(stat), LnConstants.LOCO_STAT(stat), LnConstants.DEC_MODE(stat), LocoNetMessageInterpret.directionOfTravelString((dirf & 0x20) == 0), spd, dirf0_4[0], dirf0_4[1], dirf0_4[2], dirf0_4[3], dirf0_4[4], sndf5_8[0], sndf5_8[1], sndf5_8[2], sndf5_8[3], LocoNetMessageInterpret.trackStatusByteToString(trackStatus), Bundle.getMessage("LN_MSG_SLOT_HELPER_SS2_SIMPLE", Bundle.getMessage("LN_MSG_HEXADECIMAL_REPRESENTATION", StringUtil.twoHexFromInt(ss2))), Bundle.getMessage("LN_MSG_SLOT_HELPER_ID1_ID2_AS_THROTTLE_ID", LocoNetMessageInterpret.idString(id1, id2)));
    }

    private static String interpretExtendedSlot_StatusData(LocoNetMessage l, int slot) {
        String baseInfo = "";
        String detailInfo = "";
        switch (slot) {
            case 248: {
                baseInfo = LocoNetMessageInterpret.interpretExtendedSlot_StatusData_Base_Detail(l, slot);
                detailInfo = LocoNetMessageInterpret.interpretExtendedSlot_StatusData_Flags(l, slot);
                break;
            }
            case 249: {
                baseInfo = LocoNetMessageInterpret.interpretExtendedSlot_StatusData_Base(l, slot);
                detailInfo = LocoNetMessageInterpret.interpretExtendedSlot_StatusData_Electric(l, slot);
                break;
            }
            case 251: {
                baseInfo = LocoNetMessageInterpret.interpretExtendedSlot_StatusData_Base(l, slot);
                detailInfo = LocoNetMessageInterpret.interpretExtendedSlot_StatusData_LocoNet(l, slot);
                break;
            }
            case 250: {
                baseInfo = LocoNetMessageInterpret.interpretExtendedSlot_StatusData_Base(l, slot);
                detailInfo = LocoNetMessageInterpret.interpretExtendedSlot_StatusData_Slots(l, slot);
                break;
            }
            default: {
                baseInfo = "Still working on it";
            }
        }
        return Bundle.getMessage("LN_MSG_OPC_EXP_SPECIALSTATUS", slot, baseInfo, detailInfo);
    }

    private static String interpretExtendedSlot_StatusData_Base(LocoNetMessage l, int slot) {
        String hwType = "";
        switch (l.getElement(16)) {
            case 28: {
                hwType = "DCS240";
                break;
            }
            case 27: {
                hwType = "DCS210";
                break;
            }
            case 52: {
                hwType = "DCS52";
                break;
            }
            case 88: {
                hwType = "BXP88";
                break;
            }
            case 81: {
                hwType = "BXPA1";
                break;
            }
            default: {
                hwType = "Unknown";
            }
        }
        int hwSerial = (l.getElement(19) & 0xF) * 128 + l.getElement(18);
        return Bundle.getMessage("LN_MSG_OPC_EXP_SPECIALSTATUS_BASE", hwType, hwSerial);
    }

    private static String interpretExtendedSlot_StatusData_Base_Detail(LocoNetMessage l, int slot) {
        String hwType;
        switch (l.getElement(14)) {
            case 28: {
                hwType = "DCS240";
                break;
            }
            case 27: {
                hwType = "DCS210";
                break;
            }
            case 88: {
                hwType = "BXP88";
                break;
            }
            case 81: {
                hwType = "BXPA1";
                break;
            }
            default: {
                hwType = "Unknown";
            }
        }
        int hwSerial = (l.getElement(19) & 0xF) * 128 + l.getElement(18);
        double hwVersion = (double)(l.getElement(17) & 0x78) / 8.0 + (double)(l.getElement(17) & 7) / 10.0;
        double swVersion = (double)(l.getElement(16) & 0x78) / 8.0 + (double)(l.getElement(16) & 7) / 10.0;
        return Bundle.getMessage("LN_MSG_OPC_EXP_SPECIALSTATUS_BASEDETAIL", hwType, hwSerial, hwVersion, swVersion);
    }

    private static String interpretExtendedSlot_StatusData_Electric(LocoNetMessage l, int slot) {
        double voltsTrack = (double)l.getElement(4) * 2.0 / 10.0;
        double voltsIn = (double)l.getElement(5) * 2.0 / 10.0;
        double ampsIn = (double)l.getElement(6) / 10.0;
        double ampsLimit = (double)l.getElement(7) / 10.0;
        double voltsRsLoaded = (double)l.getElement(12) * 2.0 / 10.0;
        double voltsRsUnLoaded = (double)l.getElement(10) * 2.0 / 10.0;
        return Bundle.getMessage("LN_MSG_OPC_EXP_SPECIALSTATUS_ELECTRIC", voltsTrack, voltsIn, ampsIn, ampsLimit, voltsRsLoaded, voltsRsUnLoaded);
    }

    private static String interpretExtendedSlot_StatusData_LocoNet(LocoNetMessage l, int slot) {
        double msgTotal = l.getElement(4) + l.getElement(5) * 128;
        double msgErrors = l.getElement(6) + l.getElement(7) * 128;
        return Bundle.getMessage("LN_MSG_OPC_EXP_SPECIALSTATUS_LOCONET", msgTotal, msgErrors);
    }

    private static String interpretExtendedSlot_StatusData_Flags(LocoNetMessage l, int slot) {
        return Bundle.getMessage("LN_MSG_OPC_EXP_SPECIALSTATUS_FLAGS");
    }

    private static String interpretExtendedSlot_StatusData_Slots(LocoNetMessage l, int slot) {
        double msgInUse = l.getElement(4) + l.getElement(5) * 128;
        double msgIdle = l.getElement(6) + l.getElement(7) * 128;
        double msgFree = l.getElement(8) + l.getElement(9) * 128;
        return Bundle.getMessage("LN_MSG_OPC_EXP_SPECIALSTATUS_SLOTS", msgInUse, msgIdle, msgFree);
    }
}

