/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.logixng.swing;

import java.awt.Color;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.expressions.swing.AbstractDigitalExpressionSwing;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.logixng.ExpressionSlotUsage;
import jmri.jmrix.loconet.logixng.swing.Bundle;
import jmri.jmrix.loconet.logixng.swing.GetNumSlotsDialog;

public class ExpressionSlotUsageSwing
extends AbstractDigitalExpressionSwing {
    private JButton _findNumSlotsButton;
    private JComboBox<LocoNetConnection> _locoNetConnection;
    private JTabbedPane _tabbedPane;
    private JPanel _simplePanel;
    private JPanel _advancedPanel;
    private JComboBox<ExpressionSlotUsage.Has_HasNot> _has_HasNot_ComboBox;
    private JComboBox<ExpressionSlotUsage.SimpleState> _simpleStateComboBox;
    private JCheckBox _inUseCheckBox;
    private JCheckBox _idleCheckBox;
    private JCheckBox _commonCheckBox;
    private JCheckBox _freeCheckBox;
    private JComboBox<ExpressionSlotUsage.Compare> _compareComboBox;
    private JTextField _numberField;
    private JComboBox<ExpressionSlotUsage.PercentPieces> _percentPiecesComboBox;
    private JTextField _totalSlotsField;
    private JPanel _slotsPanel;

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        Enum e2;
        if (object != null && !(object instanceof ExpressionSlotUsage)) {
            throw new IllegalArgumentException("object must be an ExpressionSlotUsage but is a: " + object.getClass().getName());
        }
        ExpressionSlotUsage expression = (ExpressionSlotUsage)object;
        this._slotsPanel = new JPanel();
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel queryPanel = new JPanel();
        queryPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel locoNetPanel = new JPanel();
        locoNetPanel.add(new JLabel(Bundle.getMessage("LocoNetConnection")));
        this._locoNetConnection = new JComboBox();
        List<LocoNetSystemConnectionMemo> systemConnections = InstanceManager.getList(LocoNetSystemConnectionMemo.class);
        for (LocoNetSystemConnectionMemo connection : systemConnections) {
            LocoNetConnection c = new LocoNetConnection(connection);
            this._locoNetConnection.addItem(c);
            if (expression == null || expression.getMemo() != connection) continue;
            this._locoNetConnection.setSelectedItem(c);
        }
        locoNetPanel.add(this._locoNetConnection);
        this._has_HasNot_ComboBox = new JComboBox();
        Enum[] enumArray = ExpressionSlotUsage.Has_HasNot.values();
        int c = enumArray.length;
        int n = 0;
        while (n < c) {
            e2 = enumArray[n];
            this._has_HasNot_ComboBox.addItem((ExpressionSlotUsage.Has_HasNot)e2);
            ++n;
        }
        this._simpleStateComboBox = new JComboBox();
        enumArray = ExpressionSlotUsage.SimpleState.values();
        c = enumArray.length;
        n = 0;
        while (n < c) {
            e2 = enumArray[n];
            this._simpleStateComboBox.addItem((ExpressionSlotUsage.SimpleState)e2);
            ++n;
        }
        this._tabbedPane = new JTabbedPane();
        this._simplePanel = new JPanel();
        this._advancedPanel = new JPanel();
        this._advancedPanel.setLayout(new BoxLayout(this._advancedPanel, 1));
        this._tabbedPane.addTab(Bundle.getMessage("TabbedPaneSimple"), this._simplePanel);
        this._tabbedPane.addTab(Bundle.getMessage("TabbedPaneAdvanced"), this._advancedPanel);
        this._simpleStateComboBox = new JComboBox();
        enumArray = ExpressionSlotUsage.SimpleState.values();
        c = enumArray.length;
        n = 0;
        while (n < c) {
            e2 = enumArray[n];
            this._simpleStateComboBox.addItem((ExpressionSlotUsage.SimpleState)e2);
            ++n;
        }
        this._simplePanel.add(this._simpleStateComboBox);
        this._inUseCheckBox = new JCheckBox(Bundle.getMessage("AdvancedStateType_InUse"));
        this._idleCheckBox = new JCheckBox(Bundle.getMessage("AdvancedStateType_Idle"));
        this._commonCheckBox = new JCheckBox(Bundle.getMessage("AdvancedStateType_Common"));
        this._freeCheckBox = new JCheckBox(Bundle.getMessage("AdvancedStateType_Free"));
        this._advancedPanel.add(this._inUseCheckBox);
        this._advancedPanel.add(this._idleCheckBox);
        this._advancedPanel.add(this._commonCheckBox);
        this._advancedPanel.add(this._freeCheckBox);
        this._compareComboBox = new JComboBox();
        enumArray = ExpressionSlotUsage.Compare.values();
        c = enumArray.length;
        n = 0;
        while (n < c) {
            e2 = enumArray[n];
            this._compareComboBox.addItem((ExpressionSlotUsage.Compare)e2);
            ++n;
        }
        NumberFormat format = NumberFormat.getInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(Integer.valueOf(0));
        formatter.setMaximum(Integer.valueOf(120));
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(true);
        this._numberField = new JFormattedTextField();
        this._numberField.setColumns(3);
        this._percentPiecesComboBox = new JComboBox();
        ExpressionSlotUsage.PercentPieces[] percentPiecesArray = ExpressionSlotUsage.PercentPieces.values();
        int n2 = percentPiecesArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ExpressionSlotUsage.PercentPieces e3 = percentPiecesArray[n3];
            this._percentPiecesComboBox.addItem(e3);
            ++n3;
        }
        if (expression != null) {
            if (expression.getAdvanced()) {
                this._tabbedPane.setSelectedComponent(this._advancedPanel);
            }
            if (expression.getAdvancedStates().contains((Object)ExpressionSlotUsage.AdvancedState.InUse)) {
                this._inUseCheckBox.setSelected(true);
            }
            if (expression.getAdvancedStates().contains((Object)ExpressionSlotUsage.AdvancedState.Idle)) {
                this._idleCheckBox.setSelected(true);
            }
            if (expression.getAdvancedStates().contains((Object)ExpressionSlotUsage.AdvancedState.Common)) {
                this._commonCheckBox.setSelected(true);
            }
            if (expression.getAdvancedStates().contains((Object)ExpressionSlotUsage.AdvancedState.Free)) {
                this._freeCheckBox.setSelected(true);
            }
            this._has_HasNot_ComboBox.setSelectedItem((Object)expression.get_Has_HasNot());
            this._simpleStateComboBox.setSelectedItem((Object)expression.getSimpleState());
            this._compareComboBox.setSelectedItem((Object)expression.getCompare());
            this._numberField.setText(Integer.toString(expression.getNumber()));
            this._percentPiecesComboBox.setSelectedItem((Object)expression.getPercentPieces());
        }
        this.panel.add(locoNetPanel);
        JComponent[] components = new JComponent[]{this._has_HasNot_ComboBox, this._tabbedPane, this._compareComboBox, this._numberField, this._percentPiecesComboBox};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ExpressionSlotUsage_Long"), components);
        for (JComponent c2 : componentList) {
            queryPanel.add(c2);
        }
        this.panel.add(queryPanel);
        this._slotsPanel.setLayout(new BoxLayout(this._slotsPanel, 1));
        this._slotsPanel.add(new JLabel(Bundle.getMessage("InfoTotalSlots1")));
        this._slotsPanel.add(new JLabel(Bundle.getMessage("InfoTotalSlots2")));
        this._slotsPanel.add(new JLabel(Bundle.getMessage("InfoTotalSlots3")));
        JPanel numSlotsPanel = new JPanel();
        numSlotsPanel.add(new JLabel(Bundle.getMessage("TotalNumSlots")));
        format = NumberFormat.getInstance();
        formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(Integer.valueOf(0));
        formatter.setMaximum(Integer.valueOf(120));
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(true);
        this._totalSlotsField = new JFormattedTextField();
        this._totalSlotsField.setColumns(3);
        numSlotsPanel.add(this._totalSlotsField);
        this._findNumSlotsButton = new JButton(Bundle.getMessage("GetNumSlots"));
        this._findNumSlotsButton.addActionListener(e -> {
            LocoNetSystemConnectionMemo memo = this._locoNetConnection.getItemAt(this._locoNetConnection.getSelectedIndex())._memo;
            new GetNumSlotsDialog(memo, this._totalSlotsField).initComponents();
        });
        numSlotsPanel.add(this._findNumSlotsButton);
        if (expression != null) {
            this._totalSlotsField.setText(Integer.toString(expression.getTotalSlots()));
        }
        this._slotsPanel.add(numSlotsPanel);
        this.panel.add(this._slotsPanel);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        try {
            Integer.parseInt(this._numberField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            errorMessages.add("Number is not a valid integer");
            return false;
        }
        return true;
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        LocoNetSystemConnectionMemo memo = this._locoNetConnection.getItemAt(this._locoNetConnection.getSelectedIndex())._memo;
        ExpressionSlotUsage expression = new ExpressionSlotUsage(systemName, userName, memo);
        this.updateObject(expression);
        return InstanceManager.getDefault(DigitalExpressionManager.class).registerExpression(expression);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ExpressionSlotUsage)) {
            throw new IllegalArgumentException("object must be an ExpressionTurnout but is a: " + object.getClass().getName());
        }
        ExpressionSlotUsage expression = (ExpressionSlotUsage)object;
        expression.setMemo(this._locoNetConnection.getItemAt(this._locoNetConnection.getSelectedIndex())._memo);
        expression.setAdvanced(this._tabbedPane.getSelectedComponent() == this._advancedPanel);
        HashSet<ExpressionSlotUsage.AdvancedState> advancedStates = new HashSet<ExpressionSlotUsage.AdvancedState>();
        if (this._inUseCheckBox.isSelected()) {
            advancedStates.add(ExpressionSlotUsage.AdvancedState.InUse);
        }
        if (this._idleCheckBox.isSelected()) {
            advancedStates.add(ExpressionSlotUsage.AdvancedState.Idle);
        }
        if (this._commonCheckBox.isSelected()) {
            advancedStates.add(ExpressionSlotUsage.AdvancedState.Common);
        }
        if (this._freeCheckBox.isSelected()) {
            advancedStates.add(ExpressionSlotUsage.AdvancedState.Free);
        }
        expression.setAdvancedStates(advancedStates);
        expression.set_Has_HasNot(this._has_HasNot_ComboBox.getItemAt(this._has_HasNot_ComboBox.getSelectedIndex()));
        expression.setSimpleState(this._simpleStateComboBox.getItemAt(this._simpleStateComboBox.getSelectedIndex()));
        expression.setCompare(this._compareComboBox.getItemAt(this._compareComboBox.getSelectedIndex()));
        expression.setNumber(Integer.parseInt(this._numberField.getText()));
        expression.setPercentPieces(this._percentPiecesComboBox.getItemAt(this._percentPiecesComboBox.getSelectedIndex()));
        expression.setTotalSlots(Integer.parseInt(this._totalSlotsField.getText()));
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ExpressionSlotUsage_Short");
    }

    @Override
    public void dispose() {
    }

    private static class LocoNetConnection {
        private LocoNetSystemConnectionMemo _memo;

        public LocoNetConnection(LocoNetSystemConnectionMemo memo) {
            this._memo = memo;
        }

        public String toString() {
            return this._memo.getUserName();
        }
    }
}

