/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.logixng;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.expressions.AbstractDigitalExpression;
import jmri.jmrix.loconet.LocoNetSlot;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.SlotListener;
import jmri.jmrix.loconet.SlotManager;
import jmri.jmrix.loconet.logixng.Bundle;
import jmri.jmrix.loconet.logixng.CategoryLocoNet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionSlotUsage
extends AbstractDigitalExpression
implements SlotListener {
    private static final int MAX_NUM_LOCO_SLOTS = 119;
    private LocoNetSystemConnectionMemo _memo;
    private boolean _advanced = false;
    private Has_HasNot _hasHasNot = Has_HasNot.Has;
    private SimpleState _simpleState = SimpleState.InUse;
    private final Set<AdvancedState> _advancedStates = new HashSet<AdvancedState>();
    private Compare _compare = Compare.LessThan;
    private int _number = 0;
    private PercentPieces _percentPieces = PercentPieces.Pieces;
    private int _totalSlots = 0;
    private static final Logger log = LoggerFactory.getLogger(ExpressionSlotUsage.class);

    public ExpressionSlotUsage(String sys, String user, LocoNetSystemConnectionMemo memo) {
        super(sys, user);
        this._memo = memo;
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalExpressionManager manager = InstanceManager.getDefault(DigitalExpressionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ExpressionSlotUsage copy = new ExpressionSlotUsage(sysName, userName, this._memo);
        copy.setAdvanced(this._advanced);
        copy.set_Has_HasNot(this._hasHasNot);
        copy.setSimpleState(this._simpleState);
        copy.setAdvancedStates(this._advancedStates);
        copy.setCompare(this._compare);
        copy.setNumber(this._number);
        copy.setPercentPieces(this._percentPieces);
        copy.setTotalSlots(this._totalSlots);
        return manager.registerExpression(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return CategoryLocoNet.LOCONET;
    }

    public void setMemo(LocoNetSystemConnectionMemo memo) {
        this.assertListenersAreNotRegistered(log, "setMemo");
        this._memo = memo;
    }

    public LocoNetSystemConnectionMemo getMemo() {
        return this._memo;
    }

    public void setAdvanced(boolean advanced) {
        this.assertListenersAreNotRegistered(log, "setAdvanced");
        this._advanced = advanced;
    }

    public boolean getAdvanced() {
        return this._advanced;
    }

    public void set_Has_HasNot(Has_HasNot hasHasNot) {
        this.assertListenersAreNotRegistered(log, "set_Has_HasNot");
        this._hasHasNot = hasHasNot;
    }

    public Has_HasNot get_Has_HasNot() {
        return this._hasHasNot;
    }

    public void setSimpleState(SimpleState simpleState) {
        this.assertListenersAreNotRegistered(log, "setSimpleState");
        this._simpleState = simpleState;
    }

    public SimpleState getSimpleState() {
        return this._simpleState;
    }

    public void setAdvancedStates(Set<AdvancedState> states) {
        this.assertListenersAreNotRegistered(log, "setAdvancedStates");
        this._advancedStates.clear();
        this._advancedStates.addAll(states);
    }

    public Set<AdvancedState> getAdvancedStates() {
        return Collections.unmodifiableSet(this._advancedStates);
    }

    public void setCompare(Compare compare) {
        this.assertListenersAreNotRegistered(log, "setCompare");
        this._compare = compare;
    }

    public Compare getCompare() {
        return this._compare;
    }

    public void setNumber(int number) {
        this.assertListenersAreNotRegistered(log, "setNumber");
        this._number = number;
    }

    public int getNumber() {
        return this._number;
    }

    public void setTotalSlots(int totalNumber) {
        this.assertListenersAreNotRegistered(log, "setTotalNumber");
        this._totalSlots = totalNumber;
    }

    public int getTotalSlots() {
        return this._totalSlots;
    }

    public void setPercentPieces(PercentPieces percentPieces) {
        this.assertListenersAreNotRegistered(log, "setPercentPieces");
        this._percentPieces = percentPieces;
    }

    public PercentPieces getPercentPieces() {
        return this._percentPieces;
    }

    private int getNumWithStatus() {
        if (this._memo == null) {
            return 0;
        }
        int count = 0;
        int i = 1;
        while (i <= 119) {
            boolean match = false;
            LocoNetSlot slot = this._memo.getSlotManager().slot(i);
            if (this._advanced) {
                for (AdvancedState s : this._advancedStates) {
                    if (s._state != slot.slotStatus()) continue;
                    match = true;
                }
            } else if (this._simpleState.matches(slot.slotStatus())) {
                match = true;
            }
            if (this._hasHasNot == Has_HasNot.Has) {
                if (match) {
                    ++count;
                }
            } else if (!match) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public boolean evaluate() {
        int count = this.getNumWithStatus();
        int compareToNum = this._percentPieces == PercentPieces.Percent ? Math.round((float)this._number / 100.0f * (float)this._totalSlots) : this._number;
        return this._compare.compare(count, compareToNum);
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ExpressionSlotUsage_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String stateStr;
        if (this._advanced) {
            StringBuilder states = new StringBuilder();
            for (AdvancedState state : this._advancedStates) {
                if (states.length() > 0) {
                    states.append(",");
                }
                states.append(state._text);
            }
            stateStr = states.length() > 0 ? states.toString() : Bundle.getMessage("NoState");
        } else {
            stateStr = this._simpleState._text;
        }
        return Bundle.getMessage(locale, "ExpressionSlotUsage_LongConnection", this._hasHasNot.toString(), stateStr, this._compare.toString(), this._number, this._percentPieces.toString(), this._memo != null ? this._memo.getUserName() : Bundle.getMessage("MemoNotSet"));
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._listenersAreRegistered = true;
            if (this._memo != null) {
                SlotManager slotManager = this._memo.getSlotManager();
                slotManager.addSlotListener(this);
            }
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._memo != null) {
            SlotManager slotManager = this._memo.getSlotManager();
            slotManager.removeSlotListener(this);
        }
        this._listenersAreRegistered = false;
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void notifyChangedSlot(LocoNetSlot s) {
        if (this._listenersAreRegistered) {
            this.getConditionalNG().execute();
        }
    }

    public static enum AdvancedState {
        InUse(48, Bundle.getMessage("AdvancedStateType_InUse")),
        Idle(32, Bundle.getMessage("AdvancedStateType_Idle")),
        Common(16, Bundle.getMessage("AdvancedStateType_Common")),
        Free(0, Bundle.getMessage("AdvancedStateType_Free"));

        private final int _state;
        private final String _text;

        private AdvancedState(int state, String text) {
            this._state = state;
            this._text = text;
        }

        public int getState() {
            return this._state;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum Compare {
        LessThan(Bundle.getMessage("CompareType_LessThan"), (a, b) -> a < b),
        LessThanOrEqual(Bundle.getMessage("CompareType_LessThanOrEqual"), (a, b) -> a <= b),
        Equal(Bundle.getMessage("CompareType_Equal"), (a, b) -> a == b),
        NotEqual(Bundle.getMessage("CompareType_NotEqual"), (a, b) -> a != b),
        GreaterThanOrEqual(Bundle.getMessage("CompareType_GreaterThanOrEqual"), (a, b) -> a >= b),
        GreaterThan(Bundle.getMessage("CompareType_GreaterThan"), (a, b) -> a > b);

        private final String _text;
        private final CompareIntegers _compare;

        private Compare(String text, CompareIntegers compare) {
            this._text = text;
            this._compare = compare;
        }

        public String toString() {
            return this._text;
        }

        public boolean compare(int a, int b) {
            return this._compare.compare(a, b);
        }
    }

    private static interface CompareIntegers {
        public boolean compare(int var1, int var2);
    }

    public static enum Has_HasNot {
        Has(Bundle.getMessage("HasHasNotType_Has")),
        HasNot(Bundle.getMessage("HasHasNotType_HasNot"));

        private final String _text;

        private Has_HasNot(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum PercentPieces {
        Percent(Bundle.getMessage("PercentPiecesType_Percent")),
        Pieces(Bundle.getMessage("PercentPiecesType_Pieces"));

        private final String _text;

        private PercentPieces(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum SimpleState {
        InUse(Bundle.getMessage("SimpleStateType_InUse"), new int[]{48}),
        Free(Bundle.getMessage("SimpleStateType_Free"), new int[1]);

        private final String _text;
        private final int[] _states;

        private SimpleState(String text, int[] states) {
            this._text = text;
            this._states = states;
        }

        public String toString() {
            return this._text;
        }

        public int[] getStates() {
            return this._states;
        }

        public boolean matches(int state) {
            int[] nArray = this._states;
            int n = this._states.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                if (s == state) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

