/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locostats.swing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.locostats.LocoBufferIIStatus;
import jmri.jmrix.loconet.locostats.LocoNetInterfaceStatsListener;
import jmri.jmrix.loconet.locostats.LocoStatsFunc;
import jmri.jmrix.loconet.locostats.PR2Status;
import jmri.jmrix.loconet.locostats.PR3MS100ModeStatus;
import jmri.jmrix.loconet.locostats.RawStatus;
import jmri.jmrix.loconet.locostats.swing.Bundle;
import jmri.jmrix.loconet.swing.LnNamedPaneAction;
import jmri.jmrix.loconet.swing.LnPanel;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoStatsPanel
extends LnPanel
implements LocoNetInterfaceStatsListener {
    JPanel lb2Panel;
    JPanel rawPanel;
    JPanel pr2Panel;
    JPanel ms100Panel;
    boolean updateRequestPending = false;
    LocoStatsFunc stats;
    JTextField r1 = new JTextField(5);
    JTextField r2 = new JTextField(5);
    JTextField r3 = new JTextField(5);
    JTextField r4 = new JTextField(5);
    JTextField r5 = new JTextField(5);
    JTextField r6 = new JTextField(5);
    JTextField r7 = new JTextField(5);
    JTextField r8 = new JTextField(5);
    JTextField serial = new JTextField(6);
    JTextField status = new JTextField(5);
    JTextField current = new JTextField(4);
    JTextField hardware = new JTextField(2);
    JTextField software = new JTextField(3);
    JTextField goodMsgCnt = new JTextField(5);
    JTextField badMsgCnt = new JTextField(5);
    JTextField ms100status = new JTextField(6);
    JTextField version = new JTextField(8);
    JTextField breaks = new JTextField(6);
    JTextField errors = new JTextField(6);
    JButton updateButton = new JButton(Bundle.getMessage("ButtonTextUpdate"));
    private static final Logger log = LoggerFactory.getLogger(LocoStatsPanel.class);

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.locostats.LocoStatsFrame";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("MenuItemLocoStats"));
    }

    @Override
    public void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.rawPanel = new JPanel();
        this.rawPanel.setLayout(new BoxLayout(this.rawPanel, 0));
        this.rawPanel.add(new JLabel(Bundle.getMessage("LabelRawData")));
        this.rawPanel.add(this.r1);
        this.rawPanel.add(this.r2);
        this.rawPanel.add(this.r3);
        this.rawPanel.add(this.r4);
        this.rawPanel.add(this.r5);
        this.rawPanel.add(this.r6);
        this.rawPanel.add(this.r7);
        this.rawPanel.add(this.r8);
        this.lb2Panel = new JPanel();
        this.lb2Panel.setLayout(new BoxLayout(this.lb2Panel, 0));
        this.lb2Panel.add(new JLabel(Bundle.getMessage("LabelVersion")));
        this.lb2Panel.add(this.version);
        this.lb2Panel.add(new JLabel(Bundle.getMessage("LabelBreaks")));
        this.breaks.setPreferredSize(this.version.getPreferredSize());
        this.lb2Panel.add(this.breaks);
        this.lb2Panel.add(new JLabel(Bundle.getMessage("LabelErrors")));
        this.errors.setPreferredSize(this.version.getPreferredSize());
        this.lb2Panel.add(this.errors);
        this.pr2Panel = new JPanel();
        this.pr2Panel.setLayout(new BoxLayout(this.pr2Panel, 0));
        this.pr2Panel.add(new JLabel(Bundle.getMessage("LabelSerialNumber")));
        this.pr2Panel.add(this.serial);
        this.pr2Panel.add(new JLabel(Bundle.getMessage("LabelPR2Status")));
        this.pr2Panel.add(this.status);
        this.pr2Panel.add(new JLabel(Bundle.getMessage("LabelCurrent")));
        this.pr2Panel.add(this.current);
        this.pr2Panel.add(new JLabel(Bundle.getMessage("LabelHardwareVersion")));
        this.pr2Panel.add(this.hardware);
        this.pr2Panel.add(new JLabel(Bundle.getMessage("LabelSoftwareVersion")));
        this.pr2Panel.add(this.software);
        this.ms100Panel = new JPanel();
        this.ms100Panel.setLayout(new BoxLayout(this.ms100Panel, 0));
        this.ms100Panel.add(new JLabel(Bundle.getMessage("LabelGoodCnt")));
        this.ms100Panel.add(this.goodMsgCnt);
        this.ms100Panel.add(new JLabel(Bundle.getMessage("LabelBadCnt")));
        this.ms100Panel.add(this.badMsgCnt);
        this.ms100Panel.add(new JLabel(Bundle.getMessage("LabelMS100Status")));
        this.ms100Panel.add(this.ms100status);
        this.add(this.rawPanel);
        this.add(this.lb2Panel);
        this.add(this.pr2Panel);
        this.add(this.ms100Panel);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.add(this.updateButton);
        this.add(panel);
        this.updateButton.addActionListener(a -> this.requestUpdate());
        this.lb2Panel.setVisible(false);
        this.rawPanel.setVisible(true);
        this.pr2Panel.setVisible(false);
        this.ms100Panel.setVisible(false);
        this.revalidate();
    }

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.stats = new LocoStatsFunc(memo);
        this.stats.addLocoNetInterfaceStatsListener(this);
        this.requestUpdate();
    }

    @Override
    public void dispose() {
        this.stats.removeLocoNetInterfaceStatsListener(this);
    }

    public void requestUpdate() {
        ThreadingUtil.runOnLayoutEventually(() -> this.stats.sendLocoNetInterfaceStatusQueryMessage());
        this.updateRequestPending = true;
        log.debug("Sending a ping");
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="GUI elements are created such that cast to JmriJFrame this is accurate")
    public void notifyChangedInterfaceStatus(Object o) {
        log.debug("Update is being handled:{}", (Object)o.toString());
        if (!this.updateRequestPending) {
            return;
        }
        if (o.getClass() == LocoBufferIIStatus.class) {
            LocoBufferIIStatus s = (LocoBufferIIStatus)o;
            this.version.setText(Integer.toHexString(s.version));
            this.breaks.setText(Integer.toString(s.breaks));
            this.errors.setText(Integer.toString(s.errors));
            this.lb2Panel.setVisible(true);
            this.rawPanel.setVisible(false);
            this.ms100Panel.setVisible(false);
            this.pr2Panel.setVisible(false);
            ((JmriJFrame)this.getRootPane().getParent()).setPreferredSize(null);
            ((JmriJFrame)this.getRootPane().getParent()).pack();
        } else if (o.getClass() == PR2Status.class) {
            PR2Status s = (PR2Status)o;
            this.serial.setText(Integer.toString(s.serial));
            this.status.setText(Integer.toString(s.status));
            this.current.setText(Integer.toString(s.current));
            this.hardware.setText(Integer.toString(s.hardware));
            this.software.setText(Integer.toString(s.software));
            this.lb2Panel.setVisible(false);
            this.rawPanel.setVisible(false);
            this.ms100Panel.setVisible(true);
            this.pr2Panel.setVisible(true);
            ((JmriJFrame)this.getRootPane().getParent()).setPreferredSize(null);
            ((JmriJFrame)this.getRootPane().getParent()).pack();
        } else if (o.getClass() == PR3MS100ModeStatus.class) {
            PR3MS100ModeStatus s = (PR3MS100ModeStatus)o;
            this.goodMsgCnt.setText(Integer.toString(s.goodMsgCnt));
            this.badMsgCnt.setText(Integer.toString(s.badMsgCnt));
            this.ms100status.setText(Integer.toString(s.ms100status));
            this.lb2Panel.setVisible(false);
            this.rawPanel.setVisible(false);
            this.ms100Panel.setVisible(true);
            this.pr2Panel.setVisible(true);
            ((JmriJFrame)this.getRootPane().getParent()).setPreferredSize(null);
            ((JmriJFrame)this.getRootPane().getParent()).pack();
        } else if (o.getClass() == RawStatus.class) {
            RawStatus s = (RawStatus)o;
            this.r1.setText(Integer.toString(s.raw[0]));
            this.r2.setText(Integer.toString(s.raw[1]));
            this.r3.setText(Integer.toString(s.raw[2]));
            this.r4.setText(Integer.toString(s.raw[3]));
            this.r5.setText(Integer.toString(s.raw[4]));
            this.r6.setText(Integer.toString(s.raw[5]));
            this.r7.setText(Integer.toString(s.raw[6]));
            this.r8.setText(Integer.toString(s.raw[7]));
            this.lb2Panel.setVisible(false);
            this.rawPanel.setVisible(true);
            this.ms100Panel.setVisible(false);
            this.pr2Panel.setVisible(false);
            ((JmriJFrame)this.getRootPane().getParent()).setPreferredSize(null);
            ((JmriJFrame)this.getRootPane().getParent()).pack();
        }
    }

    @Deprecated
    public static class Default
    extends LnNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemLocoStats"), new JmriJFrameInterface(), LocoStatsPanel.class.getName(), InstanceManager.getDefault(LocoNetSystemConnectionMemo.class));
        }
    }
}

