/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locormi.configurexml;

import javax.swing.JFrame;
import javax.swing.JLabel;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.configurexml.AbstractSerialConnectionConfigXml;
import jmri.jmrix.loconet.LocoNetException;
import jmri.jmrix.loconet.locormi.LnMessageClient;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfigXml
extends AbstractSerialConnectionConfigXml {
    boolean connected = false;
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfigXml.class);

    @Override
    protected void getInstance() {
        log.error("unexpected call to getInstance", (Throwable)new Exception());
    }

    @Override
    public Element store(Object o) {
        jmri.jmrix.loconet.locormi.ConnectionConfig c = (jmri.jmrix.loconet.locormi.ConnectionConfig)o;
        Element e = new Element("connection");
        e.setAttribute("manufacturer", c.getManufacturer());
        e.setAttribute("port", c.host.getText());
        if (c.getLnMessageClient() != null) {
            if (c.getLnMessageClient().getAdapterMemo() != null) {
                e.setAttribute("userName", c.getLnMessageClient().getAdapterMemo().getUserName());
                e.setAttribute("systemPrefix", c.getLnMessageClient().getAdapterMemo().getSystemPrefix());
            }
            if (c.getDisabled()) {
                e.setAttribute("disabled", "yes");
            } else {
                e.setAttribute("disabled", "no");
            }
        }
        e.setAttribute("class", this.getClass().getName());
        return e;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        String yesno;
        boolean result = true;
        String hostName = shared.getAttribute("port").getValue();
        String manufacturer = null;
        try {
            manufacturer = shared.getAttribute("manufacturer").getValue();
        }
        catch (NullPointerException nullPointerException) {}
        jmri.jmrix.loconet.locormi.ConnectionConfig cc = new jmri.jmrix.loconet.locormi.ConnectionConfig(hostName, manufacturer);
        LnMessageClient client = new LnMessageClient();
        cc.setLnMessageClient(client);
        if (shared.getAttribute("disabled") != null && (yesno = shared.getAttribute("disabled").getValue()) != null && !yesno.equals("")) {
            if (yesno.equals("no")) {
                cc.setDisabled(false);
            } else if (yesno.equals("yes")) {
                cc.setDisabled(true);
            }
        }
        if (client.getAdapterMemo() != null) {
            if (shared.getAttribute("userName") != null) {
                client.getAdapterMemo().setUserName(shared.getAttribute("userName").getValue());
            }
            if (shared.getAttribute("systemPrefix") != null) {
                client.getAdapterMemo().setSystemPrefix(shared.getAttribute("systemPrefix").getValue());
            }
        }
        if (!cc.getDisabled()) {
            JFrame f = new JFrame("LocoNet server connection");
            f.getContentPane().add(new JLabel("Connecting to " + hostName));
            f.pack();
            f.setVisible(true);
            try {
                client.configureRemoteConnection(hostName, 500);
                this.connected = true;
            }
            catch (LocoNetException ex) {
                log.error("Error opening connection to {} was: {}", (Object)hostName, (Object)ex);
                f.setTitle("Server connection failed");
                f.getContentPane().removeAll();
                f.getContentPane().add(new JLabel("failed, error was " + ex));
                f.pack();
                ConnectionStatus.instance().setConnectionState(null, cc.getInfo(), "Not Connected");
                this.connected = false;
                result = false;
            }
            if (this.connected) {
                ConnectionStatus.instance().setConnectionState(null, cc.getInfo(), "Connected");
                client.configureLocalServices();
                f.setVisible(false);
                f.dispose();
            }
        }
        this.register(cc);
        return result;
    }

    @Override
    protected void register() {
        log.error("unexpected call to register()", (Throwable)new Exception());
    }

    @Override
    protected void register(ConnectionConfig cc) {
        super.register(cc);
    }
}

