/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locormi;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.locormi.LnMessageBuffer;
import jmri.jmrix.loconet.locormi.LnMessageBufferInterface;
import jmri.jmrix.loconet.locormi.LnMessageServerInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnMessageServer
extends UnicastRemoteObject
implements LnMessageServerInterface {
    static final long serialVersionUID = 8934498417916438203L;
    private static LnMessageServer self = null;
    static final String serviceName = "LocoNetServer";
    private static final Logger log = LoggerFactory.getLogger(LnMessageServer.class);

    private LnMessageServer() throws RemoteException {
    }

    @Override
    public LnMessageBufferInterface getMessageBuffer(LnTrafficController tc) throws RemoteException {
        return new LnMessageBuffer(tc);
    }

    public static synchronized LnMessageServer getInstance() throws RemoteException {
        if (self == null) {
            self = new LnMessageServer();
        }
        return self;
    }

    public synchronized void enable() {
        Registry localRegistry = null;
        try {
            log.debug("Create RMI Registry for: {}", (Object)serviceName);
            localRegistry = LocateRegistry.createRegistry(1099);
        }
        catch (RemoteException remoteException) {}
        try {
            if (localRegistry == null) {
                log.warn("Could not Create RMI Registry, Attempting to Locate existing Registry for: {}", (Object)serviceName);
                localRegistry = LocateRegistry.getRegistry(1099);
            }
            log.debug("Register LocoNet Server: {} with RMI Registry", (Object)serviceName);
            localRegistry.rebind(serviceName, self);
            log.debug("Register LocoNet Server Complete");
        }
        catch (Exception ex) {
            log.warn("LnMessageServer: {}", (Throwable)ex);
        }
    }

    public synchronized void disable() {
        try {
            Naming.unbind(serviceName);
        }
        catch (Exception ex) {
            log.error("Exception during disable: {}", (Throwable)ex);
        }
    }
}

