/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locormi;

import javax.annotation.Nonnull;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.locormi.LnMessageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LnMessageClientPollThread
extends Thread {
    LnMessageClient parent = null;
    private static final Logger log = LoggerFactory.getLogger(LnMessageClientPollThread.class);

    LnMessageClientPollThread(@Nonnull LnMessageClient lnParent) {
        this.parent = lnParent;
        this.setDaemon(true);
        this.setName("LnMessageClientPollThread " + lnParent);
        this.start();
    }

    @Override
    public void run() {
        try {
            Object[] lnMessages = null;
            while (!Thread.interrupted()) {
                if (this.parent.lnMessageBuffer == null) {
                    return;
                }
                lnMessages = this.parent.lnMessageBuffer.getMessages(this.parent.pollTimeout);
                if (lnMessages == null) continue;
                log.debug("Received Message Array Size: {}", (Object)lnMessages.length);
                int lnMessageIndex = 0;
                while (lnMessageIndex < lnMessages.length) {
                    LocoNetMessage message = (LocoNetMessage)lnMessages[lnMessageIndex];
                    this.parent.message(message);
                    ++lnMessageIndex;
                }
            }
        }
        catch (Exception ex) {
            log.warn("Exception: ", (Throwable)ex);
        }
    }
}

