/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locormi;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import jmri.SystemConnectionMemo;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LnTrafficRouter;
import jmri.jmrix.loconet.LocoNetException;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.locormi.LnMessageBufferInterface;
import jmri.jmrix.loconet.locormi.LnMessageClientPollThread;
import jmri.jmrix.loconet.locormi.LnMessageServerInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnMessageClient
extends LnTrafficRouter {
    String serverName = null;
    int pollTimeout;
    LnMessageServerInterface lnServer = null;
    LnMessageBufferInterface lnMessageBuffer = null;
    LnMessageClientPollThread pollThread = null;
    LocoNetSystemConnectionMemo clientMemo = new LocoNetSystemConnectionMemo();
    private static final Logger log = LoggerFactory.getLogger(LnMessageClient.class);

    public LnMessageClient() {
        super(new LocoNetSystemConnectionMemo());
    }

    @Override
    public void sendLocoNetMessage(LocoNetMessage m) {
        ++this.transmittedMsgCount;
        try {
            if (this.lnMessageBuffer != null) {
                this.lnMessageBuffer.sendLocoNetMessage(m);
            } else {
                log.warn("sendLocoNetMessage: no connection to server");
            }
        }
        catch (RemoteException ex) {
            log.warn("sendLocoNetMessage: Exception: ", (Throwable)ex);
        }
    }

    public void configureRemoteConnection(String remoteHostName, int timeoutSec) throws LocoNetException {
        this.serverName = remoteHostName;
        this.pollTimeout = timeoutSec * 1000;
        log.debug("configureRemoteConnection: {} {}", (Object)remoteHostName, (Object)timeoutSec);
        try {
            log.debug("set interface to //{}//{}", (Object)remoteHostName, (Object)"LocoNetServer");
            LnMessageServerInterface lnServer = (LnMessageServerInterface)Naming.lookup("//" + this.serverName + "/" + "LocoNetServer");
            this.lnMessageBuffer = lnServer.getMessageBuffer(this.clientMemo.getLnTrafficController());
            this.lnMessageBuffer.enable(0);
            this.pollThread = new LnMessageClientPollThread(this);
        }
        catch (MalformedURLException | NotBoundException | RemoteException ex) {
            log.error("Exception while trying to connect: ", (Throwable)ex);
            throw new LocoNetException("Failed to Connect to Server: " + this.serverName);
        }
    }

    public void configureLocalServices() {
        this.clientMemo.setLnTrafficController(this);
        this.clientMemo.configureCommandStation(LnCommandStationType.COMMAND_STATION_DCS100, false, false, false);
        this.clientMemo.configureManagers();
    }

    public SystemConnectionMemo getAdapterMemo() {
        return this.clientMemo;
    }
}

