/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locormi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.LinkedList;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.locormi.LnMessageBufferInterface;

public class LnMessageBuffer
extends UnicastRemoteObject
implements LnMessageBufferInterface,
LocoNetListener {
    LinkedList<LocoNetMessage> messageList = null;
    LnTrafficController tc;

    public LnMessageBuffer(LnTrafficController _tc) throws RemoteException {
        this.tc = _tc;
    }

    @Override
    public void enable(int mask) throws RemoteException {
        if (this.messageList == null) {
            this.messageList = new LinkedList();
        }
        this.tc.addLocoNetListener(mask, this);
    }

    @Override
    public void disable(int mask) throws RemoteException {
        this.tc.removeLocoNetListener(mask, this);
    }

    @Override
    public void clear() throws RemoteException {
        this.messageList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(LocoNetMessage msg) {
        LinkedList<LocoNetMessage> linkedList = this.messageList;
        synchronized (linkedList) {
            this.messageList.add(msg);
            this.messageList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getMessages(long timeout) {
        Object[] messagesArray = null;
        LinkedList<LocoNetMessage> linkedList = this.messageList;
        synchronized (linkedList) {
            if (this.messageList.size() == 0) {
                try {
                    this.messageList.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.messageList.size() > 0) {
                messagesArray = this.messageList.toArray();
                this.messageList.clear();
            }
        }
        return messagesArray;
    }

    @Override
    public void sendLocoNetMessage(LocoNetMessage m) {
        this.tc.sendLocoNetMessage(m);
    }
}

