/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locormi;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.AbstractSerialConnectionConfig;
import jmri.jmrix.loconet.locormi.LnMessageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfig
extends AbstractSerialConnectionConfig {
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfig.class);
    public JTextField host;
    String hostName = "";
    LnMessageClient lmc;
    String manufacturerName = "Digitrax";
    boolean disabled = false;

    public ConnectionConfig(String p, String m) {
        this.hostName = p;
        if (m != null) {
            this.manufacturerName = m;
        }
    }

    public ConnectionConfig() {
    }

    @Override
    public String name() {
        return "LocoNet Server";
    }

    @Override
    public String getConnectionName() {
        if (this.lmc != null && this.lmc.getAdapterMemo() != null) {
            return this.lmc.getAdapterMemo().getUserName();
        }
        return this.name();
    }

    @Override
    public String getInfo() {
        return this.hostName;
    }

    public void setLnMessageClient(LnMessageClient ln) {
        this.lmc = ln;
    }

    public LnMessageClient getLnMessageClient() {
        return this.lmc;
    }

    @Override
    public void loadDetails(JPanel details) {
        details.add(new JLabel("Server hostname:"));
        this.host = new JTextField(20);
        this.host.setText(this.hostName);
        details.add(this.host);
    }

    public boolean isOptList2Advanced() {
        return false;
    }

    @Override
    protected void setInstance() {
        log.warn("Unexpected call to setInstance, multi-replica capability not yet present");
    }

    @Override
    public String getManufacturer() {
        return this.manufacturerName;
    }

    @Override
    public void setManufacturer(String manu) {
        this.manufacturerName = manu;
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (this.lmc != null && this.lmc.getAdapterMemo() != null) {
            this.lmc.getAdapterMemo().setDisabled(disabled);
        }
    }
}

