/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.loconetovertcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.loconetovertcp.ClientRxHandler;
import jmri.jmrix.loconet.loconetovertcp.LnTcpPreferences;
import jmri.jmrix.loconet.loconetovertcp.LnTcpServerListener;
import jmri.util.zeroconf.ZeroConfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnTcpServer {
    private final List<ClientRxHandler> clients = new LinkedList<ClientRxHandler>();
    private Thread socketListener;
    private ServerSocket serverSocket;
    private final List<LnTcpServerListener> stateListeners = new ArrayList<LnTcpServerListener>();
    private boolean settingsChanged = false;
    private final Runnable shutDownTask = this::disable;
    private ZeroConfService service = null;
    private int portNumber;
    private final LnTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(LnTcpServer.class);

    private LnTcpServer(@Nonnull LocoNetSystemConnectionMemo memo) {
        this.tc = memo.getLnTrafficController();
        LnTcpPreferences pm = LnTcpPreferences.getDefault();
        this.portNumber = pm.getPort();
        pm.addPropertyChangeListener(evt -> {
            if ("port".equals(evt.getPropertyName()) && !this.isEnabled()) {
                this.portNumber = pm.getPort();
            }
        });
    }

    public static synchronized LnTcpServer getDefault() {
        return InstanceManager.getOptionalDefault(LnTcpServer.class).orElseGet(() -> {
            LnTcpServer server = new LnTcpServer(InstanceManager.getDefault(LocoNetSystemConnectionMemo.class));
            return InstanceManager.setDefault(LnTcpServer.class, server);
        });
    }

    public boolean isEnabled() {
        return this.socketListener != null && this.socketListener.isAlive();
    }

    public boolean isSettingChanged() {
        return this.settingsChanged;
    }

    public void enable() {
        if (this.socketListener == null) {
            this.socketListener = new Thread(new ClientListener());
            this.socketListener.setDaemon(true);
            this.socketListener.setName("LocoNetOverTcpServer");
            log.info("Starting new LocoNetOverTcpServer listener on port {}", (Object)this.portNumber);
            this.socketListener.start();
            this.updateServerStateListeners();
            if (this.service == null) {
                this.service = ZeroConfService.create("_loconetovertcpserver._tcp.local.", this.portNumber);
            }
            log.info("Starting ZeroConfService _loconetovertcpserver._tcp.local for LocoNetOverTCP Server");
            this.service.publish();
            InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        if (this.socketListener != null) {
            Object[] clientsArray;
            this.socketListener.interrupt();
            this.socketListener = null;
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {}
            this.updateServerStateListeners();
            List<ClientRxHandler> list = this.clients;
            synchronized (list) {
                clientsArray = this.clients.toArray();
            }
            Object[] objectArray = clientsArray;
            int n = clientsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ((ClientRxHandler)o).close();
                ++n2;
            }
        }
        if (this.service != null) {
            this.service.stop();
        }
        InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServerStateListeners() {
        LnTcpServer lnTcpServer = this;
        synchronized (lnTcpServer) {
            this.stateListeners.stream().filter(l -> l != null).forEachOrdered(l -> l.notifyServerStateChanged(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClientStateListeners() {
        LnTcpServer lnTcpServer = this;
        synchronized (lnTcpServer) {
            this.stateListeners.stream().filter(l -> l != null).forEachOrdered(l -> l.notifyClientStateChanged(this));
        }
    }

    public void addStateListener(LnTcpServerListener l) {
        this.stateListeners.add(l);
    }

    public boolean removeStateListener(LnTcpServerListener l) {
        return this.stateListeners.remove(l);
    }

    public int getPort() {
        return this.portNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addClient(ClientRxHandler handler) {
        List<ClientRxHandler> list = this.clients;
        synchronized (list) {
            this.clients.add(handler);
        }
        this.updateClientStateListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClient(ClientRxHandler handler) {
        List<ClientRxHandler> list = this.clients;
        synchronized (list) {
            this.clients.remove(handler);
        }
        this.updateClientStateListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientCount() {
        List<ClientRxHandler> list = this.clients;
        synchronized (list) {
            return this.clients.size();
        }
    }

    class ClientListener
    implements Runnable {
        ClientListener() {
        }

        @Override
        public void run() {
            block3: {
                try {
                    LnTcpServer.this.serverSocket = new ServerSocket(LnTcpServer.this.portNumber);
                    LnTcpServer.this.serverSocket.setReuseAddress(true);
                    while (!LnTcpServer.this.socketListener.isInterrupted()) {
                        Socket newClientConnection = LnTcpServer.this.serverSocket.accept();
                        String remoteAddress = newClientConnection.getRemoteSocketAddress().toString();
                        log.info("Server: Connection from: {}", (Object)remoteAddress);
                        LnTcpServer.this.addClient(new ClientRxHandler(remoteAddress, newClientConnection, LnTcpServer.this.tc));
                    }
                    LnTcpServer.this.serverSocket.close();
                }
                catch (IOException ex) {
                    if (ex.toString().toLowerCase().contains("socket closed")) break block3;
                    log.error("Server: IO Exception: ", (Throwable)ex);
                }
            }
            LnTcpServer.this.serverSocket = null;
        }
    }
}

