/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.loconetovertcp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import jmri.InstanceManager;
import jmri.beans.PreferencesBean;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnTcpPreferences
extends PreferencesBean {
    public static final String PORT = "port";
    private static final String PORT_NUMBER_KEY = "PortNumber";
    private static final String SETTINGS_FILE_NAME = "LocoNetOverTcpSettings.ini";
    private int port = 1234;
    private static final Logger log = LoggerFactory.getLogger(LnTcpPreferences.class);

    public static LnTcpPreferences getDefault() {
        return InstanceManager.getOptionalDefault(LnTcpPreferences.class).orElseGet(() -> InstanceManager.setDefault(LnTcpPreferences.class, new LnTcpPreferences()));
    }

    public LnTcpPreferences() {
        super(ProfileManager.getDefault().getActiveProfile());
        Preferences sharedPreferences = ProfileUtils.getPreferences(super.getProfile(), this.getClass(), true);
        this.readPreferences(sharedPreferences);
    }

    private void readPreferences(Preferences sharedPreferences) {
        boolean migrate = false;
        try {
            if (sharedPreferences.keys().length == 0) {
                log.debug("No LocoNetOverTCP preferences exist.");
                migrate = true;
            }
        }
        catch (BackingStoreException backingStoreException) {
            log.debug("No preferences file exists.");
            migrate = true;
        }
        if (!migrate) {
            this.port = sharedPreferences.getInt(PORT, this.getPort());
            this.setIsDirty(false);
        } else {
            Properties settings = new Properties();
            File file = new File(FileUtil.getUserFilesPath(), SETTINGS_FILE_NAME);
            log.debug("Opening settings file {}", (Object)file);
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream stream = new FileInputStream(file);){
                    settings.load(stream);
                    this.port = Integer.parseInt(settings.getProperty(PORT_NUMBER_KEY, Integer.toString(this.getPort())));
                    this.setIsDirty(true);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.debug("old preferences file not found");
            }
            catch (IOException ex) {
                log.debug("exception reading old preferences file", (Throwable)ex);
            }
        }
    }

    public void savePreferences() {
        Preferences sharedPreferences = ProfileUtils.getPreferences(this.getProfile(), this.getClass(), true);
        sharedPreferences.putInt(PORT, this.getPort());
        try {
            sharedPreferences.sync();
            this.setIsDirty(false);
        }
        catch (BackingStoreException ex) {
            log.error("Exception while saving web server preferences", (Throwable)ex);
        }
    }

    boolean isPreferencesValid() {
        return this.port > 0 && this.port < 65536;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int value) {
        int old = this.port;
        if (old != value) {
            this.port = value;
            this.firePropertyChange(PORT, old, value);
            this.setRestartRequired();
        }
    }
}

