/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.loconetovertcp;

import jmri.jmrix.AbstractPortController;
import jmri.jmrix.loconet.LnNetworkPortController;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.loconetovertcp.Bundle;
import jmri.jmrix.loconet.loconetovertcp.LnOverTcpPacketizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnTcpDriverAdapter
extends LnNetworkPortController {
    private boolean opened = false;
    private static final Logger log = LoggerFactory.getLogger(LnTcpDriverAdapter.class);

    public LnTcpDriverAdapter(LocoNetSystemConnectionMemo m) {
        super(m);
        this.option2Name = "CommandStation";
        this.option3Name = "TurnoutHandle";
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("CommandStationTypeLabel"), this.commandStationNames, false));
        this.options.put(this.option3Name, new AbstractPortController.Option(Bundle.getMessage("TurnoutHandling"), new String[]{Bundle.getMessage("HandleNormal"), Bundle.getMessage("HandleSpread"), Bundle.getMessage("HandleOneOnly"), Bundle.getMessage("HandleBoth")}));
        this.options.put("TranspondingPresent", new AbstractPortController.Option(Bundle.getMessage("TranspondingPresent"), new String[]{Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYes")}));
    }

    public LnTcpDriverAdapter() {
        this(new LocoNetSystemConnectionMemo());
    }

    @Override
    public void configure() {
        this.setCommandStationType(this.getOptionState(this.option2Name));
        this.setTurnoutHandling(this.getOptionState(this.option3Name));
        this.setTranspondingAvailable(this.getOptionState("TranspondingPresent"));
        LnOverTcpPacketizer packets = new LnOverTcpPacketizer(this.getSystemConnectionMemo());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setLnTrafficController(packets);
        this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable);
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public void configureOption1(String value) {
        super.configureOption1(value);
        log.debug("configureOption1: {}", (Object)value);
        this.setCommandStationType(value);
    }
}

