/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.loconetovertcp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import jmri.jmrix.loconet.LnNetworkPortController;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetMessageException;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.util.WaitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnOverTcpPacketizer
extends LnPacketizer {
    static final String RECEIVE_PREFIX = "RECEIVE";
    static final String SEND_PREFIX = "SEND";
    public LnNetworkPortController networkController = null;
    private static final Logger log = LoggerFactory.getLogger(LnOverTcpPacketizer.class);

    public LnOverTcpPacketizer(LocoNetSystemConnectionMemo m) {
        super(m);
        this.xmtHandler = new XmtHandler();
        this.rcvHandler = new RcvHandler(this);
    }

    @Deprecated
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Only used during system initialization")
    public LnOverTcpPacketizer() {
        this(new LocoNetSystemConnectionMemo());
    }

    @Override
    public boolean isXmtBusy() {
        return this.networkController != null;
    }

    public void connectPort(LnNetworkPortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.networkController != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.networkController = p;
    }

    public void disconnectPort(LnNetworkPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.networkController != p) {
            log.warn("disconnectPort: disconnect called from non-connected LnPortnetworkController");
        }
        this.networkController = null;
    }

    class RcvHandler
    implements Runnable {
        LnOverTcpPacketizer trafficController;

        public RcvHandler(LnOverTcpPacketizer lt) {
            this.trafficController = lt;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        String rxLine;
                        if ((rxLine = LnOverTcpPacketizer.this.istream.readLine()) == null) {
                            log.warn("run: input stream returned null, exiting loop");
                            return;
                        }
                        log.debug("Received: {}", (Object)rxLine);
                        StringTokenizer st = new StringTokenizer(rxLine);
                        if (!st.nextToken().equals(LnOverTcpPacketizer.RECEIVE_PREFIX)) continue;
                        LocoNetMessage msg = null;
                        int opCode = Integer.parseInt(st.nextToken(), 16);
                        int byte2 = Integer.parseInt(st.nextToken(), 16);
                        switch ((opCode & 0x60) >> 5) {
                            default: {
                                msg = new LocoNetMessage(2);
                                break;
                            }
                            case 1: {
                                msg = new LocoNetMessage(4);
                                break;
                            }
                            case 2: {
                                msg = new LocoNetMessage(6);
                                break;
                            }
                            case 3: {
                                if (byte2 < 2) {
                                    log.error("LocoNet message length invalid: {} opcode: {}", (Object)byte2, (Object)Integer.toHexString(opCode));
                                }
                                msg = new LocoNetMessage(byte2);
                            }
                        }
                        msg.setOpCode(opCode);
                        msg.setElement(1, byte2);
                        int len = msg.getNumDataElements();
                        int i = 2;
                        while (i < len) {
                            int b = Integer.parseInt(st.nextToken(), 16);
                            if ((b & 0x80) != 0) {
                                log.warn("LocoNet message with opCode: {} ended early. Expected length: {} seen length: {} unexpected byte: {}", new Object[]{Integer.toHexString(opCode), len, i, Integer.toHexString(b)});
                                throw new LocoNetMessageException();
                            }
                            msg.setElement(i, b);
                            ++i;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("queue message for notification");
                        }
                        LocoNetMessage thisMsg = msg;
                        LnOverTcpPacketizer thisTc = this.trafficController;
                        Runnable r = new Runnable(thisMsg, thisTc){
                            LocoNetMessage msgForLater;
                            LnPacketizer myTc;
                            {
                                this.msgForLater = locoNetMessage;
                                this.myTc = lnPacketizer;
                            }

                            @Override
                            public void run() {
                                this.myTc.notify(this.msgForLater);
                            }
                        };
                        SwingUtilities.invokeLater(r);
                    }
                }
                catch (LocoNetMessageException e) {
                    log.warn("run: unexpected LocoNetMessageException: ", (Throwable)e);
                    continue;
                }
                catch (EOFException eOFException) {
                    log.debug("EOFException, is LocoNet serial I/O using timeouts?");
                    continue;
                }
                catch (IOException e) {
                    log.debug("IOException, should only happen with HexFile: ", (Throwable)e);
                    log.info("End of file");
                    return;
                }
                catch (RuntimeException e) {
                    log.warn("run: unexpected Exception: ", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        log.debug("check for input");
                        byte[] msg = null;
                        XmtHandler xmtHandler = this;
                        synchronized (xmtHandler) {
                            msg = (byte[])LnOverTcpPacketizer.this.xmtList.removeFirst();
                        }
                        try {
                            if (LnOverTcpPacketizer.this.ostream != null) {
                                log.debug("start write to stream");
                                StringBuffer packet = new StringBuffer(msg.length * 3 + LnOverTcpPacketizer.SEND_PREFIX.length() + 2);
                                packet.append(LnOverTcpPacketizer.SEND_PREFIX);
                                int Index = 0;
                                while (Index < msg.length) {
                                    packet.append(' ');
                                    String hexString = Integer.toHexString(msg[Index] & 0xFF).toUpperCase();
                                    if (hexString.length() == 1) {
                                        packet.append('0');
                                    }
                                    packet.append(hexString);
                                    ++Index;
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug("Write to LbServer: {}", (Object)packet.toString());
                                }
                                packet.append("\r\n");
                                LnOverTcpPacketizer.this.ostream.write(packet.toString().getBytes());
                                LnOverTcpPacketizer.this.ostream.flush();
                                log.debug("end write to stream");
                                continue;
                            }
                            log.warn("sendLocoNetMessage: no connection established");
                        }
                        catch (IOException e) {
                            log.warn("sendLocoNetMessage: IOException: {}", (Object)e.toString());
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    log.debug("start wait");
                    new WaitHandler(this);
                    log.debug("end wait");
                    continue;
                }
                break;
            }
        }
    }
}

