/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.loconetovertcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.LinkedList;
import java.util.StringTokenizer;
import jmri.Version;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.loconetovertcp.LnTcpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientRxHandler
extends Thread
implements LocoNetListener {
    Socket clientSocket;
    BufferedReader inStream;
    OutputStream outStream;
    final LinkedList<LocoNetMessage> msgQueue = new LinkedList();
    volatile Thread txThread;
    String inString;
    String remoteAddress;
    LocoNetMessage lastSentMessage;
    LnTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(ClientRxHandler.class);

    public ClientRxHandler(String newRemoteAddress, Socket newSocket, LnTrafficController _tc) {
        this.tc = _tc;
        this.clientSocket = newSocket;
        this.setDaemon(true);
        this.setPriority(10);
        this.remoteAddress = newRemoteAddress;
        this.setName("ClientRxHandler:" + this.remoteAddress);
        this.lastSentMessage = null;
        this.start();
    }

    @Override
    public void run() {
        try {
            this.inStream = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            this.outStream = this.clientSocket.getOutputStream();
            this.tc.addLocoNetListener(-1, this);
            this.txThread = new Thread(new ClientTxHandler(this));
            this.txThread.setDaemon(true);
            this.txThread.setPriority(10);
            this.txThread.setName("ClientTxHandler: " + this.remoteAddress);
            this.txThread.start();
            while (!this.isInterrupted()) {
                this.inString = this.inStream.readLine();
                if (this.inString == null) {
                    log.debug("ClientRxHandler: Remote Connection Closed");
                    this.interrupt();
                    continue;
                }
                log.debug("ClientRxHandler: Received: {}", (Object)this.inString);
                StringTokenizer st = new StringTokenizer(this.inString);
                if (!st.nextToken().equals("SEND")) continue;
                LocoNetMessage msg = null;
                int opCode = Integer.parseInt(st.nextToken(), 16);
                int byte2 = Integer.parseInt(st.nextToken(), 16);
                switch ((opCode & 0x60) >> 5) {
                    case 0: {
                        msg = new LocoNetMessage(2);
                        break;
                    }
                    case 1: {
                        msg = new LocoNetMessage(4);
                        break;
                    }
                    case 2: {
                        msg = new LocoNetMessage(6);
                        break;
                    }
                    case 3: {
                        if (byte2 < 2) {
                            log.error("ClientRxHandler: LocoNet message length invalid: {} opcode: {}", (Object)byte2, (Object)Integer.toHexString(opCode));
                        }
                        msg = new LocoNetMessage(byte2);
                        break;
                    }
                    default: {
                        log.warn("Unhandled msg length: {}", (Object)((opCode & 0x60) >> 5));
                    }
                }
                if (msg == null) {
                    log.error("msg is null!");
                    return;
                }
                msg.setOpCode(opCode);
                msg.setElement(1, byte2);
                int len = msg.getNumDataElements();
                int i = 2;
                while (i < len) {
                    int b = Integer.parseInt(st.nextToken(), 16);
                    msg.setElement(i, b);
                    ++i;
                }
                this.tc.sendLocoNetMessage(msg);
                this.lastSentMessage = msg;
            }
        }
        catch (IOException ex) {
            log.debug("ClientRxHandler: IO Exception: ", (Throwable)ex);
        }
        this.tc.removeLocoNetListener(-1, this);
        if (this.txThread != null) {
            this.txThread.interrupt();
        }
        this.txThread = null;
        this.inStream = null;
        this.outStream = null;
        this.msgQueue.clear();
        try {
            this.clientSocket.close();
        }
        catch (IOException iOException) {}
        LnTcpServer.getDefault().removeClient(this);
        log.info("ClientRxHandler: Exiting");
    }

    public void close() {
        try {
            this.clientSocket.close();
        }
        catch (IOException ex1) {
            log.error("close, which closing clientSocket", (Throwable)ex1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(LocoNetMessage msg) {
        LinkedList<LocoNetMessage> linkedList = this.msgQueue;
        synchronized (linkedList) {
            this.msgQueue.add(msg);
            this.msgQueue.notify();
        }
    }

    void dispose() {
        try {
            this.interrupt();
            this.join();
        }
        catch (InterruptedException interruptedException) {
            log.warn("dispose() interrupted");
        }
    }

    class ClientTxHandler
    implements Runnable {
        LocoNetMessage msg;
        StringBuffer outBuf;
        Thread parentThread;

        ClientTxHandler(Thread creator) {
            this.parentThread = creator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.outBuf = new StringBuffer("VERSION JMRI Server ");
                this.outBuf.append(Version.name()).append("\r\n");
                ClientRxHandler.this.outStream.write(this.outBuf.toString().getBytes());
                while (!ClientRxHandler.this.isInterrupted()) {
                    this.msg = null;
                    LinkedList<LocoNetMessage> linkedList = ClientRxHandler.this.msgQueue;
                    synchronized (linkedList) {
                        if (ClientRxHandler.this.msgQueue.isEmpty()) {
                            ClientRxHandler.this.msgQueue.wait();
                        }
                        if (!ClientRxHandler.this.msgQueue.isEmpty()) {
                            this.msg = ClientRxHandler.this.msgQueue.removeFirst();
                        }
                    }
                    if (this.msg == null) continue;
                    this.outBuf.setLength(0);
                    this.outBuf.append("RECEIVE ");
                    this.outBuf.append(this.msg.toString());
                    log.debug("ClientTxHandler: Send: {}", (Object)this.outBuf.toString());
                    this.outBuf.append("\r\n");
                    if (ClientRxHandler.this.lastSentMessage != null && ClientRxHandler.this.lastSentMessage.equals(this.msg)) {
                        ClientRxHandler.this.lastSentMessage = null;
                        this.outBuf.append("SENT OK\r\n");
                    }
                    ClientRxHandler.this.outStream.write(this.outBuf.toString().getBytes());
                    ClientRxHandler.this.outStream.flush();
                }
            }
            catch (IOException iOException) {
                log.error("ClientTxHandler: IO Exception");
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                log.debug("ClientTxHandler: Interrupted Exception");
            }
            this.parentThread.interrupt();
            this.parentThread = null;
            this.msg = null;
            this.outBuf = null;
            log.info("ClientTxHandler: Exiting");
        }
    }
}

