/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locoio;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jmri.jmrix.loconet.LnConstants;
import jmri.jmrix.loconet.locoio.Bundle;
import jmri.jmrix.loconet.locoio.LocoIOData;
import jmri.jmrix.loconet.locoio.LocoIOMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoIOTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private LocoIOData liodata;
    private boolean inHex = true;
    private int _numRows = 16;
    public static final int PINCOLUMN = 0;
    public static final int MODECOLUMN = 1;
    public static final int ADDRCOLUMN = 2;
    public static final int SV0COLUMN = 3;
    public static final int SV1COLUMN = 4;
    public static final int SV2COLUMN = 5;
    public static final int CAPTURECOLUMN = 6;
    public static final int READCOLUMN = 7;
    public static final int WRITECOLUMN = 8;
    public static final int HIGHESTCOLUMN = 9;
    private final String[] msg = new String[this._numRows];
    private JTextField status = null;
    private static final Logger log = LoggerFactory.getLogger(LocoIOTableModel.class);

    public LocoIOTableModel(LocoIOData ldata) {
        this.liodata = ldata;
        ldata.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("PortChange")) {
            Integer i = (Integer)evt.getNewValue();
            int v = i;
            this.fireTableRowsUpdated(v, v);
        }
    }

    @Override
    public int getRowCount() {
        return this._numRows;
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColumnPort");
            }
            case 1: {
                return Bundle.getMessage("ColumnAction");
            }
            case 2: {
                return Bundle.getMessage("AddressCol");
            }
            case 3: {
                return "SV";
            }
            case 4: {
                return "Value1";
            }
            case 5: {
                return "Value2";
            }
            case 6: {
                return "";
            }
            case 7: {
                return "";
            }
            case 8: {
                return "";
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return JButton.class;
            }
            case 7: {
                return JButton.class;
            }
            case 8: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return Integer.toString(row + 1);
            }
            case 1: {
                return this.liodata.getMode(row);
            }
            case 2: {
                return this.liodata.getAddr(row) == 0 ? "<" + Bundle.getMessage("None").toLowerCase() + ">" : Integer.toString(this.liodata.getAddr(row));
            }
            case 3: {
                return this.inHex ? "0x" + Integer.toHexString(this.liodata.getSV(row)) : "" + this.liodata.getSV(row);
            }
            case 4: {
                return this.inHex ? "0x" + Integer.toHexString(this.liodata.getV1(row)) : "" + this.liodata.getV1(row);
            }
            case 5: {
                return this.inHex ? "0x" + Integer.toHexString(this.liodata.getV2(row)) : "" + this.liodata.getV2(row);
            }
            case 6: {
                return Bundle.getMessage("ButtonCapture");
            }
            case 7: {
                return Bundle.getMessage("ButtonRead");
            }
            case 8: {
                return Bundle.getMessage("ButtonWrite");
            }
        }
        return "unknown";
    }

    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: {
                return new JLabel((String)" 16 ").getPreferredSize().width;
            }
            case 1: {
                return new JLabel((String)"1234567890123456789012345678901234567890").getPreferredSize().width;
            }
            case 2: {
                return new JLabel((String)this.getColumnName((int)2)).getPreferredSize().width;
            }
            case 3: 
            case 4: 
            case 5: {
                return new JLabel((String)" 0xFF ").getPreferredSize().width;
            }
            case 6: {
                return new JButton((String)Bundle.getMessage((String)"ButtonCapture")).getPreferredSize().width;
            }
            case 7: {
                return new JButton((String)Bundle.getMessage((String)"ButtonRead")).getPreferredSize().width;
            }
            case 8: {
                return new JButton((String)Bundle.getMessage((String)"ButtonWrite")).getPreferredSize().width;
            }
        }
        return new JLabel((String)" <unknown> ").getPreferredSize().width;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            if (this.liodata.getLocoIOModeList().isValidModeValue(value)) {
                this.liodata.setMode(row, (String)value);
                this.liodata.setLIM(row, (String)value);
                LocoIOMode l = this.liodata.getLIM(row);
                if (l != null) {
                    this.liodata.setSV(row, l.getSV());
                    this.liodata.setV1(row, l, this.liodata.getAddr(row));
                    this.liodata.setV2(row, l, this.liodata.getAddr(row));
                    this.msg[row] = "Packet: " + LnConstants.OPC_NAME(l.getOpCode()) + " " + Integer.toHexString(this.liodata.getV1(row)) + " " + Integer.toHexString(this.liodata.getV2(row)) + " <CHK>";
                    if (this.status != null) {
                        this.status.setText(this.msg[row]);
                    }
                    this.fireTableRowsUpdated(row, row);
                }
            }
        } else if (col == 2) {
            int a;
            if (((String)value).startsWith("0x")) {
                a = Integer.valueOf(((String)value).substring(2), 16);
            } else {
                try {
                    a = Integer.valueOf((String)value, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    log.warn("Enter a hex or decimal number for the Port Address first");
                    return;
                }
            }
            if (a < 1) {
                a = 1;
            }
            if (a > 4095) {
                a = 4095;
            }
            this.liodata.setAddr(row, a);
            if (!("<" + Bundle.getMessage("None").toLowerCase() + ">").equals(this.liodata.getMode(row))) {
                LocoIOMode l = this.liodata.getLIM(row);
                this.liodata.setV1(row, l, a);
                this.liodata.setV2(row, l, a);
                int opcode = l == null ? 0 : l.getOpCode();
                this.msg[row] = "Packet: " + LnConstants.OPC_NAME(opcode) + " " + Integer.toHexString(this.liodata.getV1(row)) + " " + Integer.toHexString(this.liodata.getV2(row)) + " <CHK>";
                if (this.status != null) {
                    this.status.setText(this.msg[row]);
                }
            } else {
                log.warn("Select an option from the Mode drop down first");
            }
            this.fireTableRowsUpdated(row, row);
        } else if (col == 6) {
            this.liodata.captureValues(row);
        } else if (col == 7) {
            this.liodata.readValues(row);
        } else if (col == 8) {
            this.liodata.writeValues(row);
        }
    }

    public void dispose() {
        log.debug("dispose");
    }
}

