/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locoio;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import jmri.jmrix.loconet.LnTrafficController;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.locoio.Bundle;
import jmri.jmrix.loconet.locoio.LocoIO;
import jmri.jmrix.loconet.locoio.LocoIOData;
import jmri.jmrix.loconet.locoio.LocoIOTableModel;
import jmri.jmrix.loconet.swing.LnPanel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LocoIOPanel
extends LnPanel
implements PropertyChangeListener {
    LnTrafficController ln;
    JTextField addrField = new JTextField("00");
    JTextField subAddrField = new JTextField("00");
    static final JTextField spacer = new JTextField("123");
    JLabel status = new JLabel(Bundle.getMessage("StateUnknown"));
    JLabel firmware = new JLabel(Bundle.getMessage("StateUnknown"));
    JLabel locobuffer = new JLabel(Bundle.getMessage("StateUnknown"));
    JLabel revLabel = new JLabel(" LocoBuffer rev: ");
    JLabel statusLabel = new JLabel(String.valueOf(Bundle.getMessage("MakeLabel", Bundle.getMessage("StatusCol"))) + " ");
    JLabel fwLabel = new JLabel("LocoIO Firmware rev: ");
    JButton addrSetButton = null;
    JButton probeButton = null;
    JButton readAllButton = null;
    JButton writeAllButton = null;
    JButton saveButton = null;
    JButton openButton = null;
    LocoIOData data;
    LocoIOTableModel model;
    JTable table;
    JScrollPane scroll;
    EmptyBorder empty;
    private static final Logger log = LoggerFactory.getLogger(LocoIOPanel.class);

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        this.setLayout(new BoxLayout(this, 1));
        this.ln = memo.getLnTrafficController();
        this.data = new LocoIOData(Integer.valueOf(this.addrField.getText(), 16), Integer.valueOf(this.subAddrField.getText(), 16), this.ln);
        this.model = new LocoIOTableModel(this.data);
        this.table = new JTable(this.model);
        this.scroll = new JScrollPane(this.table);
        this.empty = new EmptyBorder(5, 5, 5, 5);
        this.data.addPropertyChangeListener(this);
        this.table.setShowHorizontalLines(true);
        this.table.setAutoCreateColumnsFromModel(true);
        TableColumnModel tcm = this.table.getColumnModel();
        JComboBox<String> comboOnBox = new JComboBox<String>(this.data.getLocoIOModeList().getValidModes());
        comboOnBox.setEditable(true);
        DefaultCellEditor modeEditor = new DefaultCellEditor(comboOnBox);
        tcm.getColumn(1).setCellEditor(modeEditor);
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(7).setCellRenderer(buttonRenderer);
        tcm.getColumn(8).setCellRenderer(buttonRenderer);
        tcm.getColumn(6).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(7).setCellEditor(buttonEditor);
        tcm.getColumn(8).setCellEditor(buttonEditor);
        tcm.getColumn(6).setCellEditor(buttonEditor);
        this.table.setRowHeight(new JButton((String)Bundle.getMessage((String)"ButtonCapture")).getPreferredSize().height);
        int col = 0;
        while (col < 9) {
            this.table.getColumnModel().getColumn(col).setPreferredWidth(this.model.getPreferredWidth(col));
            ++col;
        }
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JPanel p1a = new JPanel();
        p1a.add(new JLabel(Bundle.getMessage("LocoioAddressLabel")));
        p1a.add(this.addrField);
        this.addrField.setPreferredSize(spacer.getPreferredSize());
        this.addrField.setToolTipText(Bundle.getMessage("AddressToolTip"));
        p1a.add(new JLabel("/"));
        p1a.add(this.subAddrField);
        this.subAddrField.setPreferredSize(spacer.getPreferredSize());
        this.subAddrField.setToolTipText(Bundle.getMessage("SubAddressToolTip"));
        p1.add(p1a);
        p1.add(new JLabel("   "));
        p1.add(Box.createGlue());
        this.probeButton = new JButton(Bundle.getMessage("ButtonProbe"));
        this.probeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                LocoIOPanel.this.data.setLIOVersion("<Not found>");
                LocoIO.probeLocoIOs(LocoIOPanel.this.ln);
            }
        });
        p1.add(this.probeButton);
        p1.add(Box.createGlue());
        this.readAllButton = new JButton(Bundle.getMessage("ButtonReadAll"));
        this.readAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                LocoIOPanel.this.data.readAll();
            }
        });
        p1.add(this.readAllButton);
        this.writeAllButton = new JButton(Bundle.getMessage("ButtonWriteAll"));
        this.writeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                LocoIOPanel.this.data.writeAll();
            }
        });
        p1.add(this.writeAllButton);
        p1.add(Box.createGlue());
        this.addrSetButton = new JButton(Bundle.getMessage("ButtonSetAddress"));
        p1.add(this.addrSetButton);
        this.addrSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                LocoIOPanel.this.addrSet();
            }
        });
        p1.add(Box.createGlue());
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        p2.add(this.revLabel);
        p2.add(this.locobuffer);
        this.revLabel.setFont(this.revLabel.getFont().deriveFont(0.9f * (float)this.addrField.getFont().getSize()));
        this.revLabel.setForeground(Color.gray);
        this.locobuffer.setFont(this.locobuffer.getFont().deriveFont(0.9f * (float)this.addrField.getFont().getSize()));
        this.locobuffer.setForeground(Color.gray);
        p2.add(Box.createGlue());
        p2.add(this.statusLabel);
        p2.add(this.status);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(0.9f * (float)this.addrField.getFont().getSize()));
        this.statusLabel.setForeground(Color.gray);
        this.status.setFont(this.status.getFont().deriveFont(0.9f * (float)this.addrField.getFont().getSize()));
        this.status.setForeground(Color.gray);
        p2.add(Box.createGlue());
        p2.add(this.fwLabel);
        p2.add(this.firmware);
        this.fwLabel.setFont(this.fwLabel.getFont().deriveFont(0.9f * (float)this.addrField.getFont().getSize()));
        this.fwLabel.setForeground(Color.gray);
        this.firmware.setFont(this.firmware.getFont().deriveFont(0.9f * (float)this.addrField.getFont().getSize()));
        this.firmware.setForeground(Color.gray);
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 1));
        p3.add(p1);
        this.scroll.setBorder(this.empty);
        p3.add(this.scroll);
        this.add(p3);
        this.add(p2);
        ActionListener al4UnitAddress = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                log.debug("address =|{}|", (Object)LocoIOPanel.this.addrField.getText());
                LocoIOPanel.this.addrField.setText(LocoIOPanel.this.addrField.getText().trim());
                LocoIOPanel.this.subAddrField.setText(LocoIOPanel.this.subAddrField.getText().trim());
                if (LocoIOPanel.this.addrField.getText() == null || LocoIOPanel.this.addrField.getText().length() < 1) {
                    LocoIOPanel.this.addrField.setText("1");
                    log.warn("empty Address, set to 1");
                    return;
                }
                if (LocoIOPanel.this.subAddrField.getText() == null || LocoIOPanel.this.subAddrField.getText().length() < 1) {
                    LocoIOPanel.this.subAddrField.setText("0");
                    log.warn("empty SubAddress, set to 0");
                    return;
                }
                try {
                    LocoIOPanel.this.data.setUnitAddress(Integer.valueOf(LocoIOPanel.this.addrField.getText(), 16), Integer.valueOf(LocoIOPanel.this.subAddrField.getText(), 16));
                }
                catch (NullPointerException e) {
                    log.error("Caught NullPointerException", (Throwable)e);
                }
                catch (NumberFormatException ne) {
                    log.error("Caught NumberFormatException", (Throwable)ne);
                }
            }
        };
        FocusListener fl4UnitAddress = new FocusListener(){

            @Override
            public void focusGained(FocusEvent event) {
            }

            @Override
            public void focusLost(FocusEvent event) {
                log.debug("address =|{}|", (Object)LocoIOPanel.this.addrField.getText());
                LocoIOPanel.this.addrField.setText(LocoIOPanel.this.addrField.getText().trim());
                LocoIOPanel.this.subAddrField.setText(LocoIOPanel.this.subAddrField.getText().trim());
                if (LocoIOPanel.this.addrField.getText().length() < 1) {
                    LocoIOPanel.this.addrField.setText("1");
                    log.warn("empty LocoIO Address, set to 1");
                    return;
                }
                if (LocoIOPanel.this.subAddrField.getText().length() < 1) {
                    LocoIOPanel.this.subAddrField.setText("0");
                    log.warn("empty LocoIO SubAddress, set to 0");
                    return;
                }
                try {
                    LocoIOPanel.this.data.setUnitAddress(Integer.valueOf(LocoIOPanel.this.addrField.getText(), 16), Integer.valueOf(LocoIOPanel.this.subAddrField.getText(), 16));
                }
                catch (NullPointerException e) {
                    log.error("Caught NullPointerException", (Throwable)e);
                }
            }
        };
        this.addrField.addActionListener(al4UnitAddress);
        this.subAddrField.addActionListener(al4UnitAddress);
        this.addrField.addFocusListener(fl4UnitAddress);
        this.subAddrField.addFocusListener(fl4UnitAddress);
        try {
            this.data.setUnitAddress(81, 0);
        }
        catch (NullPointerException e) {
            log.error("Caught NullPointerException", (Throwable)e);
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.locoio.LocoIOFrame";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("MenuItemLocoIOProgrammer"));
    }

    protected int cautionAddrSet() {
        log.info("Caution: 'Set LocoIO Address' is a broadcast operation to ALL boards on this connection");
        return JOptionPane.showOptionDialog(this, Bundle.getMessage("LocoIoSetAddressWarnDialog"), Bundle.getMessage("WarningTitle"), 0, 1, null, new Object[]{Bundle.getMessage("ButtonCancel"), Bundle.getMessage("ButtonOK")}, null);
    }

    protected void addrSet() {
        int retval = this.cautionAddrSet();
        if (retval != 1) {
            return;
        }
        int address = Integer.valueOf(this.addrField.getText(), 16);
        int subAddress = Integer.valueOf(this.subAddrField.getText(), 16);
        if (address > 126) {
            log.warn("Address must be [1..126], was {}", (Object)address);
        }
        if ((address & 0xFF) == 128) {
            log.warn("Only a LocoBuffer may use address 0x80");
            return;
        }
        if (subAddress > 126) {
            log.warn("subAddress must be [1..126], was {}", (Object)subAddress);
        }
        int fullAddress = 0x100 | address & 0x7F;
        LocoIO.programLocoIOAddress(fullAddress, subAddress &= 0x7F, this.ln);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String v;
        int v2;
        Integer i;
        if (evt.getPropertyName().equals("UnitAddress")) {
            i = (Integer)evt.getNewValue();
            v2 = i;
            v2 &= 0xFF;
            if (this.addrField != null) {
                this.addrField.setText(Integer.toHexString(v2));
            }
            if (this.firmware != null) {
                this.firmware.setText("<" + Bundle.getMessage("BeanStateUnknown").toLowerCase() + ">  ");
            }
        }
        if (evt.getPropertyName().equals("UnitSubAddress")) {
            i = (Integer)evt.getNewValue();
            v2 = i;
            if (this.subAddrField != null) {
                this.subAddrField.setText(Integer.toHexString(v2));
            }
            if (this.firmware != null) {
                this.firmware.setText("<" + Bundle.getMessage("BeanStateUnknown").toLowerCase() + ">  ");
            }
        }
        if (evt.getPropertyName().equals("LBVersionChange")) {
            v = (String)evt.getNewValue();
            if (this.locobuffer != null) {
                this.locobuffer.setText(v);
            }
        }
        if (evt.getPropertyName().equals("LIOVersionChange")) {
            v = (String)evt.getNewValue();
            if (this.firmware != null) {
                this.firmware.setText(String.valueOf(v) + "  ");
            }
        }
        if (evt.getPropertyName().equals("StatusChange")) {
            v = (String)evt.getNewValue();
            if (this.status != null) {
                this.status.setText(v);
            }
        }
    }

    @Override
    public void dispose() {
        this.model.dispose();
        super.dispose();
        this.model = null;
        this.table = null;
        this.scroll = null;
        this.readAllButton = null;
        this.writeAllButton = null;
        this.addrField = null;
        this.subAddrField = null;
        this.status = null;
        this.firmware = null;
        this.locobuffer = null;
        this.saveButton = null;
        this.openButton = null;
    }
}

