/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locoio;

import java.util.Vector;
import jmri.jmrix.loconet.locoio.LocoIOMode;

public class LocoIOModeList {
    protected Vector<LocoIOMode> modeList = new Vector();
    protected String[] validmodes;

    public LocoIOModeList() {
        this.modeList.add(new LocoIOMode(0, 176, 15, 0, "Toggle Switch, LocoIO 1.3.2"));
        this.modeList.add(new LocoIOMode(0, 178, 95, 0, "Block Detector, Active High"));
        this.modeList.add(new LocoIOMode(0, 178, 31, 16, "Block Detector, Active Low"));
        this.modeList.add(new LocoIOMode(0, 176, 15, 16, "Toggle Switch, Direct Control"));
        this.modeList.add(new LocoIOMode(0, 177, 7, 16, "Toggle Switch, Indirect Control"));
        this.modeList.add(new LocoIOMode(0, 176, 111, 0, "Push Button, Active High, Direct Control"));
        this.modeList.add(new LocoIOMode(0, 177, 103, 0, "Push Button, Active High, Indirect Control"));
        this.modeList.add(new LocoIOMode(0, 176, 47, 16, "Push Button, Active Low, Direct Control"));
        this.modeList.add(new LocoIOMode(0, 177, 39, 16, "Push Button, Active Low, Indirect Control"));
        this.modeList.add(new LocoIOMode(0, 177, 23, 112, "Turnout Feedback, single sensor"));
        this.modeList.add(new LocoIOMode(0, 177, 55, 112, "Turnout Feedback, dual sensor, #1"));
        this.modeList.add(new LocoIOMode(0, 177, 55, 96, "Turnout Feedback, dual sensor, #2"));
        this.modeList.add(new LocoIOMode(1, 178, 192, 0, "Block Occupied Indication"));
        this.modeList.add(new LocoIOMode(1, 178, 208, 0, "Block Occupied Indication, Blinking"));
        this.modeList.add(new LocoIOMode(1, 176, 129, 16, "Steady State, single output, On at Power up"));
        this.modeList.add(new LocoIOMode(1, 176, 128, 16, "Steady State, single output, Off at Power up"));
        this.modeList.add(new LocoIOMode(1, 176, 129, 48, "Steady State, paired output, On at Power up"));
        this.modeList.add(new LocoIOMode(1, 176, 128, 48, "Steady State, paired output, Off at Power up"));
        this.modeList.add(new LocoIOMode(1, 176, 145, 16, "Steady State, single output, On at Power up, Blinking"));
        this.modeList.add(new LocoIOMode(1, 176, 144, 16, "Steady State, single output, Off at Power up, Blinking"));
        this.modeList.add(new LocoIOMode(1, 176, 145, 48, "Steady State, paired output, On at Power up, Blinking"));
        this.modeList.add(new LocoIOMode(1, 176, 144, 48, "Steady State, paired output, Off at Power up, Blinking"));
        this.modeList.add(new LocoIOMode(1, 176, 136, 32, "Pulsed, software controlled on time, single output"));
        this.modeList.add(new LocoIOMode(1, 176, 140, 32, "Pulsed, firmware controlled on time, single output"));
        this.modeList.add(new LocoIOMode(1, 176, 136, 0, "Pulsed, software controlled on time, paired output"));
        this.modeList.add(new LocoIOMode(1, 176, 140, 0, "Pulsed, firmware controlled on time, paired output"));
        this.validmodes = new String[this.modeList.size()];
        int i = 0;
        while (i <= this.modeList.size() - 1) {
            LocoIOMode m = this.modeList.elementAt(i);
            this.validmodes[i] = m.getFullMode();
            ++i;
        }
    }

    protected String[] getValidModes() {
        return this.validmodes;
    }

    protected boolean isValidModeValue(Object value) {
        if (value instanceof String) {
            String sValue = (String)value;
            int i = 0;
            while (i < this.validmodes.length) {
                if (sValue.equals(this.validmodes[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected LocoIOMode getLocoIOModeFor(String s) {
        int i = 0;
        while (i <= this.modeList.size() - 1) {
            LocoIOMode m = this.modeList.elementAt(i);
            String ms = m.getFullMode();
            if (ms.matches(s)) {
                return m;
            }
            ++i;
        }
        return null;
    }

    protected LocoIOMode getLocoIOModeFor(int cv, int v1, int v2) {
        int i = 0;
        while (i <= this.modeList.size() - 1) {
            LocoIOMode m = this.modeList.elementAt(i);
            if (m.getSV() == cv) {
                if (m.getOpCode() == 178 && m.getV2() == (v2 & 0xD0)) {
                    return m;
                }
                if ((cv == 111 || cv == 103 || cv == 47 || cv == 39) && m.getV2() == (v2 & 0x50)) {
                    return m;
                }
                if (m.getV2() == (v2 & 0xB0)) {
                    return m;
                }
                if ((cv & 0x90) == 16 && (cv & 0x80) == 0 && m.getV2() == (v2 & 0x70)) {
                    return m;
                }
            }
            ++i;
        }
        return null;
    }

    protected int addressToValue1(LocoIOMode lim, int address) {
        if (lim == null) {
            return 0;
        }
        return this.addressToValues(lim.getOpCode(), lim.getSV(), lim.getV2(), address) & 0x7F;
    }

    protected int addressToValue2(LocoIOMode lim, int address) {
        if (lim == null) {
            return 0;
        }
        return this.addressToValues(lim.getOpCode(), lim.getSV(), lim.getV2(), address) / 256 & 0x7F;
    }

    private static int SENSOR_ADR(int a1, int a2) {
        return (a2 & 0xF) * 128 + (a1 & 0x7F) + 1;
    }

    protected int addressToValues(int opcode, int sv, int v2mask, int address) {
        int v1 = 0;
        int v2 = 0;
        --address;
        if (opcode == 178) {
            v1 = address / 2 & 0x7F;
            v2 = address / 256 & 0xF;
            if ((address & 1) == 1) {
                v2 |= 0x20;
            }
            v2 |= v2mask;
        } else if (opcode == 176) {
            v1 = address & 0x7F;
            v2 = address / 128 & 0xF;
            v2 &= 0xFFFFFFBF;
            v2 |= v2mask;
        } else if (opcode == 177) {
            v1 = address & 0x7F;
            v2 = address / 128 & 0xF;
            v2 &= 0xFFFFFFBF;
            v2 |= v2mask;
        }
        return v2 * 256 + v1;
    }

    protected int valuesToAddress(int opcode, int sv, int v1, int v2) {
        if (opcode == 178) {
            return (LocoIOModeList.SENSOR_ADR(v1, v2) - 1) * 2 + ((v2 & 0x20) != 0 ? 2 : 1);
        }
        if (opcode == 176) {
            return LocoIOModeList.SENSOR_ADR(v1, v2);
        }
        if (opcode == 177) {
            return LocoIOModeList.SENSOR_ADR(v1, v2);
        }
        return -1;
    }

    protected int valuesToAddress(LocoIOMode lim, int sv, int v1, int v2) {
        if (lim == null) {
            return 0;
        }
        return this.valuesToAddress(lim.getOpCode(), sv, v1, v2);
    }
}

