/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locogen;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.locogen.Bundle;
import jmri.jmrix.loconet.swing.LnPanel;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoGenPanel
extends LnPanel
implements LocoNetListener {
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(12);
    static final int MAXSEQUENCE = 4;
    JTextField[] mPacketField = new JTextField[4];
    JCheckBox[] mUseField = new JCheckBox[4];
    JTextField[] mDelayField = new JTextField[4];
    JToggleButton mRunButton = new JToggleButton(Bundle.getMessage("ButtonRun"));
    int mNextSequenceElement = 0;
    LocoNetMessage mNextEcho = null;
    Timer timer = null;
    private static final Logger log = LoggerFactory.getLogger(LocoGenPanel.class);

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.loconet.locogen.LocoGenFrame";
    }

    @Override
    public String getTitle() {
        return this.getTitle(Bundle.getMessage("MenuItemSendPacket"));
    }

    @Override
    public void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel(Bundle.getMessage("LabelSendOne")));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 1));
        this.jLabel1.setText(Bundle.getMessage("MakeLabel", Bundle.getMessage("PacketLabel")));
        this.jLabel1.setVisible(true);
        this.sendButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("TooltipSendPacket"));
        this.packetTextField.setToolTipText(Bundle.getMessage("EnterHexToolTip"));
        pane1.add(this.jLabel1);
        pane1.add(this.packetTextField);
        pane1.add(this.sendButton);
        pane1.add(Box.createVerticalGlue());
        this.sendButton.addActionListener(this::sendButtonActionPerformed);
        this.add(pane1);
        this.add(new JSeparator());
        this.add(new JLabel(Bundle.getMessage("SendSeqTitle")));
        JPanel pane2 = new JPanel();
        pane2.setLayout(new GridLayout(6, 4));
        pane2.add(new JLabel(""));
        pane2.add(new JLabel(Bundle.getMessage("ButtonSend")));
        pane2.add(new JLabel(Bundle.getMessage("PacketLabel")));
        pane2.add(new JLabel(Bundle.getMessage("WaitLabel")));
        int i = 0;
        while (i < 4) {
            pane2.add(new JLabel(Integer.toString(i + 1)));
            this.mUseField[i] = new JCheckBox();
            this.mPacketField[i] = new JTextField(10);
            this.mDelayField[i] = new JTextField(10);
            pane2.add(this.mUseField[i]);
            pane2.add(this.mPacketField[i]);
            pane2.add(this.mDelayField[i]);
            ++i;
        }
        pane2.add(this.mRunButton);
        this.add(pane2);
        this.mRunButton.addActionListener(this::runButtonActionPerformed);
    }

    @Override
    public void initComponents(LocoNetSystemConnectionMemo memo) {
        super.initComponents(memo);
        memo.getLnTrafficController().addLocoNetListener(-1, this);
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        this.memo.getLnTrafficController().sendLocoNetMessage(this.createPacket(input));
    }

    protected void restartTimer(int delay) {
        if (this.timer == null) {
            this.timer = new Timer(delay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LocoGenPanel.this.sendNextItem();
                }
            });
        }
        this.timer.stop();
        this.timer.setInitialDelay(delay);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    public void runButtonActionPerformed(ActionEvent e) {
        if (!this.mRunButton.isSelected()) {
            return;
        }
        boolean ok = false;
        int i = 0;
        while (i < 4) {
            if (this.mUseField[i].isSelected()) {
                ok = true;
            }
            ++i;
        }
        if (!ok) {
            this.mRunButton.setSelected(false);
            return;
        }
        this.mNextSequenceElement = 0;
        this.sendNextItem();
    }

    @Override
    public void message(LocoNetMessage m) {
        log.debug("message");
        if (!this.mRunButton.isSelected()) {
            return;
        }
        if (!this.mNextEcho.equals(m)) {
            return;
        }
        this.startSequenceDelay();
    }

    void startSequenceDelay() {
        log.debug("startSequenceDelay");
        int delay = Integer.parseInt(this.mDelayField[this.mNextSequenceElement].getText());
        ++this.mNextSequenceElement;
        this.restartTimer(delay);
    }

    void sendNextItem() {
        log.debug("sendNextItem");
        if (!this.mRunButton.isSelected()) {
            return;
        }
        if (this.mNextSequenceElement >= 4) {
            this.mNextSequenceElement = 0;
        }
        if (this.mUseField[this.mNextSequenceElement].isSelected()) {
            LocoNetMessage m;
            this.mNextEcho = m = this.createPacket(this.mPacketField[this.mNextSequenceElement].getText());
            this.memo.getLnTrafficController().sendLocoNetMessage(m);
        } else {
            ++this.mNextSequenceElement;
            this.sendNextItem();
        }
    }

    LocoNetMessage createPacket(String s) {
        byte[] b = StringUtil.bytesFromHexString(s);
        if (b.length == 0) {
            return null;
        }
        LocoNetMessage m = new LocoNetMessage(b.length);
        int i = 0;
        while (i < b.length) {
            m.setElement(i, b[i]);
            ++i;
        }
        return m;
    }

    @Override
    public void dispose() {
        this.mRunButton.setSelected(false);
        super.dispose();
    }
}

