/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.locobuffer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.loconet.LnCommandStationType;
import jmri.jmrix.loconet.LnPacketizer;
import jmri.jmrix.loconet.LnPacketizerStrict;
import jmri.jmrix.loconet.LnPortController;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.locobuffer.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class LocoBufferAdapter
extends LnPortController {
    Vector<String> portNameVector = null;
    SerialPort activeSerialPort = null;
    protected String[] validSpeeds = new String[]{Bundle.getMessage("Baud19200LB"), Bundle.getMessage("Baud57600LB")};
    protected int[] validSpeedValues = new int[]{19200, 57600};
    protected String[] validOption1 = new String[]{Bundle.getMessage("FlowOptionHwRecomm"), Bundle.getMessage("FlowOptionNo")};
    private boolean opened = false;
    InputStream serialStream = null;
    private static String[][] packetizers = new String[][]{{Bundle.getMessage("PacketizerTypelnPacketizer"), "lnPacketizer"}, {Bundle.getMessage("PacketizerTypelnPacketizerStrict"), "lnPacketizerStrict"}};
    private static final Logger log = LoggerFactory.getLogger(LocoBufferAdapter.class);

    public LocoBufferAdapter() {
        this(new LocoNetSystemConnectionMemo());
    }

    public LocoBufferAdapter(LocoNetSystemConnectionMemo adapterMemo) {
        super(adapterMemo);
        this.option1Name = "FlowControl";
        this.option2Name = "CommandStation";
        this.option3Name = "TurnoutHandle";
        this.option4Name = "PacketizerType";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("XconnectionUsesLabel", Bundle.getMessage("TypeSerial")), this.validOption1));
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("CommandStationTypeLabel"), this.getCommandStationListWithStandaloneLN(), false));
        this.options.put(this.option3Name, new AbstractPortController.Option(Bundle.getMessage("TurnoutHandling"), new String[]{Bundle.getMessage("HandleNormal"), Bundle.getMessage("HandleSpread"), Bundle.getMessage("HandleOneOnly"), Bundle.getMessage("HandleBoth")}));
        this.options.put(this.option4Name, new AbstractPortController.Option(Bundle.getMessage("PacketizerTypeLabel"), this.packetizerOptions()));
        this.options.put("TranspondingPresent", new AbstractPortController.Option(Bundle.getMessage("TranspondingPresent"), new String[]{Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonYes")}));
    }

    public String[] getCommandStationListWithStandaloneLN() {
        String[] result = new String[this.commandStationNames.length + 1];
        int i = 0;
        while (i < result.length - 1) {
            result[i] = this.commandStationNames[i];
            ++i;
        }
        result[this.commandStationNames.length] = LnCommandStationType.COMMAND_STATION_STANDALONE.getName();
        return result;
    }

    @Override
    public Vector<String> getPortNames() {
        this.portNameVector = new Vector();
        Enumeration<CommPortIdentifier> portIDs = CommPortIdentifier.getPortIdentifiers();
        while (portIDs.hasMoreElements()) {
            CommPortIdentifier id = portIDs.nextElement();
            if (id.getPortType() == 2) continue;
            this.portNameVector.addElement(id.getName());
        }
        return this.portNameVector;
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.setSerialPort(this.activeSerialPort);
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            try {
                this.activeSerialPort.enableReceiveTimeout(10);
                log.debug("Serial timeout was observed as: {} enabled: {} threshold: {} enabled: {}", new Object[]{this.activeSerialPort.getReceiveTimeout(), this.activeSerialPort.isReceiveTimeoutEnabled(), this.activeSerialPort.getReceiveThreshold(), this.activeSerialPort.isReceiveThresholdEnabled()});
            }
            catch (Exception et) {
                log.info("failed to set serial timeout: ", (Throwable)et);
            }
            this.serialStream = this.activeSerialPort.getInputStream();
            this.purgeStream(this.serialStream);
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud with DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
            if (log.isDebugEnabled()) {
                log.debug(" port flow control shows {}", (Object)(this.activeSerialPort.getFlowControlMode() == 2 ? "hardware flow control" : "no flow control"));
                this.setPortEventLogging(this.activeSerialPort);
            }
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException ex) {
            log.error("Unexpected exception while opening port {} trace follows:", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    @Override
    public boolean okToSend() {
        return this.activeSerialPort.isCTS();
    }

    @Override
    public void configure() {
        this.setCommandStationType(this.getOptionState(this.option2Name));
        this.setTurnoutHandling(this.getOptionState(this.option3Name));
        this.setTranspondingAvailable(this.getOptionState("TranspondingPresent"));
        LnPacketizer packets = this.getPacketizer(this.getOptionState(this.option4Name));
        packets.connectPort(this);
        this.getSystemConnectionMemo().setLnTrafficController(packets);
        this.getSystemConnectionMemo().configureCommandStation(this.commandStationType, this.mTurnoutNoRetry, this.mTurnoutExtraSpace, this.mTranspondingAvailable);
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.activeSerialPort.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    protected void setSerialPort(SerialPort activeSerialPort) throws UnsupportedCommOperationException {
        int baud = this.currentBaudNumber(this.mBaudRate);
        activeSerialPort.setSerialPortParams(baud, 8, 1, 0);
        int flow = 2;
        if (this.getOptionState(this.option1Name).equals(this.validOption1[1])) {
            flow = 0;
        }
        this.configureLeadsAndFlowControl(activeSerialPort, flow);
        log.info("LocoBuffer (serial) adapter{}{} RTSCTS_OUT=2 RTSCTS_IN=1", (Object)(activeSerialPort.getFlowControlMode() == 2 ? " set hardware flow control, mode=" : " set no flow control, mode="), (Object)activeSerialPort.getFlowControlMode());
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    private String[] packetizerOptions() {
        String[] retval = new String[packetizers.length];
        int i = 0;
        while (i < packetizers.length) {
            retval[i] = packetizers[i][0];
            ++i;
        }
        return retval;
    }

    protected String getPacketizerOption(String s) {
        int i = 0;
        while (i < packetizers.length) {
            if (packetizers[i][0].equals(s)) {
                return packetizers[i][1];
            }
            ++i;
        }
        return "lnPacketizer";
    }

    protected LnPacketizer getPacketizer(String s) {
        LnPacketizer packets;
        String packetSelection;
        switch (packetSelection = this.getPacketizerOption(s)) {
            case "lnPacketizer": {
                packets = new LnPacketizer(this.getSystemConnectionMemo());
                break;
            }
            case "lnPacketizerStrict": {
                packets = new LnPacketizerStrict(this.getSystemConnectionMemo());
                break;
            }
            default: {
                packets = new LnPacketizer(this.getSystemConnectionMemo());
                log.warn("Using Normal do not understand option [{}]", (Object)packetSelection);
            }
        }
        return packets;
    }
}

