/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.lnsvf2;

import java.util.Locale;
import java.util.Objects;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.lnsvf2.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnSv2MessageContents {
    private int src;
    private int sv_cmd;
    private int dst_l;
    private int dst_h;
    private int dst;
    private int sv_adrl;
    private int sv_adrh;
    private int sv_adr;
    private int d1;
    private int d2;
    private int d3;
    private int d4;
    public static final int SV2_LENGTH_ELEMENT_VALUE = 16;
    public static final int SV2_LENGTH_ELEMENT_INDEX = 1;
    public static final int SV2_SRC_ELEMENT_INDEX = 2;
    public static final int SV2_SV_CMD_ELEMENT_INDEX = 3;
    public static final int SV2_SV_TYPE_ELEMENT_INDEX = 4;
    public static final int SV2_SVX1_ELEMENT_INDEX = 5;
    public static final int SV2_SV_DST_L_ELEMENT_INDEX = 6;
    public static final int SV2_SV_DST_H_ELEMENT_INDEX = 7;
    public static final int SV2_SV_ADRL_ELEMENT_INDEX = 8;
    public static final int SV2_SV_ADRH_ELEMENT_INDEX = 9;
    public static final int SV2_SVX2_ELEMENT_INDEX = 10;
    public static final int SV2_SVD1_ELEMENT_INDEX = 11;
    public static final int SV2_SVD2_ELEMENT_INDEX = 12;
    public static final int SV2_SVD3_ELEMENT_INDEX = 13;
    public static final int SV2_SVD4_ELEMENT_INDEX = 14;
    public static final int SV2_SRC_ELEMENT_MASK = 127;
    public static final int SV2_SVX1_ELEMENT_VALIDITY_CHECK_MASK = 112;
    public static final int SV2_SVX1_ELEMENT_VALIDITY_CHECK_VALUE = 16;
    public static final int SV2_SV_DST_L_DSTLX7_CHECK_MASK = 1;
    public static final int SV2_SV_DST_H_DSTHX7_CHECK_MASK = 2;
    public static final int SV2_SV_ADRL_SVADRL7_CHECK_MASK = 4;
    public static final int SV2_SV_ADRH_SVADRH7_CHECK_MASK = 8;
    public static final int SV2_SVX2_ELEMENT_VALIDITY_CHECK_MASK = 112;
    public static final int SV2_SVX2_ELEMENT_VALIDITY_CHECK_VALUE = 16;
    public static final int SV2_SV_D1_D1X7_CHECK_MASK = 1;
    public static final int SV2_SV_D2_D2X7_CHECK_MASK = 2;
    public static final int SV2_SV_D3_D3X7_CHECK_MASK = 4;
    public static final int SV2_SV_D4_D4X7_CHECK_MASK = 8;
    public static final int SV2_SV_TYPE_ELEMENT_VALIDITY_CHECK_MASK = 127;
    public static final int SV2_SV_TYPE_ELEMENT_VALIDITY_CHECK_VALUE = 2;
    public static final int SV_CMD_WRITE_ONE = 1;
    public static final int SV_CMD_WRITE_ONE_REPLY = 65;
    public static final int SV_CMD_QUERY_ONE = 2;
    public static final int SV_CMD_REPORT_ONE = 66;
    public static final int SV_CMD_WRITE_ONE_MASKED = 3;
    public static final int SV_CMD_WRITE_ONE_MASKED_REPLY = 67;
    public static final int SV_CMD_WRITE_FOUR = 5;
    public static final int SV_CMD_WRITE_FOUR_REPLY = 69;
    public static final int SV_CMD_QUERY_FOUR = 6;
    public static final int SV_CMD_REPORT_FOUR = 70;
    public static final int SV_CMD_DISCOVER_DEVICES_QUERY = 7;
    public static final int SV_CMD_DISCOVER_DEVICE_REPORT = 71;
    public static final int SV_CMD_IDENTIFY_DEVICE_BY_DEVICE_ADDRESS = 8;
    public static final int SV_CMD_IDENTIFY_DEVICE_BY_DEVICE_ADDRESS_REPLY = 72;
    public static final int SV_CMD_CHANGE_ADDRESS_REQUEST = 9;
    public static final int SV_CMD_CHANGE_ADDRESS_REPLY = 73;
    public static final int SV_CMD_RECONFIGURE_REQUEST = 15;
    public static final int SV_CMD_RECONFIGURE_REPLY = 79;
    public static final int SV2_SV_CMD_REPLY_BIT_NUMBER = 6;
    public static final int SV2_SV_CMD_REPLY_BIT_MASK = 4;
    public static final int SV2_SV_DATA_INDEX_EEPROM_SIZE = 1;
    public static final int SV2_SV_DATA_INDEX_SOFTWARE_VERSION = 2;
    public static final int SV2_SV_DATA_INDEX_SERIAL_NUMBER_LOW = 3;
    public static final int SV2_SV_DATA_INDEX_SERIAL_NUMBER_HIGH = 4;
    private static final Logger log = LoggerFactory.getLogger(LnSv2MessageContents.class);

    public LnSv2MessageContents(LocoNetMessage m) throws IllegalArgumentException {
        log.debug("interpreting a LocoNet message - may be an SV2 message");
        if (!LnSv2MessageContents.isSupportedSv2Message(m)) {
            log.debug("interpreting a LocoNet message - is NOT an SV2 message");
            throw new IllegalArgumentException("LocoNet message is not an SV2 message");
        }
        this.src = m.getElement(2);
        int svx1 = m.getElement(5);
        int svx2 = m.getElement(10);
        this.sv_cmd = m.getElement(3);
        this.dst_l = m.getElement(6) + ((svx1 & 1) == 1 ? 128 : 0);
        this.dst_h = m.getElement(7) + ((svx1 & 2) == 2 ? 128 : 0);
        this.dst = this.dst_l + 256 * this.dst_h;
        this.sv_adrl = m.getElement(8) + ((svx1 & 4) == 4 ? 128 : 0);
        this.sv_adrh = m.getElement(9) + ((svx1 & 8) == 8 ? 128 : 0);
        this.sv_adr = this.sv_adrl + 256 * this.sv_adrh;
        this.d1 = m.getElement(11) + ((svx2 & 1) == 1 ? 128 : 0);
        this.d2 = m.getElement(12) + ((svx2 & 2) == 2 ? 128 : 0);
        this.d3 = m.getElement(13) + ((svx2 & 4) == 4 ? 128 : 0);
        this.d4 = m.getElement(14) + ((svx2 & 8) == 8 ? 128 : 0);
    }

    public static boolean isSupportedSv2Message(LocoNetMessage m) {
        if (m.getOpCode() != 229) {
            log.debug("cannot be SV2 message because not OPC_PEER_XFER");
            return false;
        }
        if (m.getElement(1) != 16) {
            log.debug("cannot be SV2 message because not length 0x10");
            return false;
        }
        if ((m.getElement(4) & 0x7F) != 2) {
            log.debug("cannot be SV2 message because type byte not correct");
            return false;
        }
        if ((m.getElement(5) & 0x70) != 16) {
            log.debug("cannot be SV2 message because SVX1 upper nibble wrong");
            return false;
        }
        if ((m.getElement(10) & 0x70) != 16) {
            log.debug("cannot be SV2 message because SVX2 upper nibble wrong");
            return false;
        }
        if (LnSv2MessageContents.isSupportedSv2Command(m.getElement(3))) {
            log.debug("LocoNet message is a supported SV Format 2 message");
            return true;
        }
        log.debug("LocoNet message is not a supported SV Format 2 message");
        return false;
    }

    public static boolean isLnMessageASpecificSv2Command(LocoNetMessage m, Sv2Command svCmd) {
        if (m.getOpCode() != 229) {
            log.debug("cannot be SV2 message because not OPC_PEER_XFER");
            return false;
        }
        if (m.getElement(1) != 16) {
            log.debug("cannot be SV2 message because not length 0x10");
            return false;
        }
        if ((m.getElement(4) & 0x7F) != 2) {
            log.debug("cannot be SV2 message because type byte not correct");
            return false;
        }
        if ((m.getElement(5) & 0x70) != 16) {
            log.debug("cannot be SV2 message because SVX1 upper nibble wrong");
            return false;
        }
        if ((m.getElement(10) & 0x70) != 16) {
            log.debug("cannot be SV2 message because SVX2 upper nibble wrong");
            return false;
        }
        if (LnSv2MessageContents.isSupportedSv2Command(m.getElement(3))) {
            log.debug("LocoNet message is a supported SV Format 2 message");
            if (Objects.equals((Object)LnSv2MessageContents.extractMessageType(m), (Object)svCmd)) {
                log.debug("LocoNet message is the specified SV Format 2 message");
                return true;
            }
        }
        log.debug("LocoNet message is not a supported SV Format 2 message");
        return false;
    }

    public static Sv2Command extractMessageType(LocoNetMessage m) {
        if (LnSv2MessageContents.isSupportedSv2Message(m)) {
            int msgCmd = m.getElement(3);
            Sv2Command[] sv2CommandArray = Sv2Command.values();
            int n = sv2CommandArray.length;
            int n2 = 0;
            while (n2 < n) {
                Sv2Command s = sv2CommandArray[n2];
                if (s.getCmd() == msgCmd) {
                    log.debug("LocoNet message has SV2 message command {}", (Object)msgCmd);
                    return s;
                }
                ++n2;
            }
        }
        return null;
    }

    public String toString() {
        Locale l = Locale.getDefault();
        return this.toString(l);
    }

    public String toString(Locale locale) {
        String returnString;
        log.debug("interpreting an SV2 message - cmd is {}", (Object)this.sv_cmd);
        switch (this.sv_cmd) {
            case 1: {
                returnString = Bundle.getMessage(locale, "SV2_WRITE_ONE_INTERPRETED", this.src, this.dst, this.sv_adr, this.d1);
                break;
            }
            case 65: {
                returnString = Bundle.getMessage(locale, "SV2_WRITE_ONE_REPLY_INTERPRETED", this.src, this.dst, this.sv_adr, this.d1);
                break;
            }
            case 2: {
                returnString = Bundle.getMessage(locale, "SV2_READ_ONE_REQUEST_INTERPRETED", this.src, this.dst, this.sv_adr);
                break;
            }
            case 66: {
                returnString = Bundle.getMessage(locale, "SV2_READ_ONE_REPORT_INTERPRETED", this.src, this.dst, this.sv_adr, this.d1);
                break;
            }
            case 3: {
                returnString = Bundle.getMessage(locale, "SV2_WRITE_ONE_MASKED_INTERPRETED", this.src, this.dst, this.sv_adr, this.d1, this.d2);
                break;
            }
            case 67: {
                returnString = Bundle.getMessage(locale, "SV2_WRITE_ONE_MASKED_REPLY_INTERPRETED", this.src, this.dst, this.sv_adr, this.d1, this.d2);
                break;
            }
            case 5: {
                returnString = Bundle.getMessage(locale, "SV2_WRITE_FOUR_INTERPRETED", this.src, this.dst, this.sv_adr, this.sv_adr + 3, this.d1, this.d2, this.d3, this.d4);
                break;
            }
            case 69: {
                returnString = Bundle.getMessage(locale, "SV2_WRITE_FOUR_REPLY_INTERPRETED", this.src, this.dst, this.sv_adr, this.sv_adr + 3, this.d1, this.d2, this.d3, this.d4);
                break;
            }
            case 6: {
                returnString = Bundle.getMessage(locale, "SV2_READ_FOUR_REQUEST_INTERPRETED", this.src, this.dst, this.sv_adr, this.sv_adr + 3);
                break;
            }
            case 70: {
                returnString = Bundle.getMessage(locale, "SV2_READ_FOUR_REPORT_INTERPRETED", this.src, this.dst, this.sv_adr, this.sv_adr + 3, this.d1, this.d2, this.d3, this.d4);
                break;
            }
            case 7: {
                returnString = Bundle.getMessage(locale, "SV2_DISCOVER_DEVICES_INTERPRETED", this.src);
                break;
            }
            case 71: {
                returnString = Bundle.getMessage(locale, "SV2_DEVICE_TYPE_REPORT_INTERPRETED", this.src, this.dst, this.sv_adrl, this.sv_adrh, this.d1 + 256 * this.d2, this.d3 + 256 * this.d4);
                break;
            }
            case 8: {
                returnString = Bundle.getMessage(locale, "SV2_IDENTIFY_DEVICE_REQUEST_INTERPRETED", this.src, this.dst);
                break;
            }
            case 72: {
                returnString = Bundle.getMessage(locale, "SV2_DEVICE_IDENTITY_REPORT_INTERPRETED", this.src, this.dst, this.sv_adrl, this.sv_adrh, this.d1 + 256 * this.d2, this.d3 + 256 * this.d4);
                break;
            }
            case 9: {
                returnString = Bundle.getMessage(locale, "SV2_CHANGE_ADDRESS_REQUEST_INTERPRETED", this.src, this.dst, this.sv_adrl, this.sv_adrh, this.d1 + 256 * this.d2, this.d3 + 256 * this.d4);
                break;
            }
            case 73: {
                if (this.sv_adrl == 0 && this.sv_adrh == 0 && this.d1 == 0 && this.d2 == 0 && this.d3 == 0 && this.d4 == 0) {
                    returnString = Bundle.getMessage(locale, "SV2_CHANGE_ADDRESS_REPLY_NEEDS_RECONFIGURE_INTERPRETED", this.src, this.dst);
                    break;
                }
                returnString = Bundle.getMessage(locale, "SV2_CHANGE_ADDRESS_REPLY_INTERPRETED", this.src, this.dst, this.sv_adrl, this.sv_adrh, this.d1 + 256 * this.d2, this.d3 + 256 * this.d4);
                break;
            }
            case 15: {
                returnString = Bundle.getMessage(locale, "SV2_RECONFIGURE_REQUEST_INTERPRETED", this.src, this.dst);
                break;
            }
            case 79: {
                returnString = Bundle.getMessage(locale, "SV2_DEVICE_RECONFIGURE_REPLY_INTERPRETED", this.src, this.dst, this.sv_adrl, this.sv_adrh, this.d1 + 256 * this.d2, this.d3 + 256 * this.d4);
                break;
            }
            default: {
                return String.valueOf(Bundle.getMessage(locale, "SV2_UNDEFINED_MESSAGE", new Object[0])) + "\n";
            }
        }
        log.debug("interpreted: {}", (Object)returnString);
        return String.valueOf(returnString) + "\n";
    }

    public static boolean isSupportedSv2Command(int possibleCmd) {
        switch (possibleCmd) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 79: {
                return true;
            }
        }
        return false;
    }

    public boolean isSupportedSv2Command() {
        return LnSv2MessageContents.isSupportedSv2Command(this.sv_cmd);
    }

    public boolean isSupportedSv2ReadOneReply() {
        return this.sv_cmd == 66;
    }

    public boolean isSupportedSv2ReadFourReply() {
        return this.sv_cmd == 70;
    }

    public boolean isSupportedSv2ReadOneReplyOrSv2ReadFourReply() {
        return this.sv_cmd == 66 || this.sv_cmd == 70;
    }

    public int getSingleReadReportData() {
        return this.d1;
    }

    public static LocoNetMessage createSv2Message(int source, int command, int destination, int svNum, int d1, int d2, int d3, int d4) throws IllegalArgumentException {
        if (!LnSv2MessageContents.isSupportedSv2Command(command)) {
            throw new IllegalArgumentException("Command is not a supported SV2 command");
        }
        LocoNetMessage m = new LocoNetMessage(16);
        m.setOpCode(229);
        m.setElement(1, 16);
        m.setElement(2, source & 0x7F);
        m.setElement(3, command);
        m.setElement(4, 2);
        int svx1 = 16;
        svx1 += (destination & 0x80) == 128 ? 1 : 0;
        svx1 += (destination & 0x8000) == 32768 ? 2 : 0;
        svx1 += (svNum & 0x80) == 128 ? 4 : 0;
        m.setElement(5, svx1 += (svNum & 0x8000) == 32768 ? 8 : 0);
        m.setElement(6, destination & 0x7F);
        m.setElement(7, destination >> 8 & 0x7F);
        m.setElement(8, svNum & 0x7F);
        m.setElement(9, svNum >> 8 & 0x7F);
        int svx2 = 16;
        svx2 += (d1 & 0x80) == 128 ? 1 : 0;
        svx2 += (d2 & 0x80) == 128 ? 2 : 0;
        svx2 += (d3 & 0x80) == 128 ? 4 : 0;
        m.setElement(10, svx2 += (d4 & 0x80) == 128 ? 8 : 0);
        m.setElement(11, d1 & 0x7F);
        m.setElement(12, d2 & 0x7F);
        m.setElement(13, d3 & 0x7F);
        m.setElement(14, d4 & 0x7F);
        return m;
    }

    public int getDestAddr() {
        if (this.sv_cmd != Sv2Command.SV2_DISCOVER_ALL.cmd) {
            return this.dst_l + 256 * this.dst_h;
        }
        return -1;
    }

    public int getSVNum() {
        if (this.sv_cmd != Sv2Command.SV2_DISCOVER_ALL.cmd && this.sv_cmd != Sv2Command.SV2_IDENTIFY_DEVICES_BY_TYPE.cmd && this.sv_cmd != Sv2Command.SV2_CHANGE_DEVICE_ADDRESS.cmd && this.sv_cmd != Sv2Command.SV2_DISCOVER_DEVICE_REPORT.cmd && this.sv_cmd != Sv2Command.SV2_DEVICE_TYPE_REPORT.cmd && this.sv_cmd != Sv2Command.SV2_CHANGE_DEVICE_ADDRESS_REPLY.cmd && this.sv_cmd != Sv2Command.SV2_RECONFIGURE_DEVICE_REPLY.cmd && this.sv_cmd != Sv2Command.SV2_RECONFIGURE_DEVICE.cmd) {
            return this.sv_adrl + 256 * this.sv_adrh;
        }
        return -1;
    }

    public int getSv2ManufacturerID() {
        if (this.sv_cmd == Sv2Command.SV2_DISCOVER_DEVICE_REPORT.cmd || this.sv_cmd == Sv2Command.SV2_DEVICE_TYPE_REPORT.cmd) {
            return this.sv_adrl;
        }
        return -1;
    }

    public boolean isSvReconfigureReply() {
        return this.sv_cmd == Sv2Command.SV2_RECONFIGURE_DEVICE_REPLY.cmd;
    }

    public int getSv2DeveloperID() {
        if (this.sv_cmd == Sv2Command.SV2_CHANGE_DEVICE_ADDRESS.cmd || this.sv_cmd == Sv2Command.SV2_DISCOVER_DEVICE_REPORT.cmd || this.sv_cmd == Sv2Command.SV2_DEVICE_TYPE_REPORT.cmd) {
            return this.sv_adrh;
        }
        return -1;
    }

    public int getSv2ProductID() {
        if (this.sv_cmd == Sv2Command.SV2_CHANGE_DEVICE_ADDRESS.cmd || this.sv_cmd == Sv2Command.SV2_DISCOVER_DEVICE_REPORT.cmd || this.sv_cmd == Sv2Command.SV2_DEVICE_TYPE_REPORT.cmd || this.sv_cmd == Sv2Command.SV2_RECONFIGURE_DEVICE_REPLY.cmd) {
            return this.d1 + this.d2 * 256;
        }
        return -1;
    }

    public int getSv2SerialNum() {
        if (this.sv_cmd == Sv2Command.SV2_CHANGE_DEVICE_ADDRESS.cmd || this.sv_cmd == Sv2Command.SV2_DISCOVER_DEVICE_REPORT.cmd || this.sv_cmd == Sv2Command.SV2_DEVICE_TYPE_REPORT.cmd || this.sv_cmd == Sv2Command.SV2_RECONFIGURE_DEVICE_REPLY.cmd) {
            return this.d3 + this.d4 * 256;
        }
        return -1;
    }

    public static LocoNetMessage createSv2DeviceDiscoveryReply(int ida, int currentDest, int mfg, int devel, int prodID, int serial) {
        return LnSv2MessageContents.createSv2Message(ida, Sv2Command.SV2_DISCOVER_DEVICE_REPORT.cmd, currentDest, mfg + 256 * devel, prodID % 256, prodID / 256, serial % 256, serial / 256);
    }

    public static LocoNetMessage createSv2ChangeAddressReply(int ida, int destAddr) {
        return LnSv2MessageContents.createSv2Message(ida, Sv2Command.SV2_CHANGE_DEVICE_ADDRESS_REPLY.cmd, destAddr, 0, 0, 0, 0, 0);
    }

    public static LocoNetMessage createSv2ChangeAddressReply(int ida, int newDestAddr, int mfg, int developer, int productId, int serialNum) {
        return LnSv2MessageContents.createSv2Message(ida, Sv2Command.SV2_CHANGE_DEVICE_ADDRESS_REPLY.cmd, newDestAddr, mfg + 256 * developer, productId % 256, productId / 256, serialNum % 256, serialNum / 256);
    }

    public static LocoNetMessage createSv2ReconfigureReply(int ida, int newDestAddr, int mfg, int developer, int productId, int serialNum) {
        return LnSv2MessageContents.createSv2Message(ida, Sv2Command.SV2_RECONFIGURE_DEVICE_REPLY.cmd, newDestAddr, mfg + 256 * developer, productId % 256, productId / 256, serialNum % 256, serialNum / 256);
    }

    public static LocoNetMessage createSvReadReply(LocoNetMessage m, int[] svValues) {
        if (!LnSv2MessageContents.isSupportedSv2Message(m)) {
            return null;
        }
        if (m.getElement(3) != Sv2Command.SV2_QUERY_ONE.cmd && m.getElement(3) != Sv2Command.SV2_QUERY_FOUR.cmd) {
            return null;
        }
        LocoNetMessage n = m;
        n.setElement(3, n.getElement(3) + 64);
        n.setElement(11, svValues[0] & 0x7F);
        if (n.getElement(3) == Sv2Command.SV2_QUERY_ONE.cmd) {
            n.setElement(12, 0);
            n.setElement(13, 0);
            n.setElement(14, 0);
            int a = n.getElement(10);
            a &= 0x70;
            if ((svValues[0] & 0xFF) > 127) {
                a |= 1;
            }
            n.setElement(10, a);
            return n;
        }
        n.setElement(12, svValues[1] & 0x7F);
        n.setElement(13, svValues[2] & 0x7F);
        n.setElement(14, svValues[3] & 0x7F);
        int a = n.getElement(10);
        a &= 0x70;
        a |= (svValues[1] & 0x80) >> 6;
        a |= (svValues[2] & 0x80) >> 5;
        n.setElement(10, a |= (svValues[3] & 0x80) >> 5);
        return n;
    }

    public static LocoNetMessage createSvReadReply(LocoNetMessage m, int svValue) {
        return LnSv2MessageContents.createSvReadReply(m, new int[]{svValue});
    }

    public int getSv2D1() {
        return this.d1;
    }

    public int getSv2D2() {
        return this.d2;
    }

    public int getSv2D3() {
        return this.d3;
    }

    public int getSv2D4() {
        return this.d4;
    }

    public boolean isSvChangeAddressReply() {
        return this.sv_cmd == Sv2Command.SV2_CHANGE_DEVICE_ADDRESS_REPLY.cmd;
    }

    public static LocoNetMessage createSvDiscoverQueryMessage() {
        return LnSv2MessageContents.createSv2Message(1, Sv2Command.SV2_DISCOVER_ALL.cmd, 0, 0, 0, 0, 0, 0);
    }

    public static LocoNetMessage createSvReadRequest() {
        return LnSv2MessageContents.createSv2Message(1, Sv2Command.SV2_DISCOVER_ALL.cmd, 0, 0, 0, 0, 0, 0);
    }

    public static LocoNetMessage createSvReadRequest(int deviceAddress, int svNum) {
        return LnSv2MessageContents.createSv2Message(1, Sv2Command.SV2_QUERY_ONE.cmd, deviceAddress, svNum, 0, 0, 0, 0);
    }

    public static enum Sv2Command {
        SV2_WRITE_ONE(1),
        SV2_QUERY_ONE(2),
        SV2_WRITE_ONE_MASKED(3),
        SV2_WRITE_FOUR(5),
        SV2_QUERY_FOUR(6),
        SV2_DISCOVER_ALL(7),
        SV2_IDENTIFY_DEVICES_BY_TYPE(8),
        SV2_CHANGE_DEVICE_ADDRESS(9),
        SV2_RECONFIGURE_DEVICE(15),
        SV2_WRITE_ONE_REPLY(65),
        SV2_REPORT_ONE(66),
        SV2_WRITE_ONE_MASKED_REPLYL(67),
        SV2_WRITE_FOUR_REPLY(69),
        SV2_REPORT_FOUR(70),
        SV2_DISCOVER_DEVICE_REPORT(71),
        SV2_DEVICE_TYPE_REPORT(72),
        SV2_CHANGE_DEVICE_ADDRESS_REPLY(73),
        SV2_RECONFIGURE_DEVICE_REPLY(79);

        private final int cmd;

        private Sv2Command(int cmd) {
            this.cmd = cmd;
        }

        int getCmd() {
            return this.cmd;
        }

        public static int getCmd(Sv2Command mt) {
            return mt.getCmd();
        }
    }
}

