/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.hexfile.configurexml;

import java.awt.GraphicsEnvironment;
import jmri.jmrix.configurexml.AbstractSerialConnectionConfigXml;
import jmri.jmrix.loconet.hexfile.ConnectionConfig;
import jmri.jmrix.loconet.hexfile.HexFileFrame;
import jmri.jmrix.loconet.hexfile.HexFileServer;
import jmri.jmrix.loconet.hexfile.LnHexFilePort;
import org.jdom2.Element;

public class ConnectionConfigXml
extends AbstractSerialConnectionConfigXml {
    @Override
    public Element store(Object o) {
        this.getInstance(o);
        Element e = new Element("connection");
        if (this.adapter.getSystemConnectionMemo() != null) {
            e.setAttribute("userName", this.adapter.getSystemConnectionMemo().getUserName());
            e.setAttribute("systemPrefix", this.adapter.getSystemConnectionMemo().getSystemPrefix());
        }
        if (this.adapter.getManufacturer() != null) {
            e.setAttribute("manufacturer", this.adapter.getManufacturer());
        }
        this.saveOptions(e, this.adapter);
        if (this.adapter.getDisabled()) {
            e.setAttribute("disabled", "yes");
        } else {
            e.setAttribute("disabled", "no");
        }
        e.setAttribute("class", this.getClass().getName());
        return e;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        String yesno;
        HexFileFrame f = null;
        HexFileServer hfs = null;
        this.getInstance();
        if (!GraphicsEnvironment.isHeadless()) {
            f = new HexFileFrame();
            f.setAdapter((LnHexFilePort)this.adapter);
            try {
                f.initComponents();
            }
            catch (Exception exception) {}
            f.pack();
            f.setVisible(true);
        } else {
            hfs = new HexFileServer();
            hfs.setAdapter((LnHexFilePort)this.adapter);
        }
        if (shared.getAttribute("option1") != null) {
            String option1Setting = shared.getAttribute("option1").getValue();
            this.adapter.configureOption1(option1Setting);
        }
        if (shared.getAttribute("option2") != null) {
            String option2Setting = shared.getAttribute("option2").getValue();
            this.adapter.configureOption2(option2Setting);
        }
        if (shared.getAttribute("option3") != null) {
            String option3Setting = shared.getAttribute("option3").getValue();
            this.adapter.configureOption3(option3Setting);
        }
        if (shared.getAttribute("option4") != null) {
            String option4Setting = shared.getAttribute("option4").getValue();
            this.adapter.configureOption4(option4Setting);
        }
        this.loadOptions(shared.getChild("options"), perNode.getChild("options"), this.adapter);
        try {
            String manufacturer = shared.getAttribute("manufacturer").getValue();
            this.adapter.setManufacturer(manufacturer);
        }
        catch (NullPointerException nullPointerException) {}
        if (this.adapter.getSystemConnectionMemo() != null) {
            if (shared.getAttribute("userName") != null) {
                this.adapter.getSystemConnectionMemo().setUserName(shared.getAttribute("userName").getValue());
            }
            if (shared.getAttribute("systemPrefix") != null) {
                this.adapter.getSystemConnectionMemo().setSystemPrefix(shared.getAttribute("systemPrefix").getValue());
            }
        }
        if (shared.getAttribute("disabled") != null && (yesno = shared.getAttribute("disabled").getValue()) != null && !yesno.equals("")) {
            if (yesno.equals("no")) {
                this.adapter.setDisabled(false);
            } else if (yesno.equals("yes")) {
                this.adapter.setDisabled(true);
            }
        }
        this.register();
        if (this.adapter.getDisabled()) {
            if (!GraphicsEnvironment.isHeadless() && f != null) {
                f.setVisible(false);
            }
            return true;
        }
        if (!GraphicsEnvironment.isHeadless() && f != null) {
            f.configure();
        } else if (hfs != null) {
            hfs.configure();
        }
        return true;
    }

    @Override
    protected void getInstance(Object object) {
        this.adapter = ((ConnectionConfig)object).getAdapter();
    }

    @Override
    protected void getInstance() {
        this.adapter = new LnHexFilePort();
    }

    @Override
    protected void register() {
        this.register(new ConnectionConfig(this.adapter));
    }
}

