/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.hexfile;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Sensor;
import jmri.jmrix.loconet.LnSensor;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.hexfile.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="This is in effect the same as its super class")
public class LnSensorManager
extends jmri.jmrix.loconet.LnSensorManager {
    private int defaultSensorState = 1;
    private static final Logger log = LoggerFactory.getLogger(LnSensorManager.class);

    public LnSensorManager(LocoNetSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        LnSensor s = new LnSensor(systemName, userName, this.tc, this.getSystemPrefix());
        if (this.defaultSensorState != 1) {
            try {
                s.setKnownState(this.defaultSensorState);
            }
            catch (JmriException e) {
                log.warn("Error setting state: ", (Throwable)e);
            }
        }
        return s;
    }

    public void setDefaultSensorState(String state) {
        this.defaultSensorState = state.equals(Bundle.getMessage("SensorStateInactive")) ? 4 : (state.equals(Bundle.getMessage("SensorStateActive")) ? 2 : 1);
    }
}

