/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.loconet.hexfile;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.loconet.LnPortController;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.hexfile.Bundle;
import jmri.jmrix.loconet.hexfile.HexFileFrame;
import jmri.jmrix.loconet.hexfile.HexFileSystemConnectionMemo;
import jmri.jmrix.loconet.lnsvf2.LnSv2MessageContents;
import jmri.jmrix.loconet.uhlenbrock.LncvMessageContents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LnHexFilePort
extends LnPortController
implements Runnable {
    volatile BufferedReader sFile = null;
    public boolean threadSuspended = false;
    private boolean _running = false;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private int delay = 100;
    private boolean simReply = false;
    private static final Logger log = LoggerFactory.getLogger(LnHexFilePort.class);

    public LnHexFilePort() {
        this(new HexFileSystemConnectionMemo());
    }

    public LnHexFilePort(LocoNetSystemConnectionMemo memo) {
        super(memo);
        try {
            PipedInputStream tempPipe = new PipedInputStream();
            this.pin = new DataInputStream(tempPipe);
            this.pout = this.outpipe = new DataOutputStream(new PipedOutputStream(tempPipe));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
        }
        this.options.put("MaxSlots", new AbstractPortController.Option(String.valueOf(Bundle.getMessage("MaxSlots")) + ":", new String[]{"5", "10", "21", "120", "400"}));
        this.options.put("SensorDefaultState", new AbstractPortController.Option(String.valueOf(Bundle.getMessage("DefaultSensorState")) + ":", new String[]{Bundle.getMessage("BeanStateUnknown"), Bundle.getMessage("SensorStateInactive"), Bundle.getMessage("SensorStateActive")}, true));
    }

    public void load(File file) {
        log.debug("file: {}", (Object)file);
        try {
            this.sFile = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        }
        catch (Exception e) {
            log.error("load (pipe): Exception: {}", (Object)e.toString());
        }
    }

    @Override
    public void connect() {
        HexFileFrame f = new HexFileFrame();
        f.setAdapter(this);
        try {
            f.initComponents();
        }
        catch (Exception ex) {
            log.warn("starting HexFileFrame exception: {}", (Object)ex.toString());
        }
        f.configure();
    }

    public synchronized void suspendReading(boolean suspended) {
        this.threadSuspended = suspended;
        if (!this.threadSuspended) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("LocoNet Simulator Started");
        while (true) {
            if (this.sFile == null) {
                try {
                    LnHexFilePort lnHexFilePort = this;
                    synchronized (lnHexFilePort) {
                        this.wait(1000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    log.info("LnHexFilePort.run: woken from sleep");
                    if (this.sFile != null) continue;
                    log.error("LnHexFilePort.run: unexpected InterruptedException, exiting");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            log.info("LnHexFilePort.run: changing input file...");
            this._running = true;
            try {
                String s;
                BufferedReader currFile = this.sFile;
                this.sFile = null;
                while ((s = currFile.readLine()) != null) {
                    int len = s.length();
                    int i = 0;
                    while (i < len) {
                        int ival = Integer.valueOf(s.substring(i, i + 2), 16);
                        byte bval = (byte)ival;
                        this.outpipe.writeByte(bval);
                        i += 3;
                    }
                    this.outpipe.flush();
                    LnHexFilePort lnHexFilePort = this;
                    synchronized (lnHexFilePort) {
                        this.wait(this.delay);
                    }
                    if (!this.threadSuspended) continue;
                    lnHexFilePort = this;
                    synchronized (lnHexFilePort) {
                        while (this.threadSuspended) {
                            this.wait();
                        }
                    }
                }
                log.info("LnHexFilePort.run: normal finish to file");
            }
            catch (InterruptedException interruptedException) {
                if (this.sFile != null) {
                    log.info("LnHexFilePort.run: user selected new file");
                }
                log.error("LnHexFilePort.run: unexpected InterruptedException, exiting");
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception e) {
                log.error("run: Exception: {}", (Object)e.toString());
            }
            this._running = false;
        }
    }

    public void setDelay(int newDelay) {
        this.delay = Math.max(2, newDelay);
    }

    @Override
    public DataInputStream getInputStream() {
        if (this.pin == null) {
            log.error("getInputStream: called before load(), stream not available");
        }
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (this.pout == null) {
            log.error("getOutputStream: called before load(), stream not available");
        }
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.pout != null && this.pin != null;
    }

    public boolean running() {
        return this._running;
    }

    @Override
    public boolean okToSend() {
        return true;
    }

    @Override
    public Vector<String> getPortNames() {
        log.error("getPortNames should not have been invoked", (Throwable)new Exception());
        return null;
    }

    @Override
    public String openPort(String portName, String appName) {
        log.error("openPort should not have been invoked", (Throwable)new Exception());
        return null;
    }

    @Override
    public void configure() {
        log.error("configure should not have been invoked");
    }

    @Override
    public String[] validBaudRates() {
        log.error("validBaudRates should not have been invoked", (Throwable)new Exception());
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }

    public String[] validOption3() {
        return new String[]{Bundle.getMessage("HandleNormal"), Bundle.getMessage("HandleSpread"), Bundle.getMessage("HandleOneOnly"), Bundle.getMessage("HandleBoth")};
    }

    public String option3Name() {
        return "Turnout command handling: ";
    }

    @Override
    public void configureOption3(String value) {
        super.configureOption3(value);
        log.debug("configureOption3: {}", (Object)value);
        this.setTurnoutHandling(value);
    }

    public void simReply(boolean state) {
        this.simReply = state;
        log.debug("SimReply is {}", (Object)this.simReply);
    }

    public boolean simReply() {
        return this.simReply;
    }

    public static LocoNetMessage generateReply(LocoNetMessage m) {
        LocoNetMessage reply = null;
        if (LnSv2MessageContents.isSupportedSv2Message(m)) {
            LnSv2MessageContents c = new LnSv2MessageContents(m);
            if (c.getDestAddr() == -1) {
                log.debug("generate LNSV2 query reply message");
                int dest = 1;
                int myId = 11;
                int mf = 129;
                int dev = 1;
                int type = 3055;
                int serial = 111;
                reply = LnSv2MessageContents.createSv2DeviceDiscoveryReply(myId, dest, mf, dev, type, serial);
            }
        } else if (LncvMessageContents.isSupportedLncvMessage(m)) {
            if (LncvMessageContents.extractMessageType(m) == LncvMessageContents.LncvCommand.LNCV_READ) {
                reply = LncvMessageContents.createLncvReadReply(m);
            } else if (LncvMessageContents.extractMessageType(m) == LncvMessageContents.LncvCommand.LNCV_WRITE) {
                reply = new LocoNetMessage(new int[]{180, 109, 127, 1});
            } else if (LncvMessageContents.extractMessageType(m) == LncvMessageContents.LncvCommand.LNCV_PROG_START) {
                reply = LncvMessageContents.createLncvProgStartReply(m);
            }
        }
        return reply;
    }
}

